/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.codegen;

import org.renjin.repackaged.asm.Type;
import org.renjin.repackaged.asm.commons.InstructionAdapter;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbols;

public class ConstantBytecode {
    public static void generateAttributes(InstructionAdapter mv, AttributeMap constantAttributes) {
        Type builderType = ConstantBytecode.pushAttributeBuilder(mv, constantAttributes);
        mv.invokeinterface(Type.getInternalName(SEXP.class), "setAttributes", Type.getMethodDescriptor(Type.getType(SEXP.class), builderType));
    }

    public static Type pushAttributeBuilder(InstructionAdapter mv, AttributeMap constantAttributes) {
        Type builderType = Type.getType(AttributeMap.Builder.class);
        mv.invokestatic(Type.getInternalName(AttributeMap.class), "newBuilder", Type.getMethodDescriptor(builderType, new Type[0]), false);
        for (PairList.Node node : constantAttributes.nodes()) {
            if (node.getTag() == Symbols.CLASS) {
                ConstantBytecode.pushConstant(mv, node.getValue());
                mv.invokevirtual(builderType.getInternalName(), "setClass", Type.getMethodDescriptor(builderType, Type.getType(SEXP.class)), false);
                continue;
            }
            if (node.getTag() == Symbols.NAMES) {
                ConstantBytecode.pushConstant(mv, node.getValue());
                mv.invokevirtual(builderType.getInternalName(), "setNames", Type.getMethodDescriptor(builderType, Type.getType(SEXP.class)), false);
                continue;
            }
            if (node.getTag() == Symbols.DIM) {
                ConstantBytecode.pushConstant(mv, node.getValue());
                mv.invokevirtual(builderType.getInternalName(), "setDim", Type.getMethodDescriptor(builderType, Type.getType(SEXP.class)), false);
                continue;
            }
            if (node.getTag() == Symbols.DIMNAMES) {
                ConstantBytecode.pushConstant(mv, node.getValue());
                mv.invokevirtual(builderType.getInternalName(), "setDimNames", Type.getMethodDescriptor(builderType, Type.getType(SEXP.class)), false);
                continue;
            }
            mv.aconst(node.getTag().getPrintName());
            ConstantBytecode.pushConstant(mv, node.getValue());
            mv.invokevirtual(builderType.getInternalName(), "set", Type.getMethodDescriptor(builderType, Type.getType(String.class), Type.getType(SEXP.class)), false);
        }
        return builderType;
    }

    public static void pushAttributes(InstructionAdapter mv, AttributeMap constantAttributes) {
        ConstantBytecode.pushAttributeBuilder(mv, constantAttributes);
        mv.invokevirtual(Type.getInternalName(AttributeMap.Builder.class), "build", Type.getMethodDescriptor(Type.getType(AttributeMap.class), new Type[0]), false);
    }

    public static void pushConstant(InstructionAdapter mv, SEXP value) {
        if (value == Null.INSTANCE) {
            mv.visitFieldInsn(178, Type.getInternalName(Null.class), "INSTANCE", Type.getDescriptor(Null.class));
            return;
        }
        if (value instanceof StringVector) {
            if (value.length() == 1 && value.getAttributes().isEmpty()) {
                mv.visitLdcInsn(((StringVector)value).getElementAsString(0));
                mv.invokestatic(Type.getInternalName(StringVector.class), "valueOf", Type.getMethodDescriptor(Type.getType(StringVector.class), Type.getType(String.class)), false);
                return;
            }
        } else if (value instanceof DoubleVector && value.length() == 1) {
            mv.anew(Type.getType(DoubleArrayVector.class));
            mv.dup();
            mv.dconst(((DoubleVector)value).getElementAsDouble(0));
            ConstantBytecode.pushAttributes(mv, value.getAttributes());
            mv.invokespecial(Type.getInternalName(DoubleArrayVector.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, Type.DOUBLE_TYPE, Type.getType(AttributeMap.class)), false);
            return;
        }
        throw new UnsupportedOperationException("TODO: constant = " + value);
    }
}

