/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.codegen;

import java.util.Map;
import org.renjin.compiler.cfg.ControlFlowGraph;
import org.renjin.compiler.codegen.EmitContext;
import org.renjin.compiler.codegen.InlineParamExpr;
import org.renjin.compiler.codegen.VariableSlots;
import org.renjin.repackaged.asm.Label;
import org.renjin.repackaged.asm.Type;
import org.renjin.repackaged.asm.commons.InstructionAdapter;
import org.renjin.repackaged.guava.collect.Maps;
import org.renjin.sexp.Symbol;

public class InlineEmitContext
extends EmitContext {
    private Map<Symbol, InlineParamExpr> inlinedParameters = Maps.newHashMap();
    private final Label exitLabel = new Label();

    public InlineEmitContext(ControlFlowGraph cfg, int paramCount, VariableSlots childSlots) {
        super(cfg, paramCount, childSlots);
    }

    public InlineParamExpr getInlineParameter(Symbol param) {
        InlineParamExpr paramExpr = this.inlinedParameters.get(param);
        if (paramExpr == null) {
            throw new IllegalStateException("No expression set for parameter " + param);
        }
        return paramExpr;
    }

    public void setInlineParameter(Symbol parameterName, InlineParamExpr value) {
        this.inlinedParameters.put(parameterName, value);
    }

    @Override
    public void loadParam(InstructionAdapter mv, Symbol param) {
        InlineParamExpr value = this.inlinedParameters.get(param);
        value.load(mv);
    }

    @Override
    public void writeReturn(InstructionAdapter mv, Type returnType) {
        mv.goTo(this.exitLabel);
    }

    @Override
    public void writeDone(InstructionAdapter mv) {
        super.writeDone(mv);
        mv.mark(this.exitLabel);
    }
}

