/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.expressions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.renjin.compiler.NotCompilableException;
import org.renjin.compiler.builtins.ArgumentBounds;
import org.renjin.compiler.builtins.BuiltinSpecializers;
import org.renjin.compiler.builtins.FailedToSpecializeException;
import org.renjin.compiler.builtins.Specialization;
import org.renjin.compiler.builtins.Specializer;
import org.renjin.compiler.builtins.UnspecializedCall;
import org.renjin.compiler.codegen.EmitContext;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.tac.IRArgument;
import org.renjin.compiler.ir.tac.RuntimeState;
import org.renjin.compiler.ir.tac.expressions.CallExpression;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.repackaged.asm.Type;
import org.renjin.repackaged.asm.commons.InstructionAdapter;
import org.renjin.repackaged.guava.base.Joiner;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.SEXP;

public class BuiltinCall
implements CallExpression {
    private final RuntimeState runtimeState;
    private FunctionCall call;
    private String primitiveName;
    private final List<IRArgument> arguments;
    private final Specializer specializer;
    private Specialization specialization = UnspecializedCall.INSTANCE;

    public BuiltinCall(RuntimeState runtimeState, FunctionCall call2, String primitiveName, List<IRArgument> arguments) {
        this.runtimeState = runtimeState;
        this.call = call2;
        this.primitiveName = primitiveName;
        this.arguments = arguments;
        this.specializer = BuiltinSpecializers.INSTANCE.get(primitiveName);
    }

    @Override
    public int getChildCount() {
        return this.arguments.size();
    }

    @Override
    public Expression childAt(int index) {
        return this.arguments.get(index).getExpression();
    }

    @Override
    public void setChild(int childIndex, Expression child) {
        this.arguments.get(childIndex).setExpression(child);
    }

    @Override
    public boolean isPure() {
        return this.specialization.isPure();
    }

    @Override
    public int load(EmitContext emitContext, InstructionAdapter mv) {
        try {
            this.specialization.load(emitContext, mv, this.arguments);
        }
        catch (FailedToSpecializeException e) {
            throw new NotCompilableException((SEXP)this.call, "Failed to specialize .Primitive(" + this.primitiveName + ")");
        }
        return 1;
    }

    @Override
    public ValueBounds updateTypeBounds(Map<Expression, ValueBounds> typeMap) {
        ArrayList<ArgumentBounds> argumentTypes = new ArrayList<ArgumentBounds>();
        for (IRArgument argument : this.arguments) {
            argumentTypes.add(new ArgumentBounds(argument.getName(), argument.getExpression().updateTypeBounds(typeMap)));
        }
        this.specialization = this.specializer.trySpecialize(this.runtimeState, argumentTypes);
        return this.specialization.getResultBounds();
    }

    @Override
    public Type getType() {
        return this.specialization.getType();
    }

    @Override
    public ValueBounds getValueBounds() {
        return this.specialization.getResultBounds();
    }

    public String toString() {
        return "(" + this.primitiveName + " " + Joiner.on(" ").join(this.arguments) + ")";
    }
}

