/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.expressions;

import java.util.List;
import java.util.Map;
import org.renjin.compiler.NotCompilableException;
import org.renjin.compiler.builtins.ArgumentBounds;
import org.renjin.compiler.cfg.InlinedFunction;
import org.renjin.compiler.codegen.EmitContext;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.tac.IRArgument;
import org.renjin.compiler.ir.tac.RuntimeState;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.eval.MatchedArgumentPositions;
import org.renjin.repackaged.asm.Type;
import org.renjin.repackaged.asm.commons.InstructionAdapter;
import org.renjin.repackaged.guava.base.Joiner;
import org.renjin.sexp.Closure;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.SEXP;

public class ClosureCall
implements Expression {
    private final RuntimeState runtimeState;
    private final FunctionCall call;
    private final List<IRArgument> arguments;
    private final Closure closure;
    private final String debugName;
    private MatchedArgumentPositions matching;
    private InlinedFunction inlinedFunction;
    private ValueBounds returnBounds;
    private Type type;

    public ClosureCall(RuntimeState runtimeState, FunctionCall call2, Closure closure, String closureDebugName, List<IRArgument> arguments) {
        this.runtimeState = runtimeState;
        this.call = call2;
        this.closure = closure;
        this.arguments = arguments;
        this.debugName = closureDebugName;
        this.matching = MatchedArgumentPositions.matchIRArguments(closure, arguments);
        this.returnBounds = ValueBounds.UNBOUNDED;
        this.type = this.returnBounds.storageType();
    }

    @Override
    public boolean isPure() {
        if (this.inlinedFunction == null) {
            return false;
        }
        return this.inlinedFunction.isPure();
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public ValueBounds updateTypeBounds(Map<Expression, ValueBounds> typeMap) {
        if (this.inlinedFunction == null) {
            try {
                this.inlinedFunction = new InlinedFunction(this.runtimeState, this.closure, this.matching.getSuppliedFormals());
            }
            catch (NotCompilableException e) {
                throw new NotCompilableException(this.call, e);
            }
        }
        if (this.matching.hasExtraArguments()) {
            throw new NotCompilableException((SEXP)this.call, "Extra arguments not supported");
        }
        this.returnBounds = this.inlinedFunction.updateBounds(ArgumentBounds.create(this.arguments, typeMap));
        this.type = this.returnBounds.storageType();
        return this.returnBounds;
    }

    @Override
    public ValueBounds getValueBounds() {
        return this.returnBounds;
    }

    @Override
    public int load(EmitContext emitContext, InstructionAdapter mv) {
        if (this.matching.hasExtraArguments()) {
            throw new NotCompilableException((SEXP)this.call, "Extra arguments not supported");
        }
        this.inlinedFunction.writeInline(emitContext, mv, this.matching, this.arguments);
        return 0;
    }

    @Override
    public void setChild(int childIndex, Expression child) {
        this.arguments.get(childIndex).setExpression(child);
    }

    @Override
    public int getChildCount() {
        return this.arguments.size();
    }

    @Override
    public Expression childAt(int index) {
        return this.arguments.get(index).getExpression();
    }

    public String toString() {
        return this.debugName + "(" + Joiner.on(", ").join(this.arguments) + ")";
    }
}

