/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.expressions;

import java.util.Map;
import org.renjin.compiler.codegen.EmitContext;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.primitives.special.DollarFunction;
import org.renjin.repackaged.asm.Type;
import org.renjin.repackaged.asm.commons.InstructionAdapter;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;

public class NamedElementAccess
implements Expression {
    private Expression expression;
    private String memberName;
    private ValueBounds valueBounds;

    public NamedElementAccess(Expression expression2, String memberName) {
        this.expression = expression2;
        this.memberName = memberName;
        this.valueBounds = ValueBounds.UNBOUNDED;
    }

    @Override
    public boolean isPure() {
        return true;
    }

    @Override
    public int load(EmitContext emitContext, InstructionAdapter mv) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ValueBounds updateTypeBounds(Map<Expression, ValueBounds> typeMap) {
        ValueBounds argumentBounds = typeMap.get(this.expression);
        if (argumentBounds.isConstant()) {
            SEXP object2 = argumentBounds.getConstantValue();
            if (object2 instanceof ListVector) {
                this.valueBounds = ValueBounds.of(DollarFunction.fromList((ListVector)object2, this.memberName));
            } else if (object2 instanceof PairList) {
                this.valueBounds = ValueBounds.of(DollarFunction.fromPairList((PairList)object2, this.memberName));
            }
        }
        return this.valueBounds;
    }

    @Override
    public Type getType() {
        return this.valueBounds.storageType();
    }

    @Override
    public ValueBounds getValueBounds() {
        return this.valueBounds;
    }

    @Override
    public void setChild(int childIndex, Expression child) {
        if (childIndex != 0) {
            throw new IllegalArgumentException("childIndex:" + childIndex);
        }
        this.expression = child;
    }

    @Override
    public int getChildCount() {
        return 1;
    }

    @Override
    public Expression childAt(int index) {
        return this.expression;
    }

    public String toString() {
        return this.expression + "$" + this.memberName;
    }
}

