/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.expressions;

import java.util.Map;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.tac.expressions.Expression;

public abstract class SpecializedCallExpression
implements Expression {
    protected final Expression[] arguments;

    public SpecializedCallExpression(Expression ... arguments) {
        this.arguments = arguments;
    }

    @Override
    public final void setChild(int childIndex, Expression child) {
        this.arguments[childIndex] = child;
    }

    @Override
    public final int getChildCount() {
        return this.arguments.length;
    }

    @Override
    public final Expression childAt(int index) {
        return this.arguments[index];
    }

    public abstract boolean isFunctionDefinitelyPure();

    @Override
    public boolean isPure() {
        if (!this.isFunctionDefinitelyPure()) {
            return false;
        }
        for (int i = 0; i != this.arguments.length; ++i) {
            if (this.arguments[i].isPure()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ValueBounds updateTypeBounds(Map<Expression, ValueBounds> typeMap) {
        return ValueBounds.UNBOUNDED;
    }
}

