/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.eval;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.renjin.compiler.builtins.ArgumentBounds;
import org.renjin.compiler.ir.tac.IRArgument;
import org.renjin.eval.ArgumentMatcher;
import org.renjin.sexp.Closure;
import org.renjin.sexp.Symbol;

public class MatchedArgumentPositions {
    private final boolean[] matchedActuals;
    private String[] formalNames;
    private final int[] formalMatches;
    private int extraArgumentCount;

    MatchedArgumentPositions(String[] formalNames, int[] formalMatches, boolean[] matchedActuals) {
        this.formalNames = formalNames;
        this.formalMatches = formalMatches;
        this.matchedActuals = matchedActuals;
        this.extraArgumentCount = 0;
        for (int i = 0; i < matchedActuals.length; ++i) {
            if (matchedActuals[i]) continue;
            ++this.extraArgumentCount;
        }
    }

    public static MatchedArgumentPositions matchIRArguments(Closure closure, List<IRArgument> arguments) {
        String[] names2 = new String[arguments.size()];
        for (int i = 0; i < names2.length; ++i) {
            names2[i] = arguments.get(i).getName();
        }
        return new ArgumentMatcher(closure).match(names2);
    }

    public static MatchedArgumentPositions matchArgumentBounds(Closure closure, List<ArgumentBounds> arguments) {
        String[] names2 = new String[arguments.size()];
        for (int i = 0; i < names2.length; ++i) {
            names2[i] = arguments.get(i).getName();
        }
        return new ArgumentMatcher(closure).match(names2);
    }

    public Set<Symbol> getSuppliedFormals() {
        return this.getMatchedFormals().keySet();
    }

    public int getActualIndex(int formalIndex) {
        return this.formalMatches[formalIndex];
    }

    public Map<Symbol, Integer> getMatchedFormals() {
        HashMap<Symbol, Integer> map = new HashMap<Symbol, Integer>();
        for (int i = 0; i < this.formalMatches.length; ++i) {
            if (this.formalMatches[i] == -1) continue;
            map.put(Symbol.get(this.formalNames[i]), this.formalMatches[i]);
        }
        return map;
    }

    public boolean hasExtraArguments() {
        return this.extraArgumentCount > 0;
    }

    public int getExtraArgumentCount() {
        return this.extraArgumentCount;
    }

    public boolean isExtraArgument(int actualIndex) {
        return !this.matchedActuals[actualIndex];
    }

    public Symbol getFormalName(int i) {
        return Symbol.get(this.formalNames[i]);
    }

    public int getFormalCount() {
        return this.formalNames.length;
    }
}

