/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import java.lang.invoke.MethodHandle;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.FunctionPtr;
import org.renjin.gcc.runtime.Ptr;

public abstract class AbstractPtr
implements Ptr {
    public static final int BITS_PER_BYTE = 8;
    private static final int UNSIGNED_MASK = 255;

    static int mallocSize(int bytes, int size) {
        int count = bytes / size;
        if (bytes % size != 0) {
            ++count;
        }
        return count;
    }

    @Override
    @Deprecated
    public int getOffset() {
        throw new UnsupportedOperationException("No longer supported. Please recompile.");
    }

    @Override
    public void setShort(short value) {
        this.setShort(0, value);
    }

    @Override
    public void setShort(int offset, short value) {
        int intValue = value;
        this.setByte(offset, (byte)(intValue & 0xFF));
        this.setByte(offset + 1, (byte)((intValue >>= 8) & 0xFF));
    }

    @Override
    public short getShort() {
        return this.getShort(0);
    }

    @Override
    public short getShort(int offset) {
        return (short)((this.getByte(offset + 1) & 0xFF) << 8 | this.getByte(offset) & 0xFF);
    }

    @Override
    public short getAlignedShort(int index) {
        return this.getShort(index * 2);
    }

    @Override
    public void setAlignedShort(int index, short shortValue) {
        this.setShort(index * 2, shortValue);
    }

    @Override
    public double getDouble() {
        return this.getDouble(0);
    }

    @Override
    public double getDouble(int offset) {
        return Double.longBitsToDouble(this.getLong(offset));
    }

    @Override
    public double getAlignedDouble(int index) {
        return this.getDouble(index * 8);
    }

    @Override
    public void setAlignedDouble(int index, double value) {
        this.setDouble(index * 8, value);
    }

    @Override
    public double getReal96() {
        return this.getReal96(0);
    }

    @Override
    public double getAlignedReal96(int index) {
        return this.getReal96(index * 12);
    }

    @Override
    public double getReal96(int offset) {
        return Double.longBitsToDouble(this.getLong(offset));
    }

    @Override
    public void setReal96(double value) {
        this.setReal96(0, value);
    }

    @Override
    public void setAlignedReal96(int index, double value) {
        this.setReal96(index * 12, value);
    }

    @Override
    public void setReal96(int offset, double value) {
        this.setLong(offset, Double.doubleToRawLongBits(value));
    }

    @Override
    public char getChar() {
        return this.getChar(0);
    }

    @Override
    public void setAlignedChar(int index, char value) {
        this.setChar(index * 2, value);
    }

    @Override
    public boolean getBoolean() {
        return this.getByte() != 0;
    }

    @Override
    public boolean getBoolean(int offset) {
        return this.getByte(offset) != 0;
    }

    @Override
    public void setBoolean(int offset, boolean value) {
        this.setByte(offset, value ? (byte)1 : 0);
    }

    @Override
    public void setBoolean(boolean value) {
        this.setByte(value ? (byte)1 : 0);
    }

    @Override
    public char getChar(int offset) {
        byte b1 = this.getByte(offset + 1);
        byte b2 = this.getByte(offset + 0);
        return (char)(b1 << 8 | b2 & 0xFF);
    }

    @Override
    public int getInt() {
        return this.getAlignedInt(0);
    }

    @Override
    public int getAlignedInt(int index) {
        return this.getInt(index * 4);
    }

    @Override
    public int getInt(int offset) {
        return (this.getByte(offset + 3) & 0xFF) << 24 | (this.getByte(offset + 2) & 0xFF) << 16 | (this.getByte(offset + 1) & 0xFF) << 8 | this.getByte(offset) & 0xFF;
    }

    @Override
    public byte getByte() {
        return this.getByte(0);
    }

    @Override
    public long getLong() {
        return this.getLong(0);
    }

    @Override
    public long getAlignedLong(int index) {
        return this.getLong(index * 8);
    }

    @Override
    public long getLong(int offset) {
        return ((long)this.getByte(offset + 7) & 0xFFL) << 56 | ((long)this.getByte(offset + 6) & 0xFFL) << 48 | ((long)this.getByte(offset + 5) & 0xFFL) << 40 | ((long)this.getByte(offset + 4) & 0xFFL) << 32 | ((long)this.getByte(offset + 3) & 0xFFL) << 24 | ((long)this.getByte(offset + 2) & 0xFFL) << 16 | ((long)this.getByte(offset + 1) & 0xFFL) << 8 | (long)this.getByte(offset) & 0xFFL;
    }

    @Override
    public float getFloat() {
        return this.getFloat(0);
    }

    @Override
    public float getFloat(int offset) {
        return Float.intBitsToFloat(this.getInt(offset));
    }

    @Override
    public float getAlignedFloat(int index) {
        return this.getFloat(index * 4);
    }

    @Override
    public Ptr getPointer() {
        return this.getPointer(0);
    }

    @Override
    public void setFloat(float value) {
        this.setFloat(0, value);
    }

    @Override
    public void setInt(int value) {
        this.setInt(0, value);
    }

    @Override
    public void setChar(char value) {
        this.setChar(0, value);
    }

    @Override
    public void setByte(byte value) {
        this.setByte(0, value);
    }

    @Override
    public void setDouble(double value) {
        this.setDouble(0, value);
    }

    @Override
    public void setLong(long value) {
        this.setLong(0, value);
    }

    @Override
    public void setPointer(Ptr value) {
        this.setPointer(0, value);
    }

    @Override
    public void setChar(int offset, char value) {
        int intValue = value;
        this.setByte(offset, (byte)(intValue & 0xFF));
        this.setByte(offset + 1, (byte)((intValue >>= 8) & 0xFF));
    }

    @Override
    public void setDouble(int offset, double doubleValue) {
        this.setLong(offset, Double.doubleToRawLongBits(doubleValue));
    }

    @Override
    public void setFloat(int offset, float value) {
        this.setInt(offset, Float.floatToRawIntBits(value));
    }

    @Override
    public void setInt(int offset, int intValue) {
        for (int i = 0; i < 4; ++i) {
            this.setByte(offset + i, (byte)(intValue & 0xFF));
            intValue >>= 8;
        }
    }

    @Override
    public void setLong(int offset, long longValue) {
        for (int i = 0; i < 8; ++i) {
            this.setByte(offset + i, (byte)(longValue & 0xFFL));
            longValue >>= 8;
        }
    }

    @Override
    public char getAlignedChar(int index) {
        return this.getChar(index * 2);
    }

    @Override
    public void setAlignedFloat(int index, float value) {
        this.setFloat(index * 4, value);
    }

    @Override
    public void setAlignedInt(int index, int value) {
        this.setInt(index * 4, value);
    }

    @Override
    public void setAlignedLong(int index, long value) {
        this.setLong(index * 8, value);
    }

    @Override
    public Ptr getAlignedPointer(int index) {
        return this.getPointer(index * 4);
    }

    @Override
    public void setAlignedPointer(int index, Ptr value) {
        this.setPointer(index * 4, value);
    }

    @Override
    public Ptr getPointer(int offset) {
        return BytePtr.NULL.pointerPlus(this.getInt(offset));
    }

    @Override
    public void setPointer(int offset, Ptr value) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public void memset(int intValue, int n) {
        byte byteValue = (byte)intValue;
        for (int i = 0; i < n; ++i) {
            this.setByte(i, byteValue);
        }
    }

    @Override
    public void memcpy(Ptr source, int numBytes) {
        for (int i = 0; i < numBytes; ++i) {
            this.setByte(i, source.getByte(i));
        }
    }

    @Override
    public void memmove(Ptr source, int numBytes) {
        int i;
        byte[] buffer = new byte[numBytes];
        for (i = 0; i < numBytes; ++i) {
            buffer[i] = source.getByte(i);
        }
        for (i = 0; i < numBytes; ++i) {
            this.setByte(i, buffer[i]);
        }
    }

    @Override
    public int memcmp(Ptr that, int numBytes) {
        for (int i = 0; i < numBytes; ++i) {
            int b2;
            int b1 = this.getByte(i) & 0xFF;
            if (b1 < (b2 = that.getByte(i) & 0xFF)) {
                return -1;
            }
            if (b1 <= b2) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public Ptr copyOf(int offset, int numBytes) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public Ptr copyOf(int numBytes) {
        return this.copyOf(0, numBytes);
    }

    @Override
    public MethodHandle toMethodHandle() {
        if (this.isNull()) {
            return null;
        }
        return FunctionPtr.getBadHandle();
    }

    @Override
    public final int compareTo(Ptr o) {
        return AbstractPtr.compare(this, o);
    }

    public static int compare(Ptr x, Ptr y) {
        Object m2;
        Object m1 = x.getArray();
        if (m1 != (m2 = y.getArray())) {
            return Integer.compare(System.identityHashCode(m1), System.identityHashCode(m2));
        }
        if (x.isNull() && y.isNull()) {
            return 0;
        }
        return Integer.compare(x.getOffsetInBytes(), y.getOffsetInBytes());
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof Ptr)) {
            return false;
        }
        Ptr that = (Ptr)obj;
        return this.getArray() == that.getArray() && this.getOffsetInBytes() == that.getOffsetInBytes();
    }
}

