/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import org.renjin.gcc.runtime.AbstractPtr;
import org.renjin.gcc.runtime.OffsetPtr;
import org.renjin.gcc.runtime.Ptr;

public class Double96Ptr
extends AbstractPtr {
    public static final int BYTES = 12;
    private double[] array;
    private int offset;

    public Double96Ptr(double[] array2, int offset) {
        this.array = array2;
        this.offset = offset;
    }

    @Override
    public Object getArray() {
        return this.array;
    }

    @Override
    public int getOffsetInBytes() {
        return this.offset * 12;
    }

    @Override
    public Ptr realloc(int newSizeInBytes) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public Ptr pointerPlus(int bytes) {
        if (bytes % 12 == 0) {
            return new Double96Ptr(this.array, this.offset + bytes / 12);
        }
        return new OffsetPtr(this, bytes);
    }

    @Override
    public byte getByte(int offset) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public void setByte(int offset, byte value) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public double getReal96() {
        return this.array[this.offset];
    }

    @Override
    public double getReal96(int offset) {
        if (offset % 12 == 0) {
            return this.array[this.offset + offset / 12];
        }
        return super.getReal96(offset);
    }

    @Override
    public double getAlignedReal96(int index) {
        return this.array[this.offset + index];
    }

    @Override
    public void setReal96(double value) {
        this.array[this.offset] = value;
    }

    @Override
    public void setReal96(int offset, double value) {
        if (offset % 12 == 0) {
            this.setAlignedReal96(this.offset + offset / 12, value);
        } else {
            super.setAlignedReal96(offset, value);
        }
    }

    @Override
    public void setAlignedReal96(int index, double value) {
        this.array[this.offset + index] = value;
    }

    @Override
    public int toInt() {
        return this.offset;
    }

    @Override
    public boolean isNull() {
        return this.array == null && this.offset == 0;
    }
}

