/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import java.util.Arrays;
import org.renjin.gcc.runtime.AbstractPtr;
import org.renjin.gcc.runtime.Ptr;

public class PointerPtr
extends AbstractPtr {
    private static final int BYTES = 4;
    public static final PointerPtr NULL = new PointerPtr(null, 0);
    private Ptr[] array;
    private int offset;

    public PointerPtr(Ptr[] array2) {
        this.array = array2;
    }

    public PointerPtr(Ptr[] array2, int offset) {
        PointerPtr.checkAligned(offset);
        this.array = array2;
        this.offset = offset;
    }

    public static PointerPtr wrap(Ptr[] array2, int offset) {
        if (array2 == null) {
            return NULL;
        }
        return new PointerPtr(array2, offset);
    }

    public static PointerPtr malloc(Ptr value) {
        return new PointerPtr(new Ptr[]{value}, 0);
    }

    public static PointerPtr malloc(int bytes) {
        Object[] array2 = new Ptr[PointerPtr.mallocSize(bytes, 4)];
        Arrays.fill(array2, NULL);
        return new PointerPtr((Ptr[])array2, 0);
    }

    @Override
    public Object getArray() {
        return this.array;
    }

    @Override
    public int getOffsetInBytes() {
        return this.offset * 4;
    }

    @Override
    public Ptr realloc(int newSizeInBytes) {
        if (this.array == null) {
            return PointerPtr.malloc(newSizeInBytes);
        }
        Ptr[] newArray = new Ptr[PointerPtr.mallocSize(newSizeInBytes, 4)];
        System.arraycopy(this.array, this.offset, newArray, 0, Math.min(this.array.length - this.offset, newArray.length));
        return new PointerPtr(newArray);
    }

    @Override
    public Ptr pointerPlus(int bytes) {
        return new PointerPtr(this.array, this.offset + bytes);
    }

    @Override
    public byte getByte(int offset) {
        int byteOffset = this.offset * 4 + offset;
        int index = byteOffset / 4;
        Ptr ptr = this.array[index];
        if (ptr.isNull()) {
            return 0;
        }
        int intValue = ptr.toInt();
        int shift = byteOffset % 4 * 8;
        return (byte)(intValue >>> shift);
    }

    @Override
    public void setByte(int offset, byte value) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public Ptr getPointer(int offset) {
        return this.array[PointerPtr.checkAligned(this.offset + offset)];
    }

    @Override
    public void setPointer(int offset, Ptr value) {
        this.array[PointerPtr.checkAligned((int)(this.offset + offset))] = value;
    }

    private static int checkAligned(int bytes) {
        if (bytes % 4 != 0) {
            throw new UnsupportedOperationException("Unaligned access");
        }
        return bytes / 4;
    }

    @Override
    public int toInt() {
        return this.offset;
    }

    @Override
    public boolean isNull() {
        return this.array == null && this.offset == 0;
    }

    @Override
    public void memset(int intValue, int n) {
        if (intValue == 0 && this.offset % 4 == 0 && n % 4 == 0) {
            int index = this.offset / 4;
            while (n >= 4) {
                this.array[index] = NULL;
                n -= 4;
                ++index;
            }
        } else {
            super.memset(intValue, n);
        }
    }

    @Override
    public void memcpy(Ptr source, int numBytes) {
        for (int i = 0; i < numBytes; i += 4) {
            this.setPointer(i, source.getPointer(i));
        }
        if (numBytes % 4 != 0) {
            throw new UnsupportedOperationException("TODO");
        }
    }

    @Override
    public Ptr copyOf(int offset, int numBytes) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public Ptr copyOf(int numBytes) {
        throw new UnsupportedOperationException("TODO");
    }
}

