/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.invoke.MethodHandle;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.renjin.gcc.annotations.Struct;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.CharPtr;
import org.renjin.gcc.runtime.CharTypes;
import org.renjin.gcc.runtime.FileHandle;
import org.renjin.gcc.runtime.FileHandleImpl;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.gcc.runtime.LongPtr;
import org.renjin.gcc.runtime.MixedPtr;
import org.renjin.gcc.runtime.ObjectPtr;
import org.renjin.gcc.runtime.OffsetPtr;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.RecordUnitPtr;
import org.renjin.gcc.runtime.timespec;
import org.renjin.gcc.runtime.tm;

public class Stdlib {
    public static final int CLOCKS_PER_SEC = 4;
    private static long PROGRAM_START = System.currentTimeMillis();
    public static BytePtr tzname;
    public static int timezone;
    public static int daylight;
    private static final DateFormat CTIME_FORMAT;
    private static final int CLOCK_REALTIME = 0;
    private static final int CLOCK_MONOTONIC = 1;
    private static final int CLOCK_REALTIME_COARSE = 5;
    private static final ThreadLocal<Random> RANDOM;
    public static final int RAND_MAX = Integer.MAX_VALUE;

    @Deprecated
    public static int strncmp(BytePtr x, BytePtr y, int n) {
        return Stdlib.strncmp((Ptr)x, (Ptr)y, n);
    }

    public static int strncmp(Ptr x, Ptr y, int n) {
        for (int i = 0; i < n; ++i) {
            byte by;
            byte bx = x.getByte(i);
            if (bx < (by = y.getByte(i))) {
                return -1;
            }
            if (bx > by) {
                return 1;
            }
            if (bx == 0) break;
        }
        return 0;
    }

    @Deprecated
    public static int strcmp(BytePtr x, BytePtr y) {
        return Stdlib.strncmp((Ptr)x, (Ptr)y, Integer.MAX_VALUE);
    }

    public static int strcmp(Ptr x, Ptr y) {
        return Stdlib.strncmp(x, y, Integer.MAX_VALUE);
    }

    public static int strcasecmp(Ptr x, Ptr y) {
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            int by;
            int bx = Character.toLowerCase(x.getByte(i));
            if (bx < (by = Character.toLowerCase(y.getByte(i)))) {
                return -1;
            }
            if (bx > by) {
                return 1;
            }
            if (bx == 0) break;
        }
        return 0;
    }

    public static Ptr strchr(Ptr string, int ch) {
        int offset = Stdlib.nullTerminatedString(string).indexOf(ch);
        return new OffsetPtr(string, offset);
    }

    public static Ptr strrchr(Ptr string, int ch) {
        int offset = Stdlib.nullTerminatedString(string).lastIndexOf(ch);
        return new OffsetPtr(string, offset);
    }

    public static Ptr strstr(Ptr string, Ptr searched) {
        int offset = Stdlib.nullTerminatedString(string).indexOf(Stdlib.nullTerminatedString(searched));
        return new OffsetPtr(string, offset);
    }

    public static long strtol(Ptr string) {
        return Long.parseLong(Stdlib.nullTerminatedString(string));
    }

    public static double strtold(Ptr string) {
        return Stdlib.strtod(string);
    }

    public static double strtod(Ptr string) {
        return Double.parseDouble(Stdlib.nullTerminatedString(string));
    }

    public static Ptr strdup(Ptr s) {
        int strlen = Stdlib.strlen(s);
        BytePtr dup = BytePtr.malloc(strlen + 1);
        Stdlib.strcpy((Ptr)dup, s);
        return dup;
    }

    @Deprecated
    public static BytePtr strcpy(BytePtr destination, BytePtr source) {
        return (BytePtr)Stdlib.strcpy((Ptr)destination, (Ptr)source);
    }

    public static Ptr strcpy(Ptr destination, Ptr source) {
        int length2 = Stdlib.strlen(source);
        for (int i = 0; i < length2 + 1; ++i) {
            destination.setByte(i, source.getByte(i));
        }
        return destination;
    }

    @Deprecated
    public static BytePtr strncpy(BytePtr destination, BytePtr source, int num) {
        return (BytePtr)Stdlib.strncpy((Ptr)destination, (Ptr)source, num);
    }

    public static Ptr strncpy(Ptr destination, Ptr source, int num) {
        for (int i = 0; i < num; ++i) {
            byte srcChar = source.getByte(i);
            destination.setByte(i, srcChar);
            if (srcChar == 0) break;
        }
        return destination;
    }

    @Deprecated
    public static int atoi(BytePtr str) {
        return Stdlib.atoi((Ptr)str);
    }

    public static int atoi(Ptr str) {
        try {
            return Integer.parseInt(Stdlib.nullTerminatedString(str));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static double atanh(double x) {
        return 0.5 * Math.log((1.0 + x) / (1.0 - x));
    }

    public static String nullTerminatedString(Ptr x) {
        byte b;
        StringBuilder str = new StringBuilder();
        int i = 0;
        while ((b = x.getByte(i)) != 0) {
            str.append((char)b);
            ++i;
        }
        return str.toString();
    }

    @Deprecated
    public static int strlen(BytePtr x) {
        return Stdlib.strlen((Ptr)x);
    }

    public static int strlen(Ptr x) {
        int len = 0;
        while (x.getByte(len) != 0) {
            ++len;
        }
        return len;
    }

    @Deprecated
    public static BytePtr strcat(BytePtr dest, BytePtr src) {
        return (BytePtr)Stdlib.strcat((Ptr)dest, (Ptr)src);
    }

    public static Ptr strcat(Ptr dest, Ptr src) {
        byte srcByte;
        int destPos = 0;
        while (dest.getByte(destPos) != 0) {
            ++destPos;
        }
        int srcPos = 0;
        do {
            srcByte = src.getByte(srcPos++);
            dest.setByte(destPos++, srcByte);
        } while (srcByte != 0);
        return dest;
    }

    public static int printf(BytePtr format2, Object ... arguments) {
        String outputString;
        try {
            outputString = Stdlib.format(format2, arguments);
        }
        catch (Exception e) {
            return -1;
        }
        System.out.print(outputString);
        return outputString.length();
    }

    public static int puts(BytePtr string) {
        System.out.print(string.nullTerminatedString());
        return 0;
    }

    public static int putchar(int character2) {
        System.out.println((char)character2);
        return character2;
    }

    public static int sprintf(BytePtr string, BytePtr format2, Object ... arguments) {
        return Stdlib.snprintf(string, Integer.MAX_VALUE, format2, arguments);
    }

    public static int snprintf(BytePtr string, int limit, BytePtr format2, Object ... arguments) {
        String outputString;
        try {
            outputString = Stdlib.format(format2, arguments);
        }
        catch (Exception e) {
            return -1;
        }
        byte[] outputBytes = outputString.getBytes();
        int bytesToCopy = Math.min(outputBytes.length, limit - 1);
        if (bytesToCopy > 0) {
            System.arraycopy(outputBytes, 0, string.array, string.offset, bytesToCopy);
            string.array[string.offset + bytesToCopy] = 0;
        }
        return outputBytes.length;
    }

    public static int sscanf(BytePtr format2, Object ... arguments) {
        throw new UnsupportedOperationException("TODO: implement " + Stdlib.class.getName() + ".sscanf");
    }

    public static int tolower(int c2) {
        return Character.toLowerCase(c2);
    }

    public static int toupper(int c2) {
        return Character.toUpperCase(c2);
    }

    public static String format(Ptr format2, Object[] arguments) {
        Object[] convertedArgs = new Object[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            convertedArgs[i] = Stdlib.convertFormatArg(arguments[i]);
        }
        String formatString = Stdlib.nullTerminatedString(format2);
        if (formatString.equals("%2.2x")) {
            return String.format("%02x", convertedArgs);
        }
        if (formatString.equals("%016llx")) {
            return String.format("%016x", convertedArgs);
        }
        return String.format(formatString, convertedArgs);
    }

    private static Object convertFormatArg(Object argument) {
        if (argument instanceof BytePtr || argument instanceof MixedPtr) {
            return Stdlib.nullTerminatedString((Ptr)argument);
        }
        return argument;
    }

    public static void qsort(Ptr base, int nitems, int size, MethodHandle comparator) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static void qsort(Object base, int nitems, int size, MethodHandle comparator) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static ObjectPtr<CharPtr> __ctype_b_loc() {
        return CharTypes.TABLE_OBJECT_PTR;
    }

    @Struct
    public static int[] div(int numer, int denom) {
        int quot = numer / denom;
        int rem = numer % denom;
        return new int[]{quot, rem};
    }

    public static double nearbyint(double arg) {
        return Math.round(arg);
    }

    public static int time(IntPtr seconds) {
        int time2 = (int)(System.currentTimeMillis() / 1000L);
        if (seconds.array != null) {
            seconds.array[seconds.offset] = time2;
        }
        return time2;
    }

    public static BytePtr ctime(IntPtr timePtr) {
        Date date2 = new Date((long)timePtr.get() * 1000L);
        return BytePtr.nullTerminatedString(CTIME_FORMAT.format(date2) + "\n", StandardCharsets.US_ASCII);
    }

    @Deprecated
    public static tm localtime(IntPtr time2) {
        return new tm(time2.unwrap());
    }

    public static Ptr localtime(Ptr time2) {
        int instant = time2.getInt();
        Calendar instance = Calendar.getInstance();
        instance.setTimeInMillis(instant);
        int[] tm2 = new int[]{instance.get(13), instance.get(12), instance.get(10), instance.get(5), instance.get(2), instance.get(1), instance.get(7), instance.get(6), instance.getTimeZone().inDaylightTime(new Date(instant)) ? 1 : 0};
        return new IntPtr(tm2);
    }

    public static void tzset() {
        TimeZone currentTimezone = TimeZone.getDefault();
        tzname = BytePtr.nullTerminatedString(currentTimezone.getDisplayName(), StandardCharsets.US_ASCII);
        timezone = currentTimezone.getOffset(System.currentTimeMillis());
        daylight = currentTimezone.inDaylightTime(new Date()) ? 1 : 0;
    }

    @Deprecated
    public static void fflush(Object file2) {
    }

    public static int clock() {
        long millisSinceProgramStart = System.currentTimeMillis() - PROGRAM_START;
        int secondsSinceProgramStart = (int)TimeUnit.MILLISECONDS.toSeconds(millisSinceProgramStart);
        return secondsSinceProgramStart * 4;
    }

    @Deprecated
    public static int clock_gettime(int clockId, timespec tp) {
        switch (clockId) {
            case 0: 
            case 5: {
                tp.set(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                return 0;
            }
            case 1: {
                tp.set(System.nanoTime(), TimeUnit.NANOSECONDS);
                return 0;
            }
        }
        return -1;
    }

    public static int clock_gettime(int clockId, Ptr tp) {
        TimeUnit timeUnit;
        long duration;
        switch (clockId) {
            case 0: 
            case 5: {
                duration = System.currentTimeMillis();
                timeUnit = TimeUnit.MILLISECONDS;
                break;
            }
            case 1: {
                duration = System.nanoTime();
                timeUnit = TimeUnit.NANOSECONDS;
                break;
            }
            default: {
                return -1;
            }
        }
        int seconds = (int)timeUnit.toSeconds(duration);
        int nanoseconds = (int)(timeUnit.toNanos(duration) - TimeUnit.SECONDS.toNanos(seconds));
        tp.setAlignedInt(0, seconds);
        tp.setAlignedInt(1, nanoseconds);
        return 0;
    }

    @Deprecated
    public static Object fopen() {
        throw new UnsupportedOperationException("Please recompile with the latest version of Renjin.");
    }

    public static Ptr fopen(Ptr filename, Ptr mode) {
        String modeString;
        String filenameString = Stdlib.nullTerminatedString(filename);
        switch (modeString = Stdlib.nullTerminatedString(mode)) {
            case "r": 
            case "rb": {
                try {
                    return new RecordUnitPtr<FileHandleImpl>(new FileHandleImpl(new RandomAccessFile(filenameString, "r")));
                }
                catch (FileNotFoundException e) {
                    return BytePtr.NULL;
                }
            }
            case "w": 
            case "wb": {
                try {
                    return new RecordUnitPtr<FileHandleImpl>(new FileHandleImpl(new RandomAccessFile(filenameString, "rw")));
                }
                catch (FileNotFoundException e) {
                    return BytePtr.NULL;
                }
            }
        }
        throw new UnsupportedOperationException("Not implemented. Mode = " + modeString);
    }

    public static int fflush(Ptr stream) throws IOException {
        FileHandle handle = (FileHandle)stream.getArray();
        handle.flush();
        return 0;
    }

    public static int fprintf(Ptr stream, BytePtr format2, Object ... arguments) {
        try {
            String outputString = Stdlib.format(format2, arguments);
            BytePtr outputBytes = BytePtr.nullTerminatedString(outputString, StandardCharsets.UTF_8);
            int bytesWritten = Stdlib.fwrite(outputBytes, 1, outputBytes.getArray().length, stream);
            return bytesWritten;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static int fwrite(BytePtr ptr, int size, int count, Ptr stream) throws IOException {
        FileHandle handle = (FileHandle)stream.getArray();
        int bytesWritten = 0;
        for (int i = 0; i < count * size; ++i) {
            try {
                handle.write(ptr.getByte(i));
                ++bytesWritten;
                continue;
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                i = count * size;
            }
        }
        return bytesWritten;
    }

    public static int fread(Ptr ptr, int size, int count, Ptr stream) throws IOException {
        int b;
        FileHandle handle = (FileHandle)stream.getArray();
        int bytesRead = 0;
        for (int i = 0; i < count * size && (b = handle.read()) != -1; ++i) {
            ptr.setByte(i, (byte)b);
            ++bytesRead;
        }
        return bytesRead;
    }

    public static int fseek(Ptr stream, long offset, int whence) {
        FileHandle fileHandle = (FileHandle)stream.getArray();
        try {
            switch (whence) {
                case 0: {
                    fileHandle.seekSet(offset);
                    break;
                }
                case 1: {
                    fileHandle.seekCurrent(offset);
                    break;
                }
                case 2: {
                    fileHandle.seekEnd(offset);
                }
            }
            return 0;
        }
        catch (IOException e) {
            return -1;
        }
    }

    public static int fclose(Ptr stream) {
        try {
            ((FileHandle)stream.getArray()).close();
            return 0;
        }
        catch (IOException e) {
            return -1;
        }
    }

    public static int fgetc(Ptr stream) {
        try {
            return ((FileHandle)stream.getArray()).read();
        }
        catch (IOException e) {
            return -1;
        }
    }

    public static int __isinf(double x) {
        return Double.isInfinite(x) ? 1 : 0;
    }

    public static int isinf(double x) {
        return Stdlib.__isinf(x);
    }

    public static float logf(float x) {
        return (float)Math.log(x);
    }

    public static long lroundf(float x) {
        if (Float.isInfinite(x)) {
            if (x < 0.0f) {
                return Long.MIN_VALUE;
            }
            return Long.MAX_VALUE;
        }
        long sign2 = (long)Math.signum(x);
        long closest = Math.round((double)Math.abs(x));
        return closest * sign2;
    }

    public static int __cxa_guard_acquire(LongPtr guard_object) {
        return 1;
    }

    public static void __cxa_guard_release(LongPtr guard_object) {
    }

    public static void __cxa_guard_abort(LongPtr p) {
    }

    public static void __cxa_free_exception(Ptr p) {
    }

    public static void __cxa_call_unexpected(Ptr p) {
    }

    public static int __cxa_atexit(MethodHandle fn, Ptr arg, Ptr dso_handle) {
        return 0;
    }

    public static int posix_memalign(Ptr memPtr, int aligment, int size) {
        memPtr.setPointer(MixedPtr.malloc(size));
        return 0;
    }

    public static void inlineAssembly() {
        throw new UnsupportedOperationException("Compilation of inline assembly not supported");
    }

    public static void srand(int seed2) {
        RANDOM.get().setSeed(seed2);
    }

    public static int rand() {
        return RANDOM.get().nextInt(Integer.MAX_VALUE);
    }

    static {
        CTIME_FORMAT = new SimpleDateFormat("E MMM d HH:mm:ss YYYY");
        RANDOM = new ThreadLocal<Random>(){

            @Override
            protected Random initialValue() {
                return new Random(1L);
            }
        };
    }
}

