/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gnur;

import java.util.Arrays;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntVector;

public class Sort {
    public static void iPsort2(Ptr x, int lo, int hi, int k) {
        boolean nalast = true;
        int L = lo;
        int R2 = hi;
        while (L < R2) {
            int v = x.getAlignedInt(k);
            int i = L;
            int j = R2;
            while (i <= j) {
                while (Sort.icmp(x.getAlignedInt(i), v, nalast) < 0) {
                    ++i;
                }
                while (Sort.icmp(v, x.getAlignedInt(j), nalast) < 0) {
                    --j;
                }
                if (i > j) continue;
                int w = x.getAlignedInt(i);
                x.setAlignedInt(i++, x.getAlignedInt(j));
                x.setAlignedInt(j--, w);
            }
            if (j < k) {
                L = i;
            }
            if (k >= i) continue;
            R2 = j;
        }
    }

    public static void rPsort2(Ptr x, int lo, int hi, int k) {
        boolean nalast = true;
        int L = lo;
        int R2 = hi;
        while (L < R2) {
            double v = x.getAlignedDouble(k);
            int i = L;
            int j = R2;
            while (i <= j) {
                while (Sort.rcmp(x.getAlignedDouble(i), v, nalast) < 0) {
                    ++i;
                }
                while (Sort.rcmp(v, x.getAlignedDouble(j), nalast) < 0) {
                    --j;
                }
                if (i > j) continue;
                double w = x.getAlignedDouble(i);
                x.setAlignedDouble(i++, x.getAlignedDouble(j));
                x.setAlignedDouble(j--, w);
            }
            if (j < k) {
                L = i;
            }
            if (k >= i) continue;
            R2 = j;
        }
    }

    public static void Rf_iPsort(Ptr x, int n, int k) {
        Sort.iPsort2(x, 0, n - 1, k);
    }

    public static void Rf_rPsort(Ptr x, int n, int k) {
        Sort.rPsort2(x, 0, n - 1, k);
    }

    public static void R_isort(IntPtr x, int n) {
        Arrays.sort(x.array, x.offset, x.offset + n);
    }

    public static void R_rsort(DoublePtr x, int n) {
        Arrays.sort(x.array, x.offset, x.offset + n);
    }

    private static int icmp(int x, int y, boolean nalast) {
        boolean nax = IntVector.isNA(x);
        boolean nay = IntVector.isNA(y);
        if (nax && nay) {
            return 0;
        }
        if (nax) {
            return nalast ? 1 : -1;
        }
        if (nay) {
            return nalast ? -1 : 1;
        }
        if (x < y) {
            return -1;
        }
        if (x > y) {
            return 1;
        }
        return 0;
    }

    private static int rcmp(double x, double y, boolean nalast) {
        boolean nax = DoubleVector.isNA(x);
        boolean nay = DoubleVector.isNA(y);
        if (nax && nay) {
            return 0;
        }
        if (nax) {
            return nalast ? 1 : -1;
        }
        if (nay) {
            return nalast ? -1 : 1;
        }
        if (x < y) {
            return -1;
        }
        if (x > y) {
            return 1;
        }
        return 0;
    }
}

