/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gnur.api;

import java.nio.charset.Charset;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.repackaged.guava.base.Charsets;
import org.renjin.sexp.AbstractSEXP;
import org.renjin.sexp.SexpVisitor;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;

public class GnuCharSexp
extends AbstractSEXP {
    public static final GnuCharSexp NA_STRING = new GnuCharSexp(new byte[]{78, 65, 0});
    public static final GnuCharSexp BLANK_STRING = new GnuCharSexp(new byte[]{0});
    private byte[] value;

    public GnuCharSexp(byte[] value) {
        this.value = value;
    }

    public GnuCharSexp(Symbol symbol2) {
        this(symbol2.getPrintName().getBytes(Charsets.UTF_8));
    }

    public static GnuCharSexp valueOf(String value) {
        if (StringVector.isNA(value)) {
            return NA_STRING;
        }
        if (value.isEmpty()) {
            return BLANK_STRING;
        }
        return new GnuCharSexp(BytePtr.nullTerminatedString((String)value, (Charset)Charsets.UTF_8).array);
    }

    @Override
    public String getTypeName() {
        return "char";
    }

    @Override
    public void accept(SexpVisitor visitor) {
    }

    public BytePtr getValue() {
        return new BytePtr(this.value, 0);
    }
}

