/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.invoke.codegen;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.eval.Session;
import org.renjin.invoke.annotations.Materialize;
import org.renjin.invoke.annotations.SessionScoped;
import org.renjin.invoke.codegen.ApplyMethodContext;
import org.renjin.invoke.codegen.CodeModelUtils;
import org.renjin.invoke.codegen.IfElseBuilder;
import org.renjin.invoke.codegen.OverloadComparator;
import org.renjin.invoke.codegen.RecycleLoopBuilder;
import org.renjin.invoke.codegen.WrapperRuntime;
import org.renjin.invoke.codegen.args.ArgConverterStrategies;
import org.renjin.invoke.codegen.args.ArgConverterStrategy;
import org.renjin.invoke.codegen.scalars.ScalarType;
import org.renjin.invoke.codegen.scalars.ScalarTypes;
import org.renjin.invoke.model.JvmMethod;
import org.renjin.invoke.model.PrimitiveModel;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.repackaged.guava.collect.Maps;
import org.renjin.sexp.Environment;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.SEXP;

public class OverloadWrapperBuilder
implements ApplyMethodContext {
    protected JCodeModel codeModel;
    protected JDefinedClass invoker;
    private PrimitiveModel primitive;
    private int arity;
    private List<JVar> arguments = Lists.newArrayList();
    private JVar context;
    private JVar environment;

    public OverloadWrapperBuilder(JCodeModel codeModel, JDefinedClass invoker, PrimitiveModel primitive2, int arity) {
        this.codeModel = codeModel;
        this.invoker = invoker;
        this.primitive = primitive2;
        this.arity = arity;
    }

    public void build() {
        JMethod method = this.invoker.method(17, this.codeModel.ref(SEXP.class), "doApply")._throws(Exception.class);
        this.context = method.param(Context.class, "context");
        this.environment = method.param(Environment.class, "environment");
        for (int i = 0; i != this.arity; ++i) {
            JVar argument = method.param(SEXP.class, "arg" + i);
            this.arguments.add(argument);
        }
        IfElseBuilder matchSequence = new IfElseBuilder(method.body());
        ArrayList<JvmMethod> overloads = Lists.newArrayList(this.primitive.overloadsWithPosArgCountOf(this.arity));
        if (this.primitive.isRelationalOperator()) {
            JVar arg0 = this.arguments.get(0);
            JVar arg1 = this.arguments.get(1);
            Collections.sort(overloads, new OverloadComparator());
            Collections.reverse(overloads);
            method.body()._if(this.codeModel.ref(WrapperRuntime.class).staticInvoke("isEmptyOrNull").arg(arg0).cor(this.codeModel.ref(WrapperRuntime.class).staticInvoke("isEmptyOrNull").arg(arg1)))._then()._return(this.codeModel.ref(LogicalVector.class).staticRef("EMPTY"));
            method.body().assign(JExpr.ref("arg0"), this.codeModel.ref(WrapperRuntime.class).staticInvoke("maybeConvertToStringVector").arg(this.context).arg(arg0));
            method.body().assign(JExpr.ref("arg1"), this.codeModel.ref(WrapperRuntime.class).staticInvoke("maybeConvertToStringVector").arg(this.context).arg(arg1));
            for (JvmMethod overload : overloads) {
                ScalarType scalarType = ScalarTypes.get(overload.getFormals().get(0).getClazz());
                JClass vectorType = this.codeModel.ref(scalarType.getVectorType());
                JBlock stringBlock = matchSequence._if(arg0._instanceof(vectorType).cor(arg1._instanceof(vectorType)));
                this.invokeOverload(overload, stringBlock);
            }
        } else {
            Collections.sort(overloads, new OverloadComparator());
            for (JvmMethod overload : overloads) {
                this.invokeOverload(overload, matchSequence._if(this.argumentsMatch(overload)));
            }
        }
        matchSequence._else()._throw(JExpr._new(this.codeModel.ref(EvalException.class)).arg(this.typeMismatchErrorMessage(this.arguments)));
    }

    private JExpression typeMismatchErrorMessage(List<JVar> arguments) {
        JInvocation format2 = this.codeModel.ref(String.class).staticInvoke("format");
        format2.arg(JExpr.lit(this.typeMessageErrorFormat(arguments.size())));
        for (JVar arg : arguments) {
            format2.arg(arg.invoke("getTypeName"));
        }
        return format2;
    }

    private String typeMessageErrorFormat(int nargs2) {
        String escapedFunctionName = this.primitive.getName().replaceAll("%", "%%");
        StringBuilder message = new StringBuilder();
        message.append("Invalid argument:\n");
        message.append("\t").append(escapedFunctionName).append("(");
        for (int i = 0; i < nargs2; ++i) {
            if (i > 0) {
                message.append(", ");
            }
            message.append("%s");
        }
        message.append(")\n");
        message.append("\tExpected:");
        for (JvmMethod method : this.primitive.getOverloads()) {
            message.append("\n\t");
            method.appendFriendlySignatureTo(escapedFunctionName, message);
        }
        return message.toString();
    }

    private Map<JvmMethod.Argument, JExpression> mapArguments(JvmMethod overload) {
        HashMap<JvmMethod.Argument, JExpression> argumentMap = Maps.newHashMap();
        int argumentPos = 0;
        for (JvmMethod.Argument argument : overload.getAllArguments()) {
            if (argument.isContextual()) {
                if (argument.getClazz().equals(Context.class)) {
                    argumentMap.put(argument, this.context);
                    continue;
                }
                if (argument.getClazz().equals(Environment.class)) {
                    argumentMap.put(argument, this.environment);
                    continue;
                }
                if (argument.getClazz().equals(Session.class)) {
                    argumentMap.put(argument, this.context.invoke("getSession"));
                    continue;
                }
                if (argument.getClazz().getAnnotation(SessionScoped.class) != null) {
                    argumentMap.put(argument, this.context.invoke("getSingleton").arg(JExpr.dotclass(this.codeModel.ref(argument.getClazz()))));
                    continue;
                }
                throw new UnsupportedOperationException(argument.getClazz().getName());
            }
            argumentMap.put(argument, this.convert(argument, this.materialize(overload, argument, this.arguments.get(argumentPos++))));
        }
        return argumentMap;
    }

    private JExpression materialize(JvmMethod overload, JvmMethod.Argument formal, JVar argumentVar) {
        if (overload.isAnnotatedWith(Materialize.class)) {
            return this.context.invoke("materialize").arg(argumentVar);
        }
        return argumentVar;
    }

    private void invokeOverload(JvmMethod overload, JBlock block) {
        if (overload.isDataParallel()) {
            new RecycleLoopBuilder(this.codeModel, block, this.context, this.primitive, overload, this.mapArguments(overload)).build();
        } else {
            this.invokeSimpleMethod(overload, block);
        }
    }

    private void invokeSimpleMethod(JvmMethod overload, JBlock block) {
        JInvocation invocation = this.codeModel.ref(overload.getDeclaringClass()).staticInvoke(overload.getName());
        Map<JvmMethod.Argument, JExpression> argumentMap = this.mapArguments(overload);
        for (JvmMethod.Argument argument : overload.getAllArguments()) {
            invocation.arg(argumentMap.get(argument));
        }
        CodeModelUtils.returnSexp(this.context, this.codeModel, block, overload, invocation);
    }

    private JExpression convert(JvmMethod.Argument argument, JExpression sexp2) {
        return ArgConverterStrategies.findArgConverterStrategy(argument).convertArgument(this, sexp2);
    }

    private JExpression argumentsMatch(JvmMethod overload) {
        JExpression condition = JExpr.TRUE;
        List<JvmMethod.Argument> posFormals = overload.getPositionalFormals();
        for (int i = 0; i != posFormals.size(); ++i) {
            ArgConverterStrategy strategy = ArgConverterStrategies.findArgConverterStrategy(posFormals.get(i));
            JExpression argCondition = strategy.getTestExpr(this.codeModel, this.arguments.get(i));
            condition = condition == null ? argCondition : condition.cand(argCondition);
        }
        return condition;
    }

    @Override
    public JExpression getContext() {
        return this.context;
    }

    @Override
    public JExpression getEnvironment() {
        return this.environment;
    }

    @Override
    public JClass classRef(Class<?> clazz) {
        return this.codeModel.ref(clazz);
    }

    @Override
    public JCodeModel getCodeModel() {
        return this.codeModel;
    }
}

