/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import java.lang.invoke.MethodHandle;
import org.renjin.gcc.runtime.Builtins;
import org.renjin.nmath.rchisq;
import org.renjin.nmath.rgamma;
import org.renjin.nmath.rpois;

public class rnchisq {
    private rnchisq() {
    }

    public static double rnchisq(MethodHandle methodHandle, double d, double d2) {
        if (Builtins.__finite(d) == 0 || Builtins.__finite(d2) == 0 || d < 0.0 || d2 < 0.0) {
            d = Double.NaN;
        } else if (d2 == 0.0) {
            d = d != 0.0 ? rgamma.rgamma(methodHandle, d / 2.0, 2.0) : 0.0;
        } else {
            if ((d2 = rpois.rpois(methodHandle, d2 / 2.0)) > 0.0) {
                d2 = rchisq.rchisq(methodHandle, d2 * 2.0);
            }
            if (d > 0.0) {
                d2 = rgamma.rgamma(methodHandle, d / 2.0, 2.0) + d2;
            }
            d = d2;
        }
        return d;
    }
}

