/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.pipeliner.fusion.node;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.renjin.pipeliner.ComputeMethod;
import org.renjin.pipeliner.fusion.node.LoopNode;
import org.renjin.repackaged.asm.Label;
import org.renjin.repackaged.asm.MethodVisitor;
import org.renjin.repackaged.asm.Type;
import org.renjin.repackaged.guava.base.Optional;
import org.renjin.sexp.Vector;

public class BinaryVectorOpNode
extends LoopNode {
    private String operatorName;
    private LoopNode[] operands = new LoopNode[2];
    private int lengthLocal1;
    private int lengthLocal2;
    private int lengthLocal;
    private Method applyMethod;
    private Class argumentType;

    public BinaryVectorOpNode(String operatorName, Method operator, LoopNode x, LoopNode y) {
        this.operatorName = operatorName;
        this.operands[0] = x;
        this.operands[1] = y;
        this.applyMethod = operator;
        assert (this.applyMethod != null);
        this.argumentType = this.applyMethod.getParameterTypes()[0];
    }

    public static Method findMethod(Vector vector2) {
        for (Method method : vector2.getClass().getMethods()) {
            if (!method.getName().equals("compute") || !Modifier.isPublic(method.getModifiers()) || !Modifier.isStatic(method.getModifiers()) || method.getParameterTypes().length != 2 || !BinaryVectorOpNode.supportedType(method.getReturnType()) || !BinaryVectorOpNode.supportedType(method.getParameterTypes()[0]) || !BinaryVectorOpNode.supportedType(method.getParameterTypes()[1])) continue;
            return method;
        }
        return null;
    }

    @Override
    public void init(ComputeMethod method) {
        MethodVisitor mv = method.getVisitor();
        this.operands[0].init(method);
        this.operands[1].init(method);
        this.lengthLocal1 = method.reserveLocal(1);
        this.lengthLocal2 = method.reserveLocal(1);
        this.lengthLocal = method.reserveLocal(1);
        this.operands[0].pushLength(method);
        mv.visitInsn(89);
        mv.visitVarInsn(54, this.lengthLocal1);
        this.operands[1].pushLength(method);
        mv.visitInsn(89);
        mv.visitVarInsn(54, this.lengthLocal2);
        method.getVisitor().visitMethodInsn(184, "java/lang/Math", "max", "(II)I", false);
        mv.visitVarInsn(54, this.lengthLocal);
    }

    @Override
    public void pushLength(ComputeMethod method) {
        method.getVisitor().visitVarInsn(21, this.lengthLocal);
    }

    @Override
    public void pushElementAsInt(ComputeMethod method, Optional<Label> integerNaLabel) {
        if (this.argumentType.equals(Double.TYPE)) {
            this.computeDouble(method, integerNaLabel);
        } else if (this.argumentType.equals(Integer.TYPE)) {
            this.computeInt(method, integerNaLabel);
        } else {
            throw new UnsupportedOperationException();
        }
        this.cast(method.getVisitor(), this.applyMethod.getReturnType(), Integer.TYPE);
    }

    @Override
    public boolean mustCheckForIntegerNAs() {
        return this.operands[0].mustCheckForIntegerNAs() || this.operands[1].mustCheckForIntegerNAs();
    }

    @Override
    public void appendToKey(StringBuilder key) {
        key.append(this.operatorName);
        key.append('(');
        for (LoopNode operandAccessor : this.operands) {
            operandAccessor.appendToKey(key);
            key.append(';');
        }
        key.append(')');
    }

    @Override
    public void pushElementAsDouble(ComputeMethod method, Optional<Label> naIntegerLabel) {
        if (this.argumentType.equals(Double.TYPE)) {
            this.computeDouble(method, naIntegerLabel);
        } else if (this.argumentType.equals(Integer.TYPE)) {
            this.computeInt(method, naIntegerLabel);
        } else {
            throw new UnsupportedOperationException(this.argumentType.getName());
        }
        this.cast(method.getVisitor(), this.applyMethod.getReturnType(), Double.TYPE);
    }

    private void computeInt(ComputeMethod method, Optional<Label> naLabel) {
        Optional<Label> argNaLabel = Optional.absent();
        if (naLabel.isPresent() && (this.operands[0].mustCheckForIntegerNAs() || this.operands[1].mustCheckForIntegerNAs())) {
            argNaLabel = Optional.of(new Label());
        }
        Optional<Object> done = Optional.absent();
        if (argNaLabel.isPresent()) {
            done = Optional.of(new Label());
        }
        MethodVisitor mv = method.getVisitor();
        mv.visitInsn(89);
        mv.visitVarInsn(21, this.lengthLocal1);
        mv.visitInsn(112);
        this.operands[0].pushElementAsInt(method, argNaLabel);
        mv.visitInsn(95);
        mv.visitVarInsn(21, this.lengthLocal2);
        mv.visitInsn(112);
        this.operands[1].pushElementAsInt(method, argNaLabel);
        mv.visitMethodInsn(184, Type.getInternalName(this.applyMethod.getDeclaringClass()), this.applyMethod.getName(), Type.getMethodDescriptor(this.applyMethod), false);
        if (done.isPresent()) {
            mv.visitJumpInsn(167, (Label)done.get());
        }
        if (argNaLabel.isPresent()) {
            mv.visitLabel(argNaLabel.get());
            mv.visitInsn(87);
            mv.visitJumpInsn(167, naLabel.get());
        }
        if (done.isPresent()) {
            mv.visitLabel((Label)done.get());
        }
    }

    private void computeDouble(ComputeMethod method, Optional<Label> integerNaLabel) {
        Optional<Label> argNaLabel1 = Optional.absent();
        if (integerNaLabel.isPresent() && this.operands[0].mustCheckForIntegerNAs()) {
            argNaLabel1 = Optional.of(new Label());
        }
        Optional<Label> argNaLabel2 = Optional.absent();
        if (integerNaLabel.isPresent() && this.operands[1].mustCheckForIntegerNAs()) {
            argNaLabel2 = Optional.of(new Label());
        }
        Optional<Object> done = Optional.absent();
        if (argNaLabel1.isPresent() || argNaLabel2.isPresent()) {
            done = Optional.of(new Label());
        }
        MethodVisitor mv = method.getVisitor();
        mv.visitInsn(89);
        mv.visitVarInsn(21, this.lengthLocal1);
        mv.visitInsn(112);
        this.operands[0].pushElementAsDouble(method, argNaLabel1);
        mv.visitInsn(93);
        mv.visitInsn(88);
        mv.visitVarInsn(21, this.lengthLocal2);
        mv.visitInsn(112);
        this.operands[1].pushElementAsDouble(method, argNaLabel2);
        mv.visitMethodInsn(184, Type.getInternalName(this.applyMethod.getDeclaringClass()), this.applyMethod.getName(), Type.getMethodDescriptor(this.applyMethod), false);
        if (done.isPresent()) {
            mv.visitJumpInsn(167, (Label)done.get());
        }
        if (argNaLabel1.isPresent()) {
            mv.visitLabel(argNaLabel1.get());
            mv.visitInsn(87);
            mv.visitJumpInsn(167, integerNaLabel.get());
        }
        if (argNaLabel2.isPresent()) {
            mv.visitLabel(argNaLabel2.get());
            mv.visitInsn(87);
            mv.visitInsn(88);
            mv.visitInsn(3);
            mv.visitJumpInsn(167, integerNaLabel.get());
        }
        if (done.isPresent()) {
            mv.visitLabel((Label)done.get());
        }
    }

    public String toString() {
        return "(" + this.operands[0] + this.operatorName + this.operands[1] + ")";
    }
}

