/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.pipeliner.fusion.node;

import org.renjin.pipeliner.ComputeMethod;
import org.renjin.pipeliner.fusion.node.LoopNode;
import org.renjin.repackaged.asm.Label;
import org.renjin.repackaged.asm.MethodVisitor;
import org.renjin.repackaged.asm.Type;
import org.renjin.repackaged.guava.base.Optional;

public class DoubleArrayNode
extends LoopNode {
    private int arrayLocalIndex;
    private int operandIndex;
    private String vectorType;

    public DoubleArrayNode(int operandIndex, Type vectorType) {
        this.operandIndex = operandIndex;
        this.vectorType = vectorType.getInternalName();
    }

    @Override
    public void init(ComputeMethod method) {
        this.arrayLocalIndex = method.reserveLocal(1);
        MethodVisitor mv = method.getVisitor();
        mv.visitVarInsn(25, method.getOperandsLocalIndex());
        this.pushIntConstant(mv, this.operandIndex);
        mv.visitInsn(50);
        mv.visitTypeInsn(192, this.vectorType);
        mv.visitMethodInsn(182, this.vectorType, "toDoubleArrayUnsafe", "()[D", false);
        mv.visitVarInsn(58, this.arrayLocalIndex);
    }

    @Override
    public void pushLength(ComputeMethod method) {
        MethodVisitor mv = method.getVisitor();
        mv.visitVarInsn(25, this.arrayLocalIndex);
        mv.visitInsn(190);
    }

    @Override
    public boolean mustCheckForIntegerNAs() {
        return false;
    }

    @Override
    public void appendToKey(StringBuilder key) {
        key.append("DA");
    }

    @Override
    public void pushElementAsDouble(ComputeMethod method, Optional<Label> integerNaLabel) {
        MethodVisitor mv = method.getVisitor();
        mv.visitVarInsn(25, this.arrayLocalIndex);
        mv.visitInsn(95);
        mv.visitInsn(49);
    }

    public String toString() {
        return "x" + this.operandIndex;
    }
}

