/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.pipeliner.fusion.node;

import org.renjin.pipeliner.ComputeMethod;
import org.renjin.pipeliner.fusion.node.LoopNode;
import org.renjin.pipeliner.node.DeferredNode;
import org.renjin.primitives.sequence.RepDoubleVector;
import org.renjin.repackaged.asm.Label;
import org.renjin.repackaged.asm.MethodVisitor;
import org.renjin.repackaged.guava.base.Optional;

public class RepeatingNode
extends LoopNode {
    private LoopNode sourceNode;
    private LoopNode timesNode;
    private int sourceLengthLocal;

    public RepeatingNode(LoopNode sourceNode, LoopNode timesNode) {
        this.sourceNode = sourceNode;
        this.timesNode = timesNode;
    }

    public static boolean accept(DeferredNode node) {
        return node.getVector() instanceof RepDoubleVector && node.getOperand(2).hasValue(1.0);
    }

    @Override
    public void init(ComputeMethod method) {
        MethodVisitor mv = method.getVisitor();
        this.sourceNode.init(method);
        this.timesNode.init(method);
        this.sourceLengthLocal = method.reserveLocal(1);
        this.sourceNode.pushLength(method);
        mv.visitVarInsn(54, this.sourceLengthLocal);
    }

    @Override
    public void pushLength(ComputeMethod method) {
        MethodVisitor mv = method.getVisitor();
        mv.visitVarInsn(21, this.sourceLengthLocal);
        this.timesNode.pushElementAsInt(method, 0);
        mv.visitInsn(104);
    }

    @Override
    public boolean mustCheckForIntegerNAs() {
        return this.sourceNode.mustCheckForIntegerNAs();
    }

    @Override
    public void appendToKey(StringBuilder key) {
        key.append("rep(");
        this.sourceNode.appendToKey(key);
        key.append(',');
        this.timesNode.appendToKey(key);
        key.append(')');
    }

    @Override
    public void pushElementAsDouble(ComputeMethod method, Optional<Label> integerNaLabel) {
        MethodVisitor mv = method.getVisitor();
        mv.visitVarInsn(21, this.sourceLengthLocal);
        mv.visitInsn(112);
        this.sourceNode.pushElementAsDouble(method);
    }

    public String toString() {
        return "rep(" + this.sourceNode + ", " + this.timesNode + ")";
    }
}

