/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import org.apache.commons.math.complex.Complex;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.Builtin;
import org.renjin.invoke.annotations.DataParallel;
import org.renjin.invoke.annotations.GroupGeneric;
import org.renjin.invoke.annotations.PreserveAttributeStyle;
import org.renjin.primitives.sequence.RepDoubleVector;
import org.renjin.primitives.vector.ConvertingDoubleVector;
import org.renjin.primitives.vector.ImaginaryVector;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.ComplexVector;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.LogicalVector;

@GroupGeneric(value="Complex")
public class ComplexGroup {
    @Builtin
    @DataParallel(value=PreserveAttributeStyle.ALL)
    public static double Mod(Complex z) {
        return z.abs();
    }

    @Builtin
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double Mod(double x) {
        return Math.abs(x);
    }

    @Builtin
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double Arg(Complex z) {
        if (ComplexVector.isNA(z)) {
            return DoubleVector.NA;
        }
        return z.getArgument();
    }

    @Builtin
    public static DoubleVector Re(AtomicVector x) {
        if (x instanceof ComplexVector) {
            return new ConvertingDoubleVector(x, x.getAttributes());
        }
        if (x instanceof DoubleVector || x instanceof IntVector || x instanceof LogicalVector) {
            return DoubleVector.VECTOR_TYPE.to(x);
        }
        throw new EvalException("non-numeric argument to function", new Object[0]);
    }

    @Builtin
    public static DoubleVector Im(AtomicVector x) {
        if (x instanceof ComplexVector) {
            return new ImaginaryVector((ComplexVector)x, x.getAttributes());
        }
        if (x instanceof DoubleVector || x instanceof IntVector || x instanceof LogicalVector) {
            if (x.length() < 10) {
                return new DoubleArrayVector(new double[x.length()], x.getAttributes());
            }
            return new RepDoubleVector(DoubleVector.valueOf(0.0), x.length(), 1, x.getAttributes());
        }
        throw new EvalException("non-numeric argument to function", new Object[0]);
    }

    @Builtin
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double Conj(double x) {
        return x;
    }

    @Builtin
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static Complex Conj(Complex z) {
        return ComplexVector.complex(z.getReal(), -1.0 * z.getImaginary());
    }
}

