/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.renjin.base.Base;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.eval.Profiler;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.gcc.runtime.ObjectPtr;
import org.renjin.invoke.annotations.ArgumentList;
import org.renjin.invoke.annotations.Builtin;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Internal;
import org.renjin.invoke.annotations.NamedFlag;
import org.renjin.invoke.reflection.ClassBindingImpl;
import org.renjin.invoke.reflection.FunctionBinding;
import org.renjin.methods.Methods;
import org.renjin.primitives.NativeStringVector;
import org.renjin.primitives.packaging.DllInfo;
import org.renjin.primitives.packaging.DllSymbol;
import org.renjin.primitives.packaging.Namespace;
import org.renjin.repackaged.guava.base.Charsets;
import org.renjin.repackaged.guava.base.Optional;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.ExternalPtr;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;

public class Native {
    public static final boolean DEBUG = false;
    public static final ThreadLocal<Context> CURRENT_CONTEXT = new ThreadLocal();

    public static Context currentContext() {
        Context context = CURRENT_CONTEXT.get();
        if (context == null) {
            throw new IllegalStateException("Renjin context not initialized for this thread.");
        }
        return context;
    }

    @Internal
    public static ListVector getLoadedDLLs(@Current Context context) {
        ListVector.NamedBuilder list2 = new ListVector.NamedBuilder();
        list2.setAttribute(Symbols.CLASS, (SEXP)StringVector.valueOf("DLLInfoList"));
        for (DllInfo dllInfo : context.getSession().getLoadedLibraries()) {
            list2.add(dllInfo.getLibraryName(), dllInfo.buildDllInfoSexp());
        }
        return list2.build();
    }

    @Internal
    public static ListVector getRegisteredRoutines(DllInfo dllInfo) {
        return dllInfo.buildRegisteredRoutinesSexp();
    }

    @Internal
    public static ListVector getSymbolInfo(@Current Context context, String name, String packageName, boolean withRegistrationInfo) {
        if (packageName.isEmpty()) {
            for (DllInfo dllInfo : context.getSession().getLoadedLibraries()) {
                Optional<DllSymbol> symbol2 = dllInfo.getSymbol(name);
                if (!symbol2.isPresent()) continue;
                return symbol2.get().buildNativeSymbolInfoSexp();
            }
            throw new EvalException("No such symbol " + name, new Object[0]);
        }
        Optional<Namespace> namespace = context.getNamespaceRegistry().getNamespaceIfPresent(Symbol.get(packageName));
        if (namespace.isPresent()) {
            for (DllInfo dllInfo : namespace.get().getLibraries()) {
                Optional<DllSymbol> symbol3 = dllInfo.getSymbol(name);
                if (!symbol3.isPresent()) continue;
                return symbol3.get().buildNativeSymbolInfoSexp();
            }
        }
        throw new EvalException("No such symbol " + name + " in package " + packageName, new Object[0]);
    }

    @Internal
    public static ListVector getSymbolInfo(String name, DllInfo dllInfo, boolean withRegistrationInfo) {
        Optional<DllSymbol> registeredSymbol = dllInfo.getRegisteredSymbol(name);
        if (registeredSymbol.isPresent()) {
            return registeredSymbol.get().buildNativeSymbolInfoSexp();
        }
        throw new EvalException("No such symbol " + name + " in library " + dllInfo.getLibraryName(), new Object[0]);
    }

    @Builtin(value=".C")
    public static SEXP dotC(@Current Context context, @Current Environment rho, SEXP methodExp, @ArgumentList ListVector callArguments, @NamedFlag(value="PACKAGE") String packageName, @NamedFlag(value="NAOK") boolean naOk, @NamedFlag(value="DUP") boolean dup, @NamedFlag(value="COPY") boolean copy2, @NamedFlag(value="ENCODING") boolean encoding) throws IllegalAccessException {
        if ("base".equals(packageName)) {
            return Native.delegateToJavaMethod(context, methodExp, packageName, null, callArguments);
        }
        DllSymbol method = Native.findMethod(context, methodExp, packageName, null, DllSymbol.Convention.C);
        MethodHandle handle = method.getMethodHandle();
        Object[] nativeArguments = new Object[handle.type().parameterCount()];
        for (int i = 0; i != nativeArguments.length; ++i) {
            TypeDescriptor.OfField type = handle.type().parameterType(i);
            SEXP callArgument = callArguments.get(i);
            if (callArgument instanceof IntVector || callArgument instanceof LogicalVector) {
                nativeArguments[i] = Native.intPtrFromVector(callArguments.get(i));
                continue;
            }
            if (callArgument instanceof DoubleVector) {
                nativeArguments[i] = Native.doublePtrFromVector(callArguments.get(i));
                continue;
            }
            if (callArgument instanceof StringVector) {
                nativeArguments[i] = Native.stringPtrToCharPtrPtr(callArguments.get(i));
                continue;
            }
            throw new EvalException("Don't know how to marshall type " + callArguments.get(i).getClass().getName() + " to for C argument " + type + " in call to " + handle, new Object[0]);
        }
        if (Profiler.ENABLED) {
            Profiler.functionStart(Symbol.get(method.getName()), 'C');
        }
        Context previousContext = CURRENT_CONTEXT.get();
        CURRENT_CONTEXT.set(context);
        try {
            handle.invokeWithArguments(nativeArguments);
        }
        catch (Error | EvalException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new EvalException(e.getMessage(), e);
        }
        finally {
            CURRENT_CONTEXT.set(previousContext);
            if (Profiler.ENABLED) {
                Profiler.functionEnd();
            }
        }
        ListVector.NamedBuilder builder = new ListVector.NamedBuilder();
        for (int i = 0; i != nativeArguments.length; ++i) {
            builder.add(callArguments.getName(i), Native.sexpFromPointer(nativeArguments[i], callArguments.get(i).getAttributes()));
        }
        return builder.build();
    }

    private static ObjectPtr stringPtrToCharPtrPtr(SEXP sexp2) {
        if (!(sexp2 instanceof StringVector)) {
            throw new EvalException(".C function expected 'character', but argument was '%s'", sexp2.getTypeName());
        }
        StringVector vector2 = (StringVector)sexp2;
        Object[] strings = new BytePtr[sexp2.length()];
        for (int i = 0; i < sexp2.length(); ++i) {
            String element = vector2.getElementAsString(i);
            if (element == null) continue;
            strings[i] = BytePtr.nullTerminatedString(element, Charsets.UTF_8);
        }
        return new ObjectPtr(strings, 0);
    }

    private static SEXP sexpFromPointer(Object ptr, AttributeMap attributes2) {
        if (ptr instanceof DoublePtr) {
            return DoubleArrayVector.unsafe(((DoublePtr)ptr).array, attributes2);
        }
        if (ptr instanceof IntPtr) {
            return new IntArrayVector(((IntPtr)ptr).array, attributes2);
        }
        if (ptr instanceof ObjectPtr) {
            return new NativeStringVector((ObjectPtr)ptr, attributes2);
        }
        throw new UnsupportedOperationException(ptr.toString());
    }

    private static DoublePtr doublePtrFromVector(SEXP sexp2) {
        if (!(sexp2 instanceof AtomicVector)) {
            throw new EvalException("expected atomic vector", new Object[0]);
        }
        return new DoublePtr(((AtomicVector)sexp2).toDoubleArray());
    }

    private static IntPtr intPtrFromVector(SEXP sexp2) {
        if (!(sexp2 instanceof AtomicVector)) {
            throw new EvalException("expected atomic vector", new Object[0]);
        }
        AtomicVector vector2 = (AtomicVector)sexp2;
        int[] array2 = new int[vector2.length()];
        for (int i = 0; i != array2.length; ++i) {
            array2[i] = vector2.getElementAsInt(i);
        }
        return new IntPtr(array2, 0);
    }

    @Builtin(value=".Fortran")
    public static SEXP dotFortran(@Current Context context, @Current Environment rho, SEXP methodExp, @ArgumentList ListVector callArguments, @NamedFlag(value="PACKAGE") String packageName, @NamedFlag(value="CLASS") String className, @NamedFlag(value="NAOK") boolean naOk, @NamedFlag(value="DUP") boolean dup, @NamedFlag(value="ENCODING") boolean encoding) throws IllegalAccessException {
        DllSymbol method = Native.findMethod(context, methodExp, packageName, className, DllSymbol.Convention.FORTRAN);
        Class<?>[] fortranTypes = method.getMethodHandle().type().parameterArray();
        if (fortranTypes.length != callArguments.length()) {
            throw new EvalException("Invalid number of args", new Object[0]);
        }
        Object[] fortranArgs = new Object[fortranTypes.length];
        ListVector.NamedBuilder returnValues = ListVector.newNamedBuilder();
        if (Profiler.ENABLED) {
            Profiler.functionStart(Symbol.get(method.getName()), 'F');
        }
        for (int i = 0; i != callArguments.length(); ++i) {
            Object[] array2;
            AtomicVector vector2 = (AtomicVector)callArguments.get(i);
            if (vector2 instanceof DoubleVector) {
                array2 = vector2.toDoubleArray();
                fortranArgs[i] = new DoublePtr((double[])array2, 0);
                returnValues.add(callArguments.getName(i), (SEXP)DoubleArrayVector.unsafe(array2, vector2.getAttributes()));
                continue;
            }
            if (vector2 instanceof IntVector || vector2 instanceof LogicalVector) {
                array2 = vector2.toIntArray();
                fortranArgs[i] = new IntPtr((int[])array2, 0);
                returnValues.add(callArguments.getName(i), (SEXP)IntArrayVector.unsafe((int[])array2, vector2.getAttributes()));
                continue;
            }
            throw new UnsupportedOperationException("fortran type: " + vector2.getTypeName());
        }
        Context previousContext = CURRENT_CONTEXT.get();
        CURRENT_CONTEXT.set(context);
        try {
            method.getMethodHandle().invokeWithArguments(fortranArgs);
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new EvalException("Exception thrown while executing " + method.getName(), e);
        }
        finally {
            CURRENT_CONTEXT.set(previousContext);
            if (Profiler.ENABLED) {
                Profiler.functionEnd();
            }
        }
        return returnValues.build();
    }

    private static boolean[] toBooleanArray(AtomicVector vector2) {
        boolean[] array2 = new boolean[vector2.length()];
        for (int i = 0; i < vector2.length(); ++i) {
            int element = vector2.getElementAsRawLogical(i);
            if (element == Integer.MIN_VALUE) {
                throw new EvalException("NAs cannot be passed to logical fortran argument", new Object[0]);
            }
            array2[i] = element != 0;
        }
        return array2;
    }

    @Builtin(value=".Call")
    public static SEXP redotCall(@Current Context context, @Current Environment rho, SEXP methodExp, @ArgumentList ListVector callArguments, @NamedFlag(value="PACKAGE") String packageName, @NamedFlag(value="COPY") boolean copy2, @NamedFlag(value="CLASSES") StringVector classes, @NamedFlag(value="CLASS") String className) throws ClassNotFoundException {
        if ("base".equals(packageName) || "methods".equals(packageName) || className != null) {
            return Native.delegateToJavaMethod(context, methodExp, packageName, className, callArguments);
        }
        DllSymbol method = Native.findMethod(context, methodExp, packageName, className, DllSymbol.Convention.CALL);
        MethodHandle methodHandle = method.getMethodHandle();
        if (methodHandle.type().parameterCount() != callArguments.length()) {
            throw new EvalException("Expected %d arguments, found %d in call to %s", methodHandle.type().parameterCount(), callArguments.length(), method.getName());
        }
        MethodHandle transformedHandle = methodHandle.asSpreader(SEXP[].class, methodHandle.type().parameterCount());
        SEXP[] arguments = Native.toSexpArray(callArguments);
        if (Profiler.ENABLED) {
            Profiler.functionStart(Symbol.get(method.getName()), 'C');
        }
        Context previousContext = CURRENT_CONTEXT.get();
        try {
            SEXP result;
            CURRENT_CONTEXT.set(context);
            if (transformedHandle.type().returnType().equals(Void.TYPE)) {
                transformedHandle.invokeExact(arguments);
                Null nullVal = Null.INSTANCE;
                return nullVal;
            }
            SEXP sEXP = result = transformedHandle.invokeExact(arguments);
            return sEXP;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new EvalException("Exception calling " + method.getName() + " : " + e.getMessage(), e);
        }
        finally {
            CURRENT_CONTEXT.set(previousContext);
            if (Profiler.ENABLED) {
                Profiler.functionEnd();
            }
        }
    }

    @Builtin(value=".External")
    public static SEXP external(@Current Context context, @Current Environment rho, SEXP methodExp, @ArgumentList ListVector callArguments, @NamedFlag(value="PACKAGE") String packageName, @NamedFlag(value="CLASS") String className) throws ClassNotFoundException {
        DllSymbol symbol2 = Native.findMethod(context, methodExp, packageName, className, DllSymbol.Convention.EXTERNAL);
        MethodHandle methodHandle = symbol2.getMethodHandle();
        if (methodHandle.type().parameterCount() != 1) {
            throw new EvalException("Expected method with single argument, found %d", methodHandle.type().parameterCount(), callArguments.length());
        }
        PairList.Node argumentList = new PairList.Node(StringVector.valueOf(symbol2.getName()), PairList.Node.fromVector(callArguments));
        if (Profiler.ENABLED) {
            StringVector nameExp = (StringVector)((ListVector)methodExp).get("name");
            Profiler.functionStart(Symbol.get(nameExp.getElementAsString(0)), 'C');
        }
        Context previousContext = CURRENT_CONTEXT.get();
        try {
            CURRENT_CONTEXT.set(context);
            if (methodHandle.type().returnType().equals(Void.TYPE)) {
                methodHandle.invokeExact(argumentList);
                Null nullVal = Null.INSTANCE;
                return nullVal;
            }
            SEXP sEXP = methodHandle.invokeExact(argumentList);
            return sEXP;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new EvalException("Exception calling " + methodExp + " : " + e.getMessage(), e);
        }
        finally {
            CURRENT_CONTEXT.set(previousContext);
            if (Profiler.ENABLED) {
                Profiler.functionEnd();
            }
        }
    }

    @Builtin(value=".External2")
    public static SEXP external2(@Current Context context, SEXP methodExp, @ArgumentList ListVector callArguments, @NamedFlag(value="PACKAGE") String packageName, @NamedFlag(value="CLASS") String className) throws ClassNotFoundException {
        DllSymbol symbol2 = Native.findMethod(context, methodExp, packageName, className, DllSymbol.Convention.EXTERNAL);
        MethodHandle methodHandle = symbol2.getMethodHandle();
        if (methodHandle.type().parameterCount() != 4) {
            throw new EvalException("Expected method with four arguments, found %d", methodHandle.type().parameterCount(), callArguments.length());
        }
        FunctionCall call2 = context.getCall();
        Null op = Null.INSTANCE;
        PairList.Node args2 = new PairList.Node(StringVector.valueOf(symbol2.getName()), PairList.Node.fromVector(callArguments));
        Environment rho = context.getEnvironment();
        if (Profiler.ENABLED) {
            StringVector nameExp = (StringVector)((ListVector)methodExp).get("name");
            Profiler.functionStart(Symbol.get(nameExp.getElementAsString(0)), 'C');
        }
        Context previousContext = CURRENT_CONTEXT.get();
        try {
            CURRENT_CONTEXT.set(context);
            if (methodHandle.type().returnType().equals(Void.TYPE)) {
                methodHandle.invokeExact(call2, op, args2, rho);
                Null nullVal = Null.INSTANCE;
                return nullVal;
            }
            SEXP sEXP = methodHandle.invokeExact(call2, op, args2, rho);
            return sEXP;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new EvalException("Exception calling " + methodExp + " : " + e.getMessage(), e);
        }
        finally {
            CURRENT_CONTEXT.set(previousContext);
            if (Profiler.ENABLED) {
                Profiler.functionEnd();
            }
        }
    }

    private static SEXP[] toSexpArray(ListVector callArguments) {
        SEXP[] args2 = new SEXP[callArguments.length()];
        for (int i = 0; i < callArguments.length(); ++i) {
            args2[i] = callArguments.get(i);
        }
        return args2;
    }

    public static SEXP delegateToJavaMethod(Context context, SEXP method, String packageName, String className, ListVector arguments) {
        Class declaringClass;
        if ("base".equals(packageName)) {
            declaringClass = Base.class;
        } else if ("methods".equals(packageName)) {
            declaringClass = Methods.class;
        } else {
            try {
                declaringClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new EvalException("Cannot find JVM class " + className, new Object[0]);
            }
        }
        ClassBindingImpl classBinding = ClassBindingImpl.get(declaringClass);
        FunctionBinding functionBinding = classBinding.getStaticMethodBinding(method.asString());
        return functionBinding.invoke(null, context, arguments);
    }

    private static DllSymbol findMethod(Context context, SEXP method, String packageName, String className, DllSymbol.Convention convention) {
        if (method.inherits("NativeSymbolInfo")) {
            return DllSymbol.fromSexp(method);
        }
        if (method.inherits("NativeSymbol") || method.inherits("RegisteredNativeSymbol")) {
            return DllSymbol.fromAddressSexp(method);
        }
        if (method instanceof ExternalPtr) {
            return Native.findMethodFromExternalPointer((ExternalPtr)method);
        }
        if (method instanceof StringVector) {
            return Native.findMethodByName(context, method.asString(), packageName, className, convention);
        }
        throw new EvalException("Invalid method object of type '%s'", method.getTypeName());
    }

    private static DllSymbol findMethodFromExternalPointer(ExternalPtr<?> method) {
        if (method.getInstance() instanceof Method) {
            return new DllSymbol((Method)method.getInstance());
        }
        throw new EvalException("Invalid method external pointer of (java) class '%s'", method.getInstance().getClass().getName());
    }

    private static DllSymbol findMethodByName(Context context, String methodName, String packageName, String className, DllSymbol.Convention convention) {
        if (className != null) {
            return Native.findMethodByReflection(methodName, className);
        }
        if (packageName == null) {
            return Native.findGlobalMethodByName(context, convention, methodName);
        }
        Namespace namespace = context.getNamespaceRegistry().getNamespace(context, packageName);
        Optional<DllSymbol> symbol2 = namespace.lookupSymbol(convention, methodName);
        if (!symbol2.isPresent()) {
            throw new EvalException("Could not resolve native method '%s' in package '%s'", methodName, packageName);
        }
        return symbol2.get();
    }

    private static DllSymbol findMethodByReflection(String methodName, String className) {
        Class<?> declaringClass = null;
        try {
            declaringClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new EvalException("Could not find Java class " + className, new Object[0]);
        }
        return Native.findMethodByReflection(methodName, declaringClass);
    }

    private static DllSymbol findMethodByReflection(String methodName, Class<?> declaringClass) {
        for (Method method : declaringClass.getMethods()) {
            if (!method.getName().equals(methodName) || !Modifier.isPublic(method.getModifiers()) || !Modifier.isStatic(method.getModifiers())) continue;
            return new DllSymbol(method);
        }
        throw new EvalException("Could not find method %s in class %s", methodName, declaringClass.getName());
    }

    private static DllSymbol findGlobalMethodByName(Context context, DllSymbol.Convention convention, String methodName) {
        for (DllInfo library2 : context.getSession().getLoadedLibraries()) {
            Optional<DllSymbol> symbol2 = library2.lookup(convention, methodName);
            if (!symbol2.isPresent()) continue;
            return symbol2.get();
        }
        throw new EvalException("Could not resolve native method '%s'", methodName);
    }
}

