/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.renjin.compiler.ir.TypeSet;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.eval.Calls;
import org.renjin.eval.ClosureDispatcher;
import org.renjin.eval.Context;
import org.renjin.eval.DispatchChain;
import org.renjin.eval.EvalException;
import org.renjin.eval.Profiler;
import org.renjin.invoke.annotations.ArgumentList;
import org.renjin.invoke.annotations.Builtin;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Internal;
import org.renjin.invoke.codegen.ArgumentIterator;
import org.renjin.primitives.Primitives;
import org.renjin.primitives.Types;
import org.renjin.primitives.packaging.Namespace;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.repackaged.guava.collect.PeekingIterator;
import org.renjin.repackaged.guava.collect.Sets;
import org.renjin.repackaged.guava.primitives.Ints;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.Closure;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.Frame;
import org.renjin.sexp.Function;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.HashFrame;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.LogicalArrayVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.NamedValue;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.PrimitiveFunction;
import org.renjin.sexp.Promise;
import org.renjin.sexp.PromisePairList;
import org.renjin.sexp.S4Object;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class S3 {
    public static final Symbol METHODS_TABLE = Symbol.get(".__S3MethodsTable__.");
    public static final Set<String> GROUPS = Sets.newHashSet("Ops", "Math", "Summary");
    private static final Set<String> ARITH_GROUP = Sets.newHashSet("+", "-", "*", "^", "%%", "%/%", "/");
    private static final Set<String> COMPARE_GROUP = Sets.newHashSet("==", ">", "<", "!=", "<=", ">=");
    private static final Set<String> LOGIC_GROUP = Sets.newHashSet("&", "&&", "|", "||", "xor");
    private static final Set<String> SPECIAL = Sets.newHashSet("$", "$<-");
    private static final Symbol NA_RM = Symbol.get("na.rm");

    @Builtin
    public static SEXP UseMethod(@Current Context context, String genericMethodName) {
        if (context.getArguments().length() == 0) {
            return S3.UseMethod(context, genericMethodName, Null.INSTANCE);
        }
        SEXP object2 = context.evaluate((SEXP)context.getArguments().getElementAsSEXP(0), context.getParent().getEnvironment());
        return S3.UseMethod(context, genericMethodName, object2);
    }

    @Builtin
    public static SEXP UseMethod(@Current Context context, String genericMethodName, SEXP object2) {
        return Resolver.start(context, genericMethodName, object2).withDefinitionEnvironment(((Closure)context.getFunction()).getEnclosingEnvironment()).next().apply(context, context.getEnvironment());
    }

    @Internal
    public static SEXP NextMethod(@Current Context context, @Current Environment env2, SEXP generic, SEXP object2, @ArgumentList ListVector extraArgs) {
        return Resolver.resume(context).withGenericArgument(generic).withObjectArgument(object2).next().applyNext(context, context.getEnvironment(), extraArgs);
    }

    public static StringVector computeDataClasses(ValueBounds valueBounds) {
        if (!valueBounds.isClassAttributeConstant()) {
            return null;
        }
        AtomicVector classAttribute = valueBounds.getConstantClassAttribute();
        if (classAttribute.length() > 0) {
            return (StringVector)classAttribute;
        }
        if (!valueBounds.isDimCountConstant()) {
            return null;
        }
        int typeSet = valueBounds.getTypeSet();
        String implicitClass = TypeSet.implicitClass(typeSet);
        if (implicitClass == null) {
            return null;
        }
        StringVector.Builder dataClass = new StringVector.Builder();
        int dimCount = valueBounds.getConstantDimCount();
        if (dimCount == 2) {
            dataClass.add("matrix");
        } else if (dimCount > 0) {
            dataClass.add("array");
        }
        dataClass.add(implicitClass);
        if ((typeSet & 0x30) != 0) {
            dataClass.add("numeric");
        }
        return dataClass.build();
    }

    public static StringVector computeDataClasses(Context context, SEXP exp2) {
        SEXP classAttribute = (exp2 = exp2.force(context)).getAttribute(Symbols.CLASS);
        if (classAttribute.length() > 0) {
            return (StringVector)classAttribute;
        }
        StringVector.Builder dataClass = new StringVector.Builder();
        SEXP dim2 = exp2.getAttribute(Symbols.DIM);
        if (dim2.length() == 2) {
            dataClass.add("matrix");
        } else if (dim2.length() > 0) {
            dataClass.add("array");
        }
        if (exp2 instanceof IntVector) {
            dataClass.add("integer");
            dataClass.add("numeric");
        } else if (exp2 instanceof DoubleVector) {
            dataClass.add("double");
            dataClass.add("numeric");
        } else {
            dataClass.add(exp2.getImplicitClass());
        }
        return dataClass.build();
    }

    public static SEXP dispatchGroup(String group, FunctionCall call2, String opName, PairList args2, Context context, Environment rho) {
        if (call2.getFunction() instanceof Symbol && ((Symbol)call2.getFunction()).getPrintName().endsWith(".default")) {
            return null;
        }
        boolean isOps = group.equals("Ops");
        int nargs2 = isOps ? args2.length() : 1;
        for (int k = 0; k < nargs2; ++k) {
            if (!Types.isS4(args2.getElementAsSEXP(k))) continue;
            return S3.handleS4object(context, args2.getElementAsSEXP(0), args2, rho, group, opName);
        }
        if (opName.equals("%*%")) {
            return null;
        }
        GenericMethod left = Resolver.start(context, rho, group, opName, args2.getElementAsSEXP(0)).withBaseDefinitionEnvironment().findNext();
        GenericMethod right = null;
        if (nargs2 == 2) {
            right = Resolver.start(context, rho, group, opName, args2.getElementAsSEXP(1)).withBaseDefinitionEnvironment().findNext();
        }
        if (left == null && right == null) {
            return null;
        }
        if (left == null) {
            left = right;
        }
        String[] m = new String[nargs2];
        for (int i = 0; i < nargs2; ++i) {
            StringVector t2 = S3.computeDataClasses(context, args2.getElementAsSEXP(i));
            boolean set2 = false;
            for (int j = 0; j < t2.length(); ++j) {
                if (!t2.getElementAsString(j).equals(left.className)) continue;
                m[i] = left.method.getPrintName();
                set2 = true;
                break;
            }
            if (set2) continue;
            m[i] = "";
        }
        left.withMethodVector(m);
        PairList promisedArgs = Calls.promiseArgs(args2, context, rho);
        if (promisedArgs.length() != args2.length()) {
            throw new EvalException("dispatch error in group dispatch", new Object[0]);
        }
        if (promisedArgs != Null.INSTANCE) {
            PairList.Node promised = (PairList.Node)promisedArgs;
            while (true) {
                if (promised == promisedArgs) {
                    ((Promise)promised.getValue()).setResult(((PairList.Node)args2).getValue());
                }
                if (isOps) {
                    promised.setTag(Null.INSTANCE);
                }
                if (!promised.hasNextNode()) break;
                promised = promised.getNextNode();
            }
        }
        return left.doApply(context, rho, call2, promisedArgs);
    }

    public static SEXP tryDispatchFromPrimitive(Context context, Environment rho, FunctionCall call2, String name, SEXP object2, PairList args2) {
        if (call2.getFunction() instanceof Symbol && ((Symbol)call2.getFunction()).getPrintName().endsWith(".default")) {
            return null;
        }
        SEXP resultS4Dispatch = null;
        if (Types.isS4(object2) && S3.isS4DispatchSupported(name)) {
            resultS4Dispatch = S3.handleS4object(context, object2, args2, rho, null, name);
        }
        if (resultS4Dispatch != null) {
            return resultS4Dispatch;
        }
        GenericMethod method = Resolver.start(context, rho, null, name, object2).withBaseDefinitionEnvironment().withObjectArgument(object2).withGenericArgument(name).findNext();
        if (method == null) {
            return null;
        }
        PairList newArgs = S3.reassembleAndEvaluateArgs(object2, args2, context, rho);
        return method.doApply(context, rho, call2, newArgs);
    }

    private static boolean isS4DispatchSupported(String name) {
        return !"@<-".equals(name);
    }

    private static SEXP handleS4object(@Current Context context, SEXP source, PairList args2, Environment rho, String group, String opName) {
        boolean genericExact;
        Map<String, int[]> signatureLength;
        int maxSignatureLength;
        if ("as.double".equals(opName)) {
            opName = "as.numeric";
        }
        List<Environment> groupMethodTables = null;
        List<Environment> genericMethodTables = null;
        genericMethodTables = S3.findMethodTable(context, opName);
        if ("Ops".equals(group)) {
            groupMethodTables = S3.findOpsMethodTable(context, opName);
        } else if (!"".equals(group) && group != null) {
            groupMethodTables = S3.findMethodTable(context, group);
        }
        if (!(groupMethodTables != null && groupMethodTables.size() != 0 || genericMethodTables != null && genericMethodTables.size() != 0)) {
            return null;
        }
        HashMap<String, List<Environment>> mapMethodTableList = new HashMap<String, List<Environment>>();
        if (genericMethodTables != null && genericMethodTables.size() != 0) {
            mapMethodTableList.put("generic", genericMethodTables);
        }
        if (groupMethodTables != null && groupMethodTables.size() != 0) {
            mapMethodTableList.put("group", groupMethodTables);
        }
        if ((maxSignatureLength = S3.getMaxSignatureLength(signatureLength = S3.computeSignatureLength(genericMethodTables, groupMethodTables))) == 0) {
            return null;
        }
        PairList expandedArgs = Calls.promiseArgs(args2, context, rho);
        PairList.Builder promisedArgs = new PairList.Builder();
        Iterator<PairList.Node> it = expandedArgs.nodes().iterator();
        int argIdx = 0;
        while (it.hasNext()) {
            PairList.Node node = it.next();
            SEXP uneval = node.getValue();
            if (argIdx == 0) {
                promisedArgs.add(node.getRawTag(), (SEXP)new Promise(uneval, source));
            } else if (uneval == Symbol.MISSING_ARG) {
                promisedArgs.add(node.getRawTag(), uneval);
            } else {
                promisedArgs.add(node.getRawTag(), (SEXP)Promise.repromise(rho, uneval));
            }
            ++argIdx;
        }
        Map<String, List<List<MethodRanking>>> possibleSignatures = S3.generateSignatures(context, mapMethodTableList, promisedArgs.build(), signatureLength);
        Map<String, List<SelectedMethod>> validMethods = S3.findMatchingMethods(context, mapMethodTableList, possibleSignatures);
        if (validMethods.keySet().size() == 0) {
            return null;
        }
        int maxNumberOfMethods = 0;
        Iterator<String> typeItr = validMethods.keySet().iterator();
        while (typeItr.hasNext()) {
            List<SelectedMethod> methods = validMethods.get(typeItr.next());
            int nextSize = methods.size();
            if (nextSize <= maxNumberOfMethods) continue;
            maxNumberOfMethods = nextSize;
        }
        if (maxNumberOfMethods == 0) {
            return null;
        }
        SelectedMethod genericMethod = null;
        SelectedMethod groupMethod = null;
        double genericRank = -1.0;
        double groupRank = -1.0;
        if (validMethods.containsKey("generic")) {
            genericRank = validMethods.get("generic").get(0).getRank();
            genericMethod = validMethods.get("generic").get(0);
        }
        if (validMethods.containsKey("group")) {
            groupRank = validMethods.get("group").get(0).getRank();
            groupMethod = validMethods.get("group").get(0);
        }
        SelectedMethod method = genericRank == -1.0 || groupRank != -1.0 && genericRank > groupRank ? groupMethod : genericMethod;
        Closure function2 = method.getFunction();
        boolean hasS3Class = source.getAttribute(Symbol.get(".S3Class")).length() != 0;
        boolean bl = genericExact = "generic".equals(method.getGroup()) && method.getTotalDist() == 0;
        if (!opName.contains("<-") && (genericExact || hasS3Class)) {
            FunctionCall call2 = new FunctionCall(function2, promisedArgs.build());
            return context.evaluate(call2);
        }
        HashMap<Symbol, SEXP> metadata = new HashMap<Symbol, SEXP>();
        metadata.put(Symbol.get(".defined"), S3.buildDotTargetOrDefined(context, method, true));
        metadata.put(Symbol.get(".Generic"), S3.buildDotGeneric(opName));
        metadata.put(Symbol.get(".Method"), function2);
        metadata.put(Symbol.get(".Methods"), Symbol.get(".Primitive(\"" + opName + "\")"));
        metadata.put(Symbol.get(".target"), S3.buildDotTargetOrDefined(context, method, false));
        PairList formals2 = function2.getFormals();
        PairList matchedList = ClosureDispatcher.matchArguments(formals2, promisedArgs.build(), true);
        HashMap<Symbol, SEXP> matchedMap = new HashMap<Symbol, SEXP>();
        for (PairList.Node node : matchedList.nodes()) {
            matchedMap.put(node.getTag(), node.getValue());
        }
        for (Symbol arg : matchedMap.keySet()) {
            SEXP argValue = (SEXP)matchedMap.get(arg);
            if (argValue == Symbol.MISSING_ARG) continue;
            if (argValue instanceof Promise && ((Promise)argValue).getValue() != null) {
                metadata.put(arg, ((Promise)argValue).getValue());
                continue;
            }
            metadata.put(arg, argValue.force(context));
        }
        FunctionCall call3 = new FunctionCall(function2, expandedArgs);
        return ClosureDispatcher.apply(context, rho, call3, function2, promisedArgs.build(), metadata);
    }

    private static int getMaxSignatureLength(Map<String, int[]> signatureLengths) {
        String[] types;
        int max2 = 0;
        for (String type : types = new String[]{"generic", "group"}) {
            if (!signatureLengths.containsKey(type)) continue;
            int currentMax = Ints.max(signatureLengths.get(type));
            max2 = max2 < currentMax ? currentMax : max2;
        }
        return max2;
    }

    private static SEXP buildDotGeneric(String opName) {
        StringVector generic = StringVector.valueOf(opName);
        generic.setAttribute("package", (SEXP)StringVector.valueOf("base"));
        return generic;
    }

    private static SEXP buildDotTargetOrDefined(Context context, SelectedMethod method, boolean defined) {
        List<String> argumentClasses = Arrays.asList(method.getSignature().split("#"));
        ArrayList<String> argumentPackages = new ArrayList<String>();
        if (defined) {
            for (String argumentClass : argumentClasses) {
                argumentPackages.add(S3.findClassOrMethodName(context, argumentClass, ".__C__", "methods", false));
            }
        } else {
            for (String ignored : argumentClasses) {
                argumentPackages.add("methods");
            }
        }
        return new StringVector.Builder().addAll(argumentClasses).setAttribute("names", (SEXP)method.getFunction().getFormals().getNames()).setAttribute("package", (SEXP)new StringArrayVector((Collection<String>)argumentPackages)).setAttribute("class", S3.classWithPackage("signature", "methods")).build();
    }

    private static SEXP classWithPackage(String className, String packageName) {
        return StringVector.valueOf(className).setAttribute("package", (SEXP)StringVector.valueOf(packageName));
    }

    private static List<Environment> findMethodTable(Context context, String opName) {
        String genericName = S3.findClassOrMethodName(context, opName, ".__T__", "base", true);
        CopyOnWriteArrayList<Environment> methodTableList = new CopyOnWriteArrayList<Environment>();
        List<String> pkgNames = S3.getNamesLoadedPackages(context);
        pkgNames.add(0, ".GlobalEnv");
        for (String pkg : pkgNames) {
            SEXP methodTablePackage = S3.getFromPackage(context, pkg, genericName);
            if (!(methodTablePackage instanceof Environment)) continue;
            methodTableList.add((Environment)methodTablePackage);
        }
        return methodTableList.size() == 0 ? null : methodTableList;
    }

    private static String findClassOrMethodName(Context context, String name, String what, String altValue, boolean method) {
        String sourcePackage = null;
        String className = what + name;
        List<String> loadedPackages = S3.getNamesLoadedPackages(context);
        loadedPackages.add(0, ".GlobalEnv");
        for (int i = 0; i < loadedPackages.size() && sourcePackage == null; ++i) {
            String pkgName = loadedPackages.get(i);
            String methodName = what + name + ":" + pkgName;
            String generic = method ? methodName : className;
            SEXP methodTable = S3.getFromPackage(context, pkgName, generic);
            if (!(methodTable instanceof Environment) && !(methodTable instanceof S4Object)) continue;
            sourcePackage = method ? methodName : pkgName;
        }
        if (sourcePackage == null) {
            sourcePackage = method ? what + name + ":" + altValue : altValue;
        }
        return sourcePackage;
    }

    private static List<Environment> findOpsMethodTable(Context context, String opName) {
        ArrayList<Environment> methodTableList = new ArrayList<Environment>();
        Frame globalFrame = context.getGlobalEnvironment().getFrame();
        SEXP methodTableGlobalEnv = S3.getMethodTable(context, opName, globalFrame);
        if (methodTableGlobalEnv instanceof Environment) {
            methodTableList.add((Environment)methodTableGlobalEnv);
        }
        for (String pkg : S3.getNamesLoadedPackages(context)) {
            Frame packageFrame = S3.getPackageFrame(context, pkg);
            SEXP methodTablePackage = S3.getMethodTable(context, opName, packageFrame);
            if (!(methodTablePackage instanceof Environment) || ((Environment)methodTablePackage).getFrame().getSymbols().size() <= 0) continue;
            methodTableList.add((Environment)methodTablePackage);
        }
        if (methodTableList.size() == 0) {
            return null;
        }
        return methodTableList;
    }

    public static Frame getPackageFrame(Context context, String name) {
        if (".GlobalEnv".equals(name)) {
            return context.getGlobalEnvironment().getFrame();
        }
        Namespace pkgNamespace = context.getNamespaceRegistry().getNamespace(context, name);
        return pkgNamespace.getNamespaceEnvironment().getFrame();
    }

    public static SEXP getFromPackage(Context context, String pkg, String what) {
        Frame pkgFrame = S3.getPackageFrame(context, pkg);
        return pkgFrame.getVariable(Symbol.get(what)).force(context);
    }

    public static List<String> getNamesLoadedPackages(Context context) {
        CopyOnWriteArrayList<String> loadedPackages = new CopyOnWriteArrayList<String>();
        for (Symbol symbol2 : context.getNamespaceRegistry().getLoadedNamespaces()) {
            loadedPackages.add(symbol2.getPrintName());
        }
        return loadedPackages;
    }

    private static SEXP getMethodTable(Context context, String opName, Frame packageFrame) {
        SEXP methodTable = null;
        if (ARITH_GROUP.contains(opName)) {
            String[] groups = new String[]{".__T__Arith:base", ".__T__Ops:base"};
            methodTable = S3.getMethod(context, packageFrame, groups);
        } else if (COMPARE_GROUP.contains(opName)) {
            String[] groups = new String[]{".__T__Compare:methods", ".__T__Ops:base"};
            methodTable = S3.getMethod(context, packageFrame, groups);
        } else if (LOGIC_GROUP.contains(opName)) {
            String[] groups = new String[]{".__T__Logic:base", ".__T__Ops:base"};
            methodTable = S3.getMethod(context, packageFrame, groups);
        }
        return methodTable;
    }

    private static SEXP getMethod(Context context, Frame frame2, String[] groups) {
        Environment methodTable = null;
        for (int i = 0; i < groups.length && methodTable == null; ++i) {
            SEXP foundMethodTable = frame2.getVariable(Symbol.get(groups[i])).force(context);
            methodTable = foundMethodTable instanceof Environment ? (Environment)foundMethodTable : null;
        }
        return methodTable;
    }

    private static Map<String, int[]> computeSignatureLength(List<Environment> genericMethodTable, List<Environment> groupMethodTable) {
        int i;
        int[] length2;
        HashMap<String, int[]> signatureLengths = new HashMap<String, int[]>();
        if (genericMethodTable != null) {
            length2 = new int[genericMethodTable.size()];
            for (i = 0; i < genericMethodTable.size(); ++i) {
                length2[i] = genericMethodTable.get(i).getFrame().getSymbols().iterator().hasNext() ? genericMethodTable.get(i).getFrame().getSymbols().iterator().next().getPrintName().split("#").length : 0;
            }
            signatureLengths.put("generic", length2);
        }
        if (groupMethodTable != null) {
            length2 = new int[groupMethodTable.size()];
            for (i = 0; i < groupMethodTable.size(); ++i) {
                length2[i] = groupMethodTable.get(i).getFrame().getSymbols().iterator().hasNext() ? groupMethodTable.get(i).getFrame().getSymbols().iterator().next().getPrintName().split("#").length : 0;
            }
            signatureLengths.put("group", length2);
        }
        return signatureLengths;
    }

    private static Map<String, List<SelectedMethod>> findMatchingMethods(Context context, Map<String, List<Environment>> mapMethodTableLists, Map<String, List<List<MethodRanking>>> mapSignatureList) {
        HashMap<String, List<SelectedMethod>> mapListMethods = new HashMap<String, List<SelectedMethod>>();
        for (int e = 0; e < mapSignatureList.size(); ++e) {
            ArrayList<SelectedMethod> selectedMethods = new ArrayList<SelectedMethod>();
            String type = mapSignatureList.keySet().toArray(new String[0])[e];
            List<List<MethodRanking>> rankings = mapSignatureList.get(type);
            List<Environment> methodTableList = mapMethodTableLists.get(type);
            for (int i = 0; i < rankings.size(); ++i) {
                List<MethodRanking> rankedMethodsList = rankings.get(i);
                String inputSignature = rankedMethodsList.get(0).getSignature();
                for (MethodRanking rankedMethod : rankedMethodsList) {
                    String signature = rankedMethod.getSignature();
                    double rank2 = rankedMethod.getRank();
                    int[] dist = rankedMethod.getDistances();
                    boolean has0 = rankedMethod.hasZeroDistanceArgument();
                    Symbol signatureSymbol = Symbol.get(signature);
                    SEXP function2 = methodTableList.get(i).getFrame().getVariable(signatureSymbol).force(context);
                    if (!(function2 instanceof Closure)) continue;
                    selectedMethods.add(new SelectedMethod((Closure)function2, type, rank2, dist, signature, signatureSymbol, inputSignature, has0));
                }
            }
            if (selectedMethods.size() <= 0) continue;
            Collections.sort(selectedMethods);
            mapListMethods.put(type, selectedMethods);
        }
        return mapListMethods;
    }

    private static Map<String, List<List<MethodRanking>>> generateSignatures(Context context, Map<String, List<Environment>> mapMethodTableLists, PairList inputArgs, Map<String, int[]> depths) {
        HashMap<String, List<List<MethodRanking>>> mapListMethods = new HashMap<String, List<List<MethodRanking>>>();
        for (int e = 0; e < mapMethodTableLists.size(); ++e) {
            String type = mapMethodTableLists.keySet().toArray(new String[0])[e];
            List<Environment> methodTableList = mapMethodTableLists.get(type);
            ArrayList listSignatures = new ArrayList();
            int[] depth = depths.get(type);
            for (int listIdx = 0; listIdx < methodTableList.size(); ++listIdx) {
                Environment methodTable = methodTableList.get(listIdx);
                int currentDepth = depth[listIdx];
                Symbol methodSymbol = methodTable.getFrame().getSymbols().iterator().next();
                Closure genericClosure = (Closure)methodTable.getFrame().getVariable(methodSymbol);
                PairList formals2 = genericClosure.getFormals();
                PairList matchedList = ClosureDispatcher.matchArguments(formals2, inputArgs, true);
                HashMap<Symbol, SEXP> matchedMap = new HashMap<Symbol, SEXP>();
                for (PairList.Node node : matchedList.nodes()) {
                    matchedMap.put(node.getTag(), node.getValue());
                }
                ArrayList<SEXP> inputMap = new ArrayList<SEXP>();
                for (PairList.Node node : inputArgs.nodes()) {
                    inputMap.add(node.getValue());
                }
                int matchLength = matchedMap.containsKey(Symbols.ELLIPSES) ? matchedMap.size() - 1 : matchedMap.size();
                boolean lengthMatchEqualsInput = matchLength - inputMap.size() == 0;
                ArgumentSignature[] argSignatures = lengthMatchEqualsInput ? S3.computeArgumentSignatures(context, inputArgs.nodes(), null, currentDepth) : S3.computeArgumentSignatures(context, formals2.nodes(), matchedMap, currentDepth);
                int numberOfPossibleSignatures = 1;
                for (int i = 0; i < argSignatures.length; ++i) {
                    numberOfPossibleSignatures *= argSignatures[i].getArgument().length;
                }
                ArrayList<MethodRanking> possibleSignatures = new ArrayList<MethodRanking>(numberOfPossibleSignatures);
                int argumentClassIdx = 0;
                int repeat = 1;
                int repeatIdx = 1;
                for (int col2 = 0; col2 < depth[listIdx]; ++col2) {
                    int numberOfClassesCurrentArgument = argSignatures[col2].getArgument().length;
                    int row2 = 0;
                    while (row2 < numberOfPossibleSignatures) {
                        if (argumentClassIdx == numberOfClassesCurrentArgument) {
                            argumentClassIdx = 0;
                        }
                        ArgumentSignature argSignature = argSignatures[col2];
                        String signature = argSignature.getArgument(argumentClassIdx);
                        if (possibleSignatures.isEmpty() || possibleSignatures.size() < row2 + 1 || possibleSignatures.get(row2) == null) {
                            int[] distance = argSignature.getDistanceAsArray(argumentClassIdx);
                            possibleSignatures.add(row2, new MethodRanking(signature, distance));
                        } else {
                            int distance = argSignature.getDistance(argumentClassIdx);
                            possibleSignatures.set(row2, ((MethodRanking)possibleSignatures.get(row2)).append(signature, distance));
                        }
                        if (repeat == 1) {
                            ++argumentClassIdx;
                        }
                        if (repeat != 1 && repeatIdx == repeat) {
                            repeatIdx = 0;
                            ++argumentClassIdx;
                        }
                        ++row2;
                        ++repeatIdx;
                    }
                    repeatIdx = 1;
                    argumentClassIdx = 0;
                    repeat *= numberOfClassesCurrentArgument;
                }
                listSignatures.add(possibleSignatures);
            }
            mapListMethods.put(type, listSignatures);
        }
        return mapListMethods;
    }

    private static ArgumentSignature[] computeArgumentSignatures(Context context, Iterable<PairList.Node> nodes, Map<Symbol, SEXP> matchedMap, int currentDepth) {
        ArgumentSignature[] argSignatures = new ArgumentSignature[currentDepth];
        int idx = 0;
        for (PairList.Node node : nodes) {
            SEXP value;
            if (matchedMap == null) {
                value = node.getValue().force(context);
            } else {
                Symbol formalName = node.getTag();
                if (formalName == Symbols.ELLIPSES) continue;
                value = matchedMap.get(formalName).force(context);
            }
            argSignatures[idx] = S3.getArgumentSignature(context, value);
            if (++idx < argSignatures.length) continue;
            break;
        }
        return argSignatures;
    }

    private static ArgumentSignature getArgumentSignature(Context context, SEXP argValue) {
        if (argValue == Symbol.MISSING_ARG) {
            return new ArgumentSignature();
        }
        String[] nodeClass = S3.computeDataClasses(context, argValue).toArray();
        ArrayList<String> listClasses = new ArrayList<String>(Arrays.asList(nodeClass));
        if (listClasses.contains("double")) {
            listClasses.remove("double");
        }
        return S3.getClassAndDistance(context, listClasses);
    }

    private static ArgumentSignature getClassAndDistance(Context context, List<String> argClass) {
        ArrayList<Integer> distances = new ArrayList<Integer>();
        ArrayList<String> classes = new ArrayList<String>();
        for (int i = 0; i < argClass.size(); ++i) {
            classes.add(argClass.get(i));
            distances.add(0);
        }
        SEXP containsSlot = S3.getContainsSlot(context, argClass.get(0));
        SEXP argSuperClasses = S3.getSuperClassesS4(containsSlot);
        for (int i = 0; i < argSuperClasses.length(); ++i) {
            SEXP distanceSlot = ((ListVector)containsSlot).get(i).getAttributes().get("distance");
            distances.add(((Vector)distanceSlot).getElementAsInt(0));
            classes.add(((Vector)argSuperClasses).getElementAsString(i));
        }
        int max2 = (Integer)Collections.max(distances);
        if (!classes.contains("ANY") && !classes.contains("NULL")) {
            distances.add(max2 + 1);
            classes.add("ANY");
        }
        return new ArgumentSignature(classes.toArray(new String[0]), Ints.toArray(distances));
    }

    public static SEXP getContainsSlot(Context context, String objClass) {
        Symbol argClassObjectName = Symbol.get(".__C__" + objClass);
        Environment environment2 = context.getEnvironment();
        AttributeMap map = environment2.findVariable(context, argClassObjectName).force(context).getAttributes();
        return map.get("contains");
    }

    public static AtomicVector getSuperClassesS4(Context context, String objClass) {
        SEXP containsSlot = S3.getContainsSlot(context, objClass);
        return containsSlot.getNames();
    }

    public static SEXP getSuperClassesS4(SEXP containsSlot) {
        return containsSlot.getNames();
    }

    public static SEXP computeDataClassesS4(Context context, String className) {
        Symbol argClassObjectName = Symbol.get(".__C__" + className);
        Environment environment2 = context.getEnvironment();
        AttributeMap map = environment2.findVariable(context, argClassObjectName).force(context).getAttributes();
        return map.get("contains").getNames();
    }

    public static SEXP tryDispatchFromPrimitive(Context context, Environment rho, FunctionCall call2, String name, String[] argumentNames, SEXP[] arguments) {
        if (call2.getFunction() instanceof Symbol && ((Symbol)call2.getFunction()).getPrintName().endsWith(".default")) {
            return null;
        }
        Vector classVector = (Vector)arguments[0].getAttribute(Symbols.CLASS);
        if (classVector.length() == 0) {
            return null;
        }
        DispatchChain chain = DispatchChain.newChain(context, rho, name, classVector);
        if (chain == null) {
            return null;
        }
        PairList.Builder newArgsBuilder = new PairList.Builder();
        for (int i = 0; i != arguments.length; ++i) {
            newArgsBuilder.add(argumentNames[i], arguments[i]);
        }
        PairList newArgs = newArgsBuilder.build();
        FunctionCall newCall = new FunctionCall(chain.getMethodSymbol(), newArgs);
        ClosureDispatcher dispatcher = new ClosureDispatcher(context, rho, newCall);
        return dispatcher.apply(chain, newArgs);
    }

    static PairList reassembleAndEvaluateArgs(SEXP object2, PairList args2, Context context, Environment rho) {
        PairList.Builder newArgs = new PairList.Builder();
        PairList.Node firstArg = (PairList.Node)args2;
        newArgs.add(firstArg.getRawTag(), (SEXP)new Promise(firstArg.getValue(), object2));
        ArgumentIterator argIt = new ArgumentIterator(context, rho, firstArg.getNext());
        while (argIt.hasNext()) {
            PairList.Node node = argIt.nextNode();
            if (node.getValue() == Symbol.MISSING_ARG) {
                newArgs.add(node.getRawTag(), (SEXP)Symbol.MISSING_ARG);
                continue;
            }
            newArgs.add(node.getRawTag(), (SEXP)Promise.repromise(rho, node.getValue()));
        }
        return newArgs.build();
    }

    public static SEXP tryDispatchOpsFromPrimitive(Context context, Environment rho, FunctionCall call2, String name, SEXP s0) {
        PairList.Node newArgs = new PairList.Node(s0, Null.INSTANCE);
        return S3.dispatchGroup("Ops", call2, name, newArgs, context, rho);
    }

    public static SEXP tryDispatchOpsFromPrimitive(Context context, Environment rho, FunctionCall call2, String name, SEXP s0, SEXP s1) {
        PairList.Node newArgs = new PairList.Node(s0, new PairList.Node(s1, Null.INSTANCE));
        return S3.dispatchGroup("Ops", call2, name, newArgs, context, rho);
    }

    public static SEXP tryDispatchGroupFromPrimitive(Context context, Environment rho, FunctionCall call2, String group, String name, SEXP s0, PairList args2) {
        PairList.Node firstNode = (PairList.Node)args2;
        PairList.Node newArgs = new PairList.Node(s0, firstNode.getNext());
        return S3.dispatchGroup(group, call2, name, newArgs, context, rho);
    }

    private static <X> X first(Iterable<X> values) {
        return values.iterator().next();
    }

    private static boolean hasNextUnTagged(PeekingIterator<PairList.Node> it) {
        return it.hasNext() && !it.peek().hasTag();
    }

    private static PairList.Node nextUnTagged(Iterator<PairList.Node> it) {
        PairList.Node arg = it.next();
        while (arg.hasTag()) {
            arg = it.next();
        }
        return arg;
    }

    public static SEXP tryDispatchSummaryFromPrimitive(Context context, Environment rho, FunctionCall call2, String name, ListVector evaluatedArguments, boolean naRm) {
        PairList.Builder newArgs = new PairList.Builder();
        int varArgIndex = 0;
        boolean naRmArgumentSupplied = false;
        for (PairList.Node node : call2.getArguments().nodes()) {
            if (node.getRawTag() == NA_RM) {
                newArgs.add(node.getTag(), (SEXP)new LogicalArrayVector(naRm));
                naRmArgumentSupplied = true;
                continue;
            }
            if (node.getValue() == Symbols.ELLIPSES) {
                while (varArgIndex < evaluatedArguments.length()) {
                    newArgs.add(evaluatedArguments.getName(varArgIndex), evaluatedArguments.get(varArgIndex));
                    ++varArgIndex;
                }
                continue;
            }
            newArgs.add(node.getRawTag(), evaluatedArguments.get(varArgIndex++));
        }
        if (!naRmArgumentSupplied) {
            newArgs.add(NA_RM, LogicalVector.valueOf(naRm));
        }
        return S3.dispatchGroup("Summary", call2, name, newArgs.build(), context, rho);
    }

    public static PairList updateArguments(Context context, PairList actuals, PairList formals2, Environment previousEnv, ListVector extraArgs) {
        ArrayList<SEXP> actualNames = Lists.newArrayList();
        ArrayList<SEXP> actualValues = Lists.newArrayList();
        ArrayList<Symbol> matchedNames = Lists.newArrayList();
        LinkedList<PairList.Node> unmatchedFormals = Lists.newLinkedList(formals2.nodes());
        for (PairList.Node node : actuals.nodes()) {
            if (node.getValue() instanceof PromisePairList) {
                PromisePairList ellipses = (PromisePairList)node.getValue();
                for (PairList.Node nestedNode : ellipses.nodes()) {
                    actualNames.add(nestedNode.getRawTag());
                    actualValues.add(nestedNode.getValue());
                    matchedNames.add(S3.matchArgumentExactlyByName(nestedNode.getRawTag(), unmatchedFormals));
                }
                continue;
            }
            actualNames.add(node.getRawTag());
            actualValues.add(node.getValue());
            matchedNames.add(S3.matchArgumentExactlyByName(node.getRawTag(), unmatchedFormals));
        }
        for (int i = 0; i != matchedNames.size(); ++i) {
            if (matchedNames.get(i) != null) continue;
            matchedNames.set(i, S3.matchPartiallyByName((SEXP)actualNames.get(i), unmatchedFormals));
        }
        Iterator formalIt = unmatchedFormals.iterator();
        for (int i = 0; i != matchedNames.size(); ++i) {
            if (matchedNames.get(i) != null) continue;
            if (!formalIt.hasNext()) {
                throw new EvalException("Unmatched argument", new Object[0]);
            }
            Symbol nextFormalName = ((PairList.Node)formalIt.next()).getTag();
            if (nextFormalName == Symbols.ELLIPSES) break;
            matchedNames.set(i, nextFormalName);
        }
        PairList.Builder updated = PairList.Node.newBuilder();
        for (int i = 0; i != matchedNames.size(); ++i) {
            SEXP updatedValue;
            if (matchedNames.get(i) != null) {
                updatedValue = previousEnv.getVariableUnsafe((Symbol)matchedNames.get(i));
                assert (updatedValue != Symbol.UNBOUND_VALUE);
            } else {
                updatedValue = (SEXP)actualValues.get(i);
            }
            updated.add((SEXP)actualNames.get(i), updatedValue);
        }
        for (NamedValue extraArg : extraArgs.namedValues()) {
            if (!extraArg.hasName()) {
                updated.add(extraArg.getValue());
                continue;
            }
            updated.set(extraArg.getName(), extraArg.getValue());
        }
        return updated.build();
    }

    private static Symbol matchArgumentExactlyByName(SEXP tag, List<PairList.Node> unmatchedFormals) {
        if (tag == Null.INSTANCE) {
            return null;
        }
        for (PairList.Node formal : unmatchedFormals) {
            if (formal.getTag() != tag) continue;
            unmatchedFormals.remove(formal);
            return formal.getTag();
        }
        return null;
    }

    private static Symbol matchPartiallyByName(SEXP tag, List<PairList.Node> unmatchedFormals) {
        if (tag == Null.INSTANCE) {
            return null;
        }
        String name = ((Symbol)tag).getPrintName();
        PairList.Node partialMatch = null;
        for (PairList.Node formal : unmatchedFormals) {
            if (!formal.getTag().getPrintName().startsWith(name)) continue;
            if (partialMatch != null) {
                throw new EvalException("multiple partial matches", new Object[0]);
            }
            partialMatch = formal;
        }
        if (partialMatch == null) {
            return null;
        }
        return partialMatch.getTag();
    }

    public static class SelectedMethod
    implements Comparable<SelectedMethod> {
        private Closure function;
        private String group;
        private double currentRank;
        private boolean has0;
        private int[] distances;
        private int currentDist;
        private String currentSig;
        private Symbol methodName;
        private String methodInputSignature;

        public SelectedMethod(Closure fun, String grp, double rank2, int[] dist, String sig, Symbol method, String methSig, boolean has0) {
            this.function = fun;
            this.group = grp;
            this.currentRank = rank2;
            this.distances = dist;
            int sum2 = 0;
            for (int i = 0; i < dist.length; ++i) {
                sum2 += dist[i];
            }
            this.currentDist = sum2;
            this.currentSig = sig;
            this.methodName = method;
            this.methodInputSignature = methSig;
            this.has0 = has0;
        }

        public Closure getFunction() {
            return this.function;
        }

        public String getGroup() {
            return this.group;
        }

        public double getRank() {
            return this.currentRank;
        }

        public int[] getDistances() {
            return this.distances;
        }

        public int getDistance(int i) {
            int sum2 = 0;
            for (int j = 0; j < i; ++j) {
                sum2 += this.distances[j];
            }
            return sum2;
        }

        public String getSignature() {
            return this.currentSig;
        }

        public Symbol getMethod() {
            return this.methodName;
        }

        public int getTotalDist() {
            return this.currentDist;
        }

        public int isHas0() {
            if (this.has0) {
                return 0;
            }
            return 1;
        }

        @Override
        public int compareTo(SelectedMethod o) {
            int minArgs;
            int i = Integer.compare(this.isHas0(), o.isHas0());
            if (i != 0) {
                return i;
            }
            if (this.getDistances().length == o.getDistances().length ? (i = Integer.compare(this.getTotalDist(), o.getTotalDist())) != 0 : (i = Integer.compare(this.getDistance(minArgs = Math.min(this.getDistances().length, o.getDistances().length)), o.getDistance(minArgs))) != 0) {
                return i;
            }
            return Double.compare(this.currentRank, o.getRank());
        }
    }

    public static class MethodRanking {
        private String signature;
        private int[] distances;
        private boolean has0 = false;
        private int totalDist = 0;
        private double rank = 0.0;

        public MethodRanking(String signature, int[] distance) {
            this.signature = signature;
            this.distances = distance;
            int totalDistance = 0;
            for (int i = 0; i < distance.length; ++i) {
                this.rank += 10007.0 * Math.pow(0.5, i) * (double)distance[i];
                if (distance[i] == 0) {
                    this.has0 = true;
                    continue;
                }
                totalDistance += distance[i];
            }
            this.totalDist = totalDistance;
        }

        public String toString() {
            return "MethodRanking{signature='" + this.signature + '\'' + '}';
        }

        public MethodRanking append(String argument, int distance) {
            String newSig = this.signature + "#" + argument;
            int[] newDist = new int[this.distances.length + 1];
            for (int i = 0; i < this.distances.length; ++i) {
                newDist[i] = this.distances[i];
            }
            newDist[this.distances.length] = distance;
            this.signature = newSig;
            this.distances = newDist;
            this.has0 = this.has0 || distance == 0;
            this.totalDist += distance;
            this.rank += 10007.0 * Math.pow(0.5, newDist.length) * (double)distance;
            return this;
        }

        public String getSignature() {
            return this.signature;
        }

        public int[] getDistances() {
            return this.distances;
        }

        public int getTotalDist() {
            return this.totalDist;
        }

        public double getRank() {
            return this.rank;
        }

        public boolean hasZeroDistanceArgument() {
            return this.has0;
        }
    }

    public static class ArgumentSignature {
        private String[] argumentClasses;
        private int[] distances;

        public ArgumentSignature(String[] classes, int[] distances) {
            this.argumentClasses = classes;
            this.distances = distances;
        }

        public ArgumentSignature() {
            this.argumentClasses = new String[]{"missing", "ANY"};
            this.distances = new int[]{0, 1};
        }

        public String[] getArgument() {
            return this.argumentClasses;
        }

        public String getArgument(int position) {
            return this.argumentClasses[position];
        }

        public int getDistance(int position) {
            return this.distances[position];
        }

        public int[] getDistanceAsArray(int position) {
            int[] array2 = new int[]{this.distances[position]};
            return array2;
        }
    }

    public static class GenericMethod {
        private Resolver resolver;
        private Symbol method;
        private Function function;
        private String className;
        private StringVector methodVector;

        public GenericMethod(Resolver resolver, Symbol method, String className, Function function2) {
            assert (function2 != null);
            this.resolver = resolver;
            this.method = method;
            this.methodVector = new StringArrayVector(method.getPrintName());
            this.className = className;
            this.function = function2;
        }

        public SEXP apply(Context callContext, Environment callEnvironment) {
            PairList rePromisedArgs = Calls.promiseArgs(callContext.getArguments(), callContext, callEnvironment);
            return this.doApply(callContext, callEnvironment, callContext.getCall(), rePromisedArgs);
        }

        public SEXP applyNext(Context context, Environment environment2, ListVector extraArgs) {
            PairList arguments = this.nextArguments(context, extraArgs);
            if ("Ops".equals(this.resolver.group) && arguments.length() == 2) {
                this.withMethodVector(this.groupsMethodVector());
            }
            return this.doApply(context, environment2, context.getCall(), arguments);
        }

        private String[] groupsMethodVector() {
            GenericMethod previousMethod = this.resolver.previousContext.getState(GenericMethod.class);
            String[] methodVector = previousMethod.methodVector.toArray();
            String methodName = this.methodVector.getElementAsString(0);
            for (int i = 0; i < methodVector.length; ++i) {
                if (methodVector[i].equals("")) continue;
                methodVector[i] = methodName;
            }
            return methodVector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SEXP doApply(Context callContext, Environment callEnvironment, FunctionCall call2, PairList promisedArgs) {
            FunctionCall newCall = new FunctionCall(this.method, call2.getArguments());
            callContext.setState(GenericMethod.class, this);
            if (Profiler.ENABLED) {
                Profiler.functionStart(this.method, this.function);
            }
            try {
                if (this.function instanceof Closure) {
                    Environment callingEnvironment = callContext.getCallingEnvironment();
                    if (callingEnvironment == null) {
                        callingEnvironment = callContext.getGlobalEnvironment();
                    }
                    SEXP sEXP = Calls.applyClosure((Closure)this.function, callContext, callingEnvironment, newCall, promisedArgs, this.persistChain());
                    return sEXP;
                }
                SEXP sEXP = this.function.apply(callContext, callEnvironment, newCall, promisedArgs);
                return sEXP;
            }
            finally {
                callContext.clearState(GenericMethod.class);
                if (Profiler.ENABLED) {
                    Profiler.functionEnd();
                }
            }
        }

        public GenericMethod withMethodVector(String[] methodNames) {
            this.methodVector = new StringArrayVector(methodNames);
            return this;
        }

        public PairList nextArguments(Context callContext, ListVector extraArgs) {
            Context parentContext = callContext.getParent();
            while (parentContext.getParent() != this.resolver.previousContext) {
                parentContext = parentContext.getParent();
            }
            PairList actuals = parentContext.getArguments();
            Closure closure = (Closure)parentContext.getFunction();
            PairList formals2 = closure.getFormals();
            Environment previousEnv = parentContext.getEnvironment();
            return S3.updateArguments(parentContext, actuals, formals2, previousEnv, extraArgs);
        }

        private Frame persistChain() {
            HashFrame frame2 = new HashFrame();
            frame2.setVariable(Symbol.get(".Class"), new StringArrayVector(this.resolver.classes));
            frame2.setVariable(Symbol.get(".Method"), this.methodVector);
            frame2.setVariable(Symbol.get(".Generic"), StringVector.valueOf(this.resolver.genericMethodName));
            frame2.setVariable(Symbol.get(".GenericCallEnv"), this.resolver.callingEnvironment);
            frame2.setVariable(Symbol.get(".GenericDefEnv"), this.resolver.definitionEnvironment);
            return frame2;
        }

        public String toString() {
            return this.method + "." + this.className;
        }

        public List<String> nextClasses() {
            if (this.className == null) {
                return Collections.emptyList();
            }
            int myIndex = this.resolver.classes.indexOf(this.className);
            return this.resolver.classes.subList(myIndex + 1, this.resolver.classes.size());
        }
    }

    private static class Resolver {
        private Environment callingEnvironment;
        private Environment definitionEnvironment = Environment.EMPTY;
        private String group;
        private String genericMethodName;
        private List<String> classes;
        private Context context;
        private SEXP object;
        private Context previousContext;

        private Resolver() {
        }

        private static Resolver start(Context context, String genericMethodName, SEXP object2) {
            return Resolver.start(context, context.getEnvironment(), null, genericMethodName, object2);
        }

        private static Resolver start(Context context, Environment rho, String group, String genericMethodName, SEXP object2) {
            Resolver resolver = new Resolver();
            resolver.callingEnvironment = rho;
            resolver.genericMethodName = genericMethodName;
            resolver.context = context;
            resolver.object = object2;
            resolver.group = group;
            StringVector objectClasses = S3.computeDataClasses(context, object2);
            if (Types.isS4(object2)) {
                SEXP objectClassesS4 = S3.computeDataClassesS4(context, objectClasses.getElementAsString(0));
                if (objectClassesS4 != Null.INSTANCE) {
                    ArrayList<String> classes = Lists.newArrayList(objectClasses);
                    classes.addAll(Lists.newArrayList((StringVector)objectClassesS4));
                    resolver.classes = classes;
                } else {
                    resolver.classes = Lists.newArrayList(objectClasses);
                }
            } else {
                resolver.classes = Lists.newArrayList(objectClasses);
            }
            return resolver;
        }

        public static Resolver resume(Context context) {
            Context parentContext = Resolver.findParentContext(context);
            GenericMethod method = parentContext.getState(GenericMethod.class);
            Resolver resolver = new Resolver();
            resolver.context = context;
            resolver.previousContext = parentContext;
            resolver.callingEnvironment = context.getEnvironment();
            resolver.definitionEnvironment = ((GenericMethod)method).resolver.definitionEnvironment;
            resolver.genericMethodName = ((GenericMethod)method).resolver.genericMethodName;
            resolver.classes = method.nextClasses();
            resolver.group = ((GenericMethod)method).resolver.group;
            resolver.object = ((GenericMethod)method).resolver.object;
            return resolver;
        }

        public Resolver withObjectArgument(SEXP object2) {
            if (object2 != Null.INSTANCE) {
                this.object = object2;
            }
            return this;
        }

        public Resolver withGenericArgument(SEXP generic) {
            if (generic != Null.INSTANCE) {
                this.genericMethodName = generic.asString();
            }
            return this;
        }

        public Resolver withGenericArgument(String genericName) {
            this.genericMethodName = genericName;
            return this;
        }

        public Resolver withDefinitionEnvironment(Environment rho) {
            this.definitionEnvironment = rho;
            return this;
        }

        public Resolver withBaseDefinitionEnvironment() {
            this.definitionEnvironment = this.context.getBaseEnvironment();
            return this;
        }

        private static Context findParentContext(Context context) {
            while (context != null) {
                if (context.getState(GenericMethod.class) != null) {
                    return context;
                }
                context = context.getParent();
            }
            throw new EvalException("NextMethod called out of context", new Object[0]);
        }

        public GenericMethod next() {
            GenericMethod next = this.findNextOrDefault();
            if (next == null) {
                throw new EvalException("no applicable method for '%s' applied to an object of class \"%s\"", this.genericMethodName, this.classes.toString());
            }
            return next;
        }

        private GenericMethod findNextOrDefault() {
            GenericMethod next = this.findNext();
            if (next != null) {
                return next;
            }
            Environment methodTable = this.getMethodTable();
            GenericMethod function2 = this.findNext(methodTable, this.genericMethodName, "default");
            if (function2 != null) {
                return function2;
            }
            PrimitiveFunction primitive2 = Primitives.getBuiltin(this.genericMethodName);
            if (primitive2 != null) {
                return new GenericMethod(this, Symbol.get(this.genericMethodName + ".default"), null, primitive2);
            }
            return null;
        }

        public GenericMethod findNext() {
            Environment methodTable = this.getMethodTable();
            for (String className : this.classes) {
                List methodTables;
                GenericMethod method = this.findNext(methodTable, this.genericMethodName, className);
                if (method != null) {
                    return method;
                }
                if (Types.isS4(this.object) && S3.isS4DispatchSupported(this.genericMethodName) && (methodTables = S3.findMethodTable(this.context, this.genericMethodName)) != null) {
                    Iterator methodTableItr = methodTables.iterator();
                    while (method == null && methodTableItr.hasNext()) {
                        Environment env2 = (Environment)methodTableItr.next();
                        SEXP methodName = env2.getFrame().getVariable(Symbol.get(className));
                        if (!(methodName instanceof GenericMethod)) continue;
                        method = (GenericMethod)((Object)methodName);
                    }
                    if (method != null) {
                        return method;
                    }
                }
                if (this.group == null || (method = this.findNext(methodTable, this.group, className)) == null) continue;
                return method;
            }
            return null;
        }

        private GenericMethod findNext(Environment methodTable, String name, String className) {
            Symbol method = Symbol.get(name + "." + className);
            Function function2 = this.callingEnvironment.findFunction(this.context, method);
            if (function2 != null) {
                return new GenericMethod(this, method, className, function2);
            }
            if (methodTable != null && methodTable.hasVariable(method)) {
                return new GenericMethod(this, method, className, (Function)methodTable.getVariableUnsafe(method).force(this.context));
            }
            return null;
        }

        private Environment getMethodTable() {
            SEXP table = this.definitionEnvironment.getVariableUnsafe(METHODS_TABLE).force(this.context);
            if (table instanceof Environment) {
                return (Environment)table;
            }
            if (table == Symbol.UNBOUND_VALUE) {
                return null;
            }
            throw new EvalException("Unexpected value for .__S3MethodsTable__. in " + this.definitionEnvironment.getName(), new Object[0]);
        }
    }
}

