/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.matrix;

import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.Builtin;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Generic;
import org.renjin.invoke.annotations.GroupGeneric;
import org.renjin.invoke.annotations.Internal;
import org.renjin.primitives.Indexes;
import org.renjin.primitives.Warning;
import org.renjin.primitives.matrix.DeferredColSums;
import org.renjin.primitives.matrix.DeferredRowMeans;
import org.renjin.primitives.matrix.MatrixProduct;
import org.renjin.primitives.matrix.TransposingMatrix;
import org.renjin.primitives.sequence.RepDoubleVector;
import org.renjin.primitives.sequence.RepLogicalVector;
import org.renjin.primitives.vector.ComputingIntVector;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class Matrices {
    private Matrices() {
    }

    @Internal(value="t.default")
    public static Vector transpose(Vector x) {
        Vector dimensions = x.getAttributes().getDim();
        if (dimensions.length() == 0) {
            return Matrices.transposeVector(x);
        }
        if (dimensions.length() == 1) {
            return Matrices.transposeArray(x);
        }
        if (dimensions.length() == 2) {
            int nrows = dimensions.getElementAsInt(0);
            int ncols = dimensions.getElementAsInt(1);
            AttributeMap.Builder attributes2 = new AttributeMap.Builder();
            attributes2.setDim(ncols, nrows);
            attributes2.set(Symbols.DIMNAMES, Matrices.transposeDimNames(x));
            if (x instanceof DoubleVector && x.length() > 0) {
                return new TransposingMatrix(x, attributes2.build());
            }
            Vector.Builder builder = x.newBuilderWithInitialSize(x.length());
            for (int i = 0; i < nrows; ++i) {
                for (int j = 0; j < ncols; ++j) {
                    builder.setFrom(Indexes.matrixIndexToVectorIndex(j, i, ncols, nrows), x, Indexes.matrixIndexToVectorIndex(i, j, nrows, ncols));
                }
            }
            return (Vector)builder.build().setAttributes(attributes2.build());
        }
        throw new EvalException("argument is not a matrix", new Object[0]);
    }

    private static Vector transposeVector(Vector x) {
        AttributeMap.Builder matrixDims = AttributeMap.builder();
        matrixDims.setDim(1, x.length());
        if (x.getNames() != Null.INSTANCE) {
            matrixDims.setDimNames(new ListVector(Null.INSTANCE, x.getNames()));
        }
        for (Symbol attribute : x.getAttributes().names()) {
            if (attribute == Symbols.NAMES || attribute == Symbols.DIM || attribute == Symbols.DIMNAMES) continue;
            matrixDims.set(attribute, x.getAttribute(attribute));
        }
        return (Vector)x.setAttributes(matrixDims);
    }

    private static Vector transposeArray(Vector x) {
        AttributeMap.Builder matrixDims = AttributeMap.builder();
        matrixDims.setDim(1, x.length());
        Vector dimNameList = x.getAttributes().getDimNames();
        if (dimNameList != Null.INSTANCE) {
            AttributeMap.Builder dimNameAttributes = AttributeMap.builder();
            Null rowNames = Null.INSTANCE;
            Vector colNames = (Vector)dimNameList.getElementAsSEXP(0);
            if (dimNameList.getNames() != Null.INSTANCE) {
                String name = dimNameList.getNames().getElementAsString(0);
                dimNameAttributes.setNames(new StringArrayVector("", name));
            }
            matrixDims.setDimNames(new ListVector(new SEXP[]{rowNames, colNames}, dimNameAttributes.build()));
        }
        for (Symbol attribute : x.getAttributes().names()) {
            if (attribute == Symbols.NAMES || attribute == Symbols.DIM || attribute == Symbols.DIMNAMES) continue;
            matrixDims.set(attribute, x.getAttribute(attribute));
        }
        return (Vector)x.setAttributes(matrixDims);
    }

    private static SEXP transposeDimNames(Vector x) {
        Vector dimNames = x.getAttributes().getDimNames();
        if (dimNames == Null.INSTANCE) {
            return Null.INSTANCE;
        }
        ListVector dimNameList = (ListVector)dimNames;
        SEXP rowNames = dimNameList.getElementAsSEXP(0);
        SEXP colNames = dimNameList.getElementAsSEXP(1);
        AttributeMap.Builder transposedAttributes = AttributeMap.builder();
        if (dimNameList.getNames() != Null.INSTANCE) {
            transposedAttributes.setNames(new StringArrayVector(dimNameList.getName(1), dimNameList.getName(0)));
        }
        return new ListVector(new SEXP[]{colNames, rowNames}, transposedAttributes.build());
    }

    @Builtin(value="%*%")
    @GroupGeneric(value="Ops")
    @Generic(S3=false, S4=true)
    public static SEXP matrixproduct(AtomicVector x, AtomicVector y) {
        return new MatrixProduct(0, x, y).compute();
    }

    @Internal(value="crossprod")
    public static SEXP crossprod(AtomicVector x, AtomicVector y) {
        return new MatrixProduct(1, x, y).compute();
    }

    @Internal(value="tcrossprod")
    public static SEXP tcrossprod(AtomicVector x, AtomicVector y) {
        return new MatrixProduct(2, x, y).compute();
    }

    @Internal
    public static DoubleVector rowSums(AtomicVector x, int numRows, int rowLength, boolean naRm) {
        double[] sums = new double[numRows];
        int sourceIndex = 0;
        for (int col2 = 0; col2 < rowLength; ++col2) {
            for (int row2 = 0; row2 < numRows; ++row2) {
                double value = x.getElementAsDouble(sourceIndex++);
                if (!naRm) {
                    int n = row2;
                    sums[n] = sums[n] + value;
                    continue;
                }
                if (Double.isNaN(value)) continue;
                int n = row2;
                sums[n] = sums[n] + value;
            }
        }
        return DoubleArrayVector.unsafe(sums);
    }

    @Internal
    public static DoubleVector rowMeans(AtomicVector x, int numRows, int rowLength, boolean naRm) {
        if (!naRm && x.isDeferred()) {
            return new DeferredRowMeans(x, numRows, AttributeMap.EMPTY);
        }
        double[] sums = new double[numRows];
        int[] counts = new int[numRows];
        int sourceIndex = 0;
        for (int col2 = 0; col2 < rowLength; ++col2) {
            for (int row2 = 0; row2 < numRows; ++row2) {
                double value = x.getElementAsDouble(sourceIndex++);
                if (!naRm) {
                    int n = row2;
                    sums[n] = sums[n] + value;
                    int n2 = row2;
                    counts[n2] = counts[n2] + 1;
                    continue;
                }
                if (Double.isNaN(value)) continue;
                int n = row2;
                sums[n] = sums[n] + value;
                int n3 = row2;
                counts[n3] = counts[n3] + 1;
            }
        }
        for (int row3 = 0; row3 < numRows; ++row3) {
            int n = row3;
            sums[n] = sums[n] / (double)counts[row3];
        }
        return DoubleArrayVector.unsafe(sums);
    }

    @Internal
    public static DoubleVector colSums(AtomicVector x, int columnLength, int numColumns, boolean naRm) {
        DeferredColSums dcs = new DeferredColSums(x, numColumns, naRm, AttributeMap.EMPTY);
        if (System.getProperty("renjin.disable.colsums") != null) {
            return (DoubleVector)dcs.forceResult();
        }
        return dcs;
    }

    @Internal
    public static DoubleVector colMeans(AtomicVector x, int columnLength, int numColumns, boolean naRm) {
        double[] sums = new double[numColumns];
        int[] counts = new int[numColumns];
        for (int column = 0; column < numColumns; ++column) {
            int sourceIndex = columnLength * column;
            double sum2 = 0.0;
            int count = 0;
            for (int row2 = 0; row2 < columnLength; ++row2) {
                double cellValue;
                if (Double.isNaN(cellValue = x.getElementAsDouble(sourceIndex++))) {
                    if (naRm) continue;
                    sum2 = DoubleVector.NA;
                    break;
                }
                sum2 += cellValue;
                ++count;
            }
            sums[column] = sum2;
            counts[column] = count;
        }
        for (int i = 0; i != sums.length; ++i) {
            sums[i] = sums[i] / (double)counts[i];
        }
        return new DoubleArrayVector(sums);
    }

    @Internal
    public static SEXP aperm(Vector source, AtomicVector permutationVector, boolean resize) {
        if (!resize) {
            throw new UnsupportedOperationException("resize=TRUE not yet implemented");
        }
        Vector dimExp = source.getAttributes().getDim();
        EvalException.check(dimExp instanceof IntVector, "invalid first argument, must be an array", new Object[0]);
        int[] permutation = Matrices.toPermutationArray(permutationVector);
        if (Matrices.isIdentityPermutation(permutation)) {
            return source;
        }
        if (source instanceof DoubleVector && Matrices.isMatrixTransposition(permutation) && source.length() > 0) {
            return Matrices.transpose(source);
        }
        int[] dim2 = ((IntVector)dimExp).toIntArray();
        int[] permutedDims = Indexes.permute(dim2, permutation);
        Vector.Builder newVector = source.newBuilderWithInitialSize(source.length());
        int[] index = new int[dim2.length];
        for (int i = 0; i != newVector.length(); ++i) {
            Indexes.vectorIndexToArrayIndex(i, index, dim2);
            index = Indexes.permute(index, permutation);
            int newIndex = Indexes.arrayIndexToVectorIndex(index, permutedDims);
            newVector.setFrom(newIndex, source, i);
        }
        newVector.setAttribute(Symbols.DIM, (SEXP)new IntArrayVector(permutedDims));
        for (PairList.Node node : source.getAttributes().nodes()) {
            if (node.getTag().equals(Symbols.DIM)) continue;
            if (node.getTag().equals(Symbols.DIMNAMES)) {
                newVector.setAttribute(node.getName(), (SEXP)Indexes.permute((Vector)node.getValue(), permutation));
                continue;
            }
            newVector.setAttribute(node.getName(), node.getValue());
        }
        return newVector.build();
    }

    public static boolean isMatrixTransposition(int[] permutation) {
        return permutation.length == 2 && permutation[0] == 1 && permutation[1] == 0;
    }

    public static boolean isIdentityPermutation(int[] permutation) {
        for (int i = 0; i != permutation.length; ++i) {
            if (permutation[i] == i) continue;
            return false;
        }
        return true;
    }

    public static int[] toPermutationArray(Vector vector2) {
        int[] values = new int[vector2.length()];
        for (int i = 0; i != values.length; ++i) {
            values[i] = vector2.getElementAsInt(i) - 1;
        }
        return values;
    }

    @Internal
    public static Vector matrix(@Current Context context, Vector data, int nrow, int ncol, boolean byRow, Vector dimnames2, boolean nrowMissing, boolean ncolMissing) {
        if (data == Null.INSTANCE) {
            throw new EvalException("'data' must be of vector type, was 'NULL'", new Object[0]);
        }
        int dataLength = data.length();
        if (nrow != 1) {
            nrowMissing = false;
        }
        if (ncol != 1) {
            ncolMissing = false;
        }
        if (nrowMissing && ncolMissing) {
            nrow = dataLength;
        } else if (nrowMissing) {
            nrow = (int)Math.ceil((double)dataLength / (double)ncol);
        } else if (ncolMissing) {
            ncol = (int)Math.ceil((double)dataLength / (double)nrow);
        }
        if (dataLength > 0) {
            if (dataLength > 1 && nrow * ncol % dataLength != 0) {
                if (dataLength > nrow && dataLength / nrow * nrow != dataLength || dataLength < nrow && nrow / dataLength * dataLength != nrow) {
                    Warning.invokeWarning(context, "data length [%d] is not a sub-multiple or multiple of the number of rows [%d]", dataLength, nrow);
                } else if (dataLength > ncol && dataLength / ncol * ncol != dataLength || dataLength < ncol && ncol / dataLength * dataLength != ncol) {
                    Warning.invokeWarning(context, "data length [%d] is not a sub-multiple or multiple of the number of columns [%d]", dataLength, ncol);
                }
            } else if (dataLength > 1 && nrow * ncol == 0) {
                Warning.invokeWarning(context, "data length exceeds size of matrix", new Object[0]);
            }
        }
        AttributeMap attributes2 = AttributeMap.builder().setDim(nrow, ncol).set(Symbols.DIMNAMES, (SEXP)dimnames2).build();
        int resultLength = nrow * ncol;
        if (!byRow && data instanceof AtomicVector && resultLength == data.length()) {
            return (Vector)data.setAttributes(attributes2);
        }
        if (!byRow && resultLength > 500 && data instanceof DoubleVector) {
            return new RepDoubleVector(data, resultLength, 1, attributes2);
        }
        return Matrices.allocMatrix(data, nrow, ncol, byRow, dimnames2);
    }

    private static Vector allocMatrix(Vector data, int nrow, int ncol, boolean byRow, Vector dimnames2) {
        Vector.Builder result = null;
        int dataLength = data.length();
        int outLength = nrow * ncol;
        if (dataLength == 1 && outLength > 0 && data instanceof LogicalVector) {
            result = RepLogicalVector.newConstantBuilder(data.getElementAsLogical(0), outLength);
        } else {
            result = data.newBuilderWithInitialSize(nrow * ncol);
            if (dataLength > 0) {
                int i = 0;
                if (!byRow) {
                    for (int col2 = 0; col2 < ncol; ++col2) {
                        for (int row2 = 0; row2 < nrow; ++row2) {
                            int sourceIndex = Indexes.matrixIndexToVectorIndex(row2, col2, nrow, ncol) % dataLength;
                            result.setFrom(i++, data, sourceIndex);
                        }
                    }
                } else {
                    for (int row3 = 0; row3 < nrow; ++row3) {
                        for (int col3 = 0; col3 < ncol; ++col3) {
                            result.setFrom(row3 + col3 * nrow, data, i % dataLength);
                            ++i;
                        }
                    }
                }
            }
        }
        result.setDim(nrow, ncol);
        result.setAttribute(Symbols.DIMNAMES, (SEXP)dimnames2);
        return result.build();
    }

    @Internal
    public static IntVector row(IntVector dims) {
        if (dims.length() != 2) {
            throw new EvalException("a matrix-like object is required as argument to 'row/col'", new Object[0]);
        }
        final int rows = dims.getElementAsInt(0);
        int cols = dims.getElementAsInt(1);
        ComputingIntVector.Functor fn = new ComputingIntVector.Functor(){

            @Override
            public int apply(int index) {
                return index % rows + 1;
            }
        };
        return new ComputingIntVector(fn, rows * cols, AttributeMap.dim(rows, cols));
    }

    @Internal
    public static IntVector col(IntVector dims) {
        if (dims.length() != 2) {
            throw new EvalException("a matrix-like object is required as argument to 'row/col'", new Object[0]);
        }
        final int rows = dims.getElementAsInt(0);
        int cols = dims.getElementAsInt(1);
        ComputingIntVector.Functor fn = new ComputingIntVector.Functor(){

            @Override
            public int apply(int index) {
                return index / rows + 1;
            }
        };
        return new ComputingIntVector(fn, rows * cols, AttributeMap.dim(rows, cols));
    }
}

