/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.special;

import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.codegen.ArgumentIterator;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SpecialFunction;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;

public class SwitchFunction
extends SpecialFunction {
    public SwitchFunction() {
        super("switch");
    }

    @Override
    public SEXP apply(Context context, Environment rho, FunctionCall call2, PairList args2) {
        return SwitchFunction.doApply(context, rho, call2, args2);
    }

    private static SEXP doApply(Context context, Environment rho, FunctionCall call2, PairList args2) {
        ArgumentIterator argIt = new ArgumentIterator(context, rho, args2);
        if (!argIt.hasNext()) {
            throw new EvalException("argument \"EXPR\" is missing", new Object[0]);
        }
        PairList.Node exprNode = argIt.nextNode();
        if (exprNode.hasTag() && !exprNode.getTag().getPrintName().equals("EXPR")) {
            throw new EvalException("supplied argument name '%s' does not match 'EXPR'", exprNode.getTag().getPrintName());
        }
        SEXP expr = context.evaluate(exprNode.getValue(), rho);
        if (expr.length() == 1) {
            if (expr instanceof StringVector) {
                return SwitchFunction.matchByName(context, rho, expr, argIt);
            }
            if (expr instanceof AtomicVector) {
                return SwitchFunction.matchByPosition(context, rho, expr, argIt);
            }
        }
        throw new EvalException("EXPR must be a length 1 vector", new Object[0]);
    }

    private static SEXP matchByName(Context context, Environment rho, SEXP expr, ArgumentIterator argIt) {
        String name = expr.asString();
        if (StringVector.isNA(name)) {
            name = "NA";
        }
        while (argIt.hasNext()) {
            PairList.Node argNode = argIt.nextNode();
            if (argNode.hasTag() && argNode.getTag().getPrintName().equals(name)) {
                while (argNode.getValue() == Symbol.MISSING_ARG && argIt.hasNext()) {
                    argNode = argIt.nextNode();
                }
                return context.evaluate(argNode.getValue(), rho);
            }
            if (argNode.hasTag() || argIt.hasNext()) continue;
            return context.evaluate(argNode.getValue(), rho);
        }
        return Null.INSTANCE;
    }

    private static SEXP matchByPosition(Context context, Environment rho, SEXP expr, ArgumentIterator argIt) {
        int pos = ((AtomicVector)expr).getElementAsInt(0);
        if (!IntVector.isNA(pos) && pos > 0) {
            int argIndex = 1;
            while (argIt.hasNext()) {
                PairList.Node argNode = argIt.nextNode();
                if (argIndex == pos) {
                    return context.evaluate(argNode.getValue(), rho);
                }
                ++argIndex;
            }
        }
        return Null.INSTANCE;
    }

    public static SEXP matchAndApply(Context context, Environment rho, FunctionCall call2, String[] argumentNames, SEXP[] arguments) {
        PairList.Builder args2 = new PairList.Builder();
        for (int i = 0; i != arguments.length; ++i) {
            args2.add(argumentNames[i], arguments[i]);
        }
        return SwitchFunction.doApply(context, rho, call2, args2.build());
    }
}

