/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.subset;

import java.util.HashSet;
import java.util.Set;
import org.renjin.eval.EvalException;
import org.renjin.primitives.subset.EmptyIndexIterator;
import org.renjin.primitives.subset.IndexIterator;
import org.renjin.primitives.subset.IndexPredicate;
import org.renjin.primitives.subset.Subscript;
import org.renjin.primitives.subset.SubsetAssertions;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.IntVector;

class IndexSubscript
implements Subscript {
    private AtomicVector subscript;
    private int sourceLength;

    public IndexSubscript(AtomicVector subscript, int sourceLength) {
        this.subscript = subscript;
        this.sourceLength = sourceLength;
    }

    @Override
    public int computeUniqueIndex() {
        SubsetAssertions.checkUnitLength(this.subscript);
        int index = this.subscript.getElementAsInt(0);
        if (index == 0) {
            throw new EvalException("attempt to select less than one element", new Object[0]);
        }
        if (index > 0) {
            return index - 1;
        }
        if (index < 0) {
            int excludedIndex = -index - 1;
            if (this.sourceLength == 1 && excludedIndex != 0) {
                return 0;
            }
            if (this.sourceLength == 2) {
                if (excludedIndex == 0) {
                    return 1;
                }
                if (excludedIndex == 1) {
                    return 0;
                }
            }
        }
        throw new EvalException("attempt to select more than one element", new Object[0]);
    }

    @Override
    public IndexIterator computeIndexes() {
        int sign2 = this.computeIndexSign();
        if (sign2 == -1) {
            return new HashedNegativeIndexIterator();
        }
        if (sign2 == 1) {
            return new PositiveIndexIterator();
        }
        return EmptyIndexIterator.INSTANCE;
    }

    @Override
    public IndexPredicate computeIndexPredicate() {
        int sign2 = this.computeIndexSign();
        if (sign2 == -1) {
            return new HashedNegativeIndexPredicate();
        }
        return new PositiveHashPredicate();
    }

    @Override
    public int computeCount() {
        int count = 0;
        IndexIterator it = this.computeIndexes();
        while (it.next() != -1) {
            ++count;
        }
        return count;
    }

    private int computeIndexSign() {
        for (int i = 0; i < this.subscript.length(); ++i) {
            int index = this.subscript.getElementAsInt(i);
            if (IntVector.isNA(index)) {
                return 1;
            }
            if (index == 0) continue;
            if (index < 0) {
                return -1;
            }
            if (index <= 0) continue;
            return 1;
        }
        return 0;
    }

    private Set<Integer> buildExcludedSet() {
        HashSet<Integer> excludedSet = new HashSet<Integer>();
        for (int i = 0; i < this.subscript.length(); ++i) {
            int subscript = this.subscript.getElementAsInt(i);
            if (subscript < 0) {
                int excludedIndex = -subscript - 1;
                excludedSet.add(excludedIndex);
                continue;
            }
            if (subscript == 0) continue;
            throw new EvalException("only 0's may be mixed with negative subscripts", new Object[0]);
        }
        return excludedSet;
    }

    private class PositiveHashPredicate
    implements IndexPredicate {
        private Set<Integer> includeSet = new HashSet<Integer>();

        public PositiveHashPredicate() {
            for (int i = 0; i < IndexSubscript.this.subscript.length(); ++i) {
                int index = IndexSubscript.this.subscript.getElementAsInt(i);
                if (IntVector.isNA(index) || index <= 0) continue;
                this.includeSet.add(index - 1);
            }
        }

        @Override
        public boolean apply(int index) {
            return this.includeSet.contains(index);
        }
    }

    private class PositiveIndexIterator
    implements IndexIterator {
        private int nextSubscriptIndex = 0;

        private PositiveIndexIterator() {
        }

        @Override
        public int next() {
            int nextSubscript;
            do {
                if (this.nextSubscriptIndex >= IndexSubscript.this.subscript.length()) {
                    return -1;
                }
                nextSubscript = IndexSubscript.this.subscript.getElementAsInt(this.nextSubscriptIndex++);
                if (IntVector.isNA(nextSubscript)) {
                    return nextSubscript;
                }
                if (nextSubscript <= 0) continue;
                return nextSubscript - 1;
            } while (nextSubscript >= 0);
            throw new EvalException("only 0's may be mixed with negative subscripts", new Object[0]);
        }

        @Override
        public void restart() {
            this.nextSubscriptIndex = 0;
        }
    }

    private class HashedNegativeIndexPredicate
    implements IndexPredicate {
        private Set<Integer> excludeSet;

        private HashedNegativeIndexPredicate() {
            this.excludeSet = IndexSubscript.this.buildExcludedSet();
        }

        @Override
        public boolean apply(int index) {
            return this.excludeSet.contains(index);
        }
    }

    private class HashedNegativeIndexIterator
    implements IndexIterator {
        private int nextIndex = 0;
        private Set<Integer> excludeSet = IndexSubscript.access$300(IndexSubscript.this);

        private HashedNegativeIndexIterator() {
        }

        @Override
        public int next() {
            while (this.nextIndex < IndexSubscript.this.sourceLength) {
                if (!this.excludeSet.contains(this.nextIndex)) {
                    return this.nextIndex++;
                }
                ++this.nextIndex;
            }
            return -1;
        }

        @Override
        public void restart() {
            this.nextIndex = 0;
        }
    }
}

