/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.sexp;

import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.repackaged.guava.base.Objects;
import org.renjin.repackaged.guava.base.Preconditions;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Logical;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public abstract class AbstractSEXP
implements SEXP {
    private AttributeMap attributes;
    private boolean object;

    protected AbstractSEXP() {
        this.attributes = AttributeMap.EMPTY;
        this.object = false;
    }

    protected AbstractSEXP(AttributeMap attributes2) {
        Preconditions.checkNotNull(attributes2);
        this.attributes = attributes2;
        this.object = attributes2.hasClass();
    }

    protected boolean checkDims() {
        Vector dimVector = this.attributes.getDim();
        if (dimVector.length() == 0) {
            return true;
        }
        int length2 = 1;
        for (int i = 0; i != dimVector.length(); ++i) {
            length2 *= dimVector.getElementAsInt(i);
        }
        return length2 == this.length();
    }

    @Override
    public int length() {
        return 1;
    }

    @Override
    public final boolean hasAttributes() {
        return this.attributes != AttributeMap.EMPTY;
    }

    @Override
    public AttributeMap getAttributes() {
        return this.attributes;
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public Logical asLogical() {
        return Logical.NA;
    }

    @Override
    public double asReal() {
        return DoubleVector.NA;
    }

    @Override
    public int asInt() {
        return Integer.MIN_VALUE;
    }

    @Override
    public StringVector getS3Class() {
        AtomicVector classAttribute = this.attributes.getClassVector();
        if (classAttribute instanceof StringVector) {
            return (StringVector)classAttribute;
        }
        return new StringArrayVector(this.getImplicitClass());
    }

    @Override
    public String getImplicitClass() {
        return this.getTypeName();
    }

    @Override
    public boolean inherits(String sClassName) {
        if (this.isObject()) {
            Vector classes = (Vector)this.getAttribute(Symbols.CLASS);
            for (int i = 0; i != classes.length(); ++i) {
                if (!sClassName.equals(classes.getElementAsString(i))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public AtomicVector getNames() {
        if (this.attributes.getDim().length() == 1) {
            return this.attributes.getDimNames(0);
        }
        return this.attributes.getNamesOrNull();
    }

    @Override
    public boolean hasNames() {
        return this.getNames() instanceof StringVector;
    }

    @Override
    public String getName(int index) {
        if (this.hasNames()) {
            return this.getNames().getElementAsString(index);
        }
        return "";
    }

    public boolean hasName(int i) {
        return !"".equals(this.getName(i));
    }

    @Override
    public final int getIndexByName(String name) {
        SEXP namesExp;
        if (this.attributes != null && (namesExp = this.attributes.get(Symbols.NAMES)) instanceof StringVector) {
            StringVector names2 = (StringVector)namesExp;
            for (int i = 0; i != names2.length(); ++i) {
                if (!Objects.equal(names2.getElementAsString(i), name)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public final boolean isObject() {
        return this.object;
    }

    @Override
    public SEXP getAttribute(Symbol name) {
        return this.attributes.get(name);
    }

    @Override
    public final SEXP setAttribute(String attributeName, SEXP value) {
        return this.setAttribute(Symbol.get(attributeName), value);
    }

    @Override
    public SEXP setAttribute(Symbol attributeName, SEXP value) {
        return this.setAttributes(this.attributes.copy().set(attributeName, value));
    }

    @Override
    public SEXP setAttributes(AttributeMap attributes2) {
        return this.cloneWithNewAttributes(attributes2);
    }

    @Override
    public SEXP setAttributes(AttributeMap.Builder attributes2) {
        return this.cloneWithNewAttributes(attributes2.validateAndBuildForVectorOfLength(this.length()));
    }

    protected SEXP cloneWithNewAttributes(AttributeMap attributes2) {
        if (attributes2 != AttributeMap.EMPTY) {
            throw new EvalException("cannot change/set attributes on " + this.getClass().getName(), new Object[0]);
        }
        return this;
    }

    @Override
    public String asString() {
        throw new EvalException("Cannot coerce " + this.getTypeName() + " to scalar string", new Object[0]);
    }

    @Override
    public <S extends SEXP> S getElementAsSEXP(int index) {
        if (index == 0) {
            return (S)this;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public SEXP force(Context context) {
        return this;
    }

    @Override
    public SEXP force(Context context, boolean allowMissing) {
        return this.force(context);
    }

    public void unsafeSetAttributes(AttributeMap attributeMap) {
        this.attributes = attributeMap;
        this.object = this.attributes.hasClass();
    }

    public void unsafeSetAttributes(AttributeMap.Builder attributes2) {
        this.unsafeSetAttributes(attributes2.validateAndBuildFor(this));
    }
}

