/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.nls;

import java.io.IOException;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Internal;
import org.renjin.primitives.matrix.AbstractMatrixBuilder;
import org.renjin.primitives.matrix.DoubleMatrixBuilder;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Vector;
import org.renjin.stats.nls.NlsControl;
import org.renjin.stats.nls.NlsModel;

public class NonlinearLeastSquares {
    private static SEXP convergenceResult(NlsControl object2, String string, int n, StopReason stopReason, double d) {
        if (!((NlsControl)object2).isWarnOnly() && stopReason != StopReason.CONVERGED) {
            throw new EvalException(string, new Object[0]);
        }
        object2 = ListVector.newNamedBuilder();
        boolean bl = stopReason == StopReason.CONVERGED;
        ((ListVector.NamedBuilder)object2).add("isConv", bl);
        ((ListVector.NamedBuilder)object2).add("finIter", n);
        ((ListVector.NamedBuilder)object2).add("finTol", d);
        ((ListVector.NamedBuilder)object2).add("stopCode", stopReason.ordinal());
        ((ListVector.NamedBuilder)object2).add("stopMessage", string);
        return ((ListVector.Builder)object2).build();
    }

    @Internal
    public static SEXP iterate(@Current Context objectArray, ListVector object2, ListVector listVector, boolean bl) throws IOException {
        int n;
        NlsModel nlsModel = new NlsModel((Context)objectArray, (ListVector)object2);
        object2 = new NlsControl(listVector);
        AtomicVector atomicVector = nlsModel.getParameterValues();
        int n2 = atomicVector.length();
        double d = nlsModel.calculateDeviation();
        if (bl) {
            nlsModel.trace();
        }
        double d2 = 1.0;
        boolean bl2 = false;
        double[] dArray = new double[n2];
        int n3 = 1;
        double d3 = Double.POSITIVE_INFINITY;
        for (n = 0; n < ((NlsControl)object2).getMaxIterations(); ++n) {
            d3 = nlsModel.getConvergence();
            if (d3 < ((NlsControl)object2).getTolerance()) {
                bl2 = true;
                break;
            }
            DoubleVector doubleVector = nlsModel.calculateIncrements();
            int n4 = 1;
            while (d2 >= ((NlsControl)object2).getMinFactor()) {
                if (((NlsControl)object2).isPrintEval()) {
                    Object[] objectArray2 = new Object[]{n + 1, d2, n4, n3};
                    objectArray.getSession().getStdOut().printf("  It. %3d, fac= %11.6f, eval (no.,total): (%2d,%3d):\n", objectArray2);
                    ++n4;
                    ++n3;
                }
                for (int i = 0; i < n2; ++i) {
                    dArray[i] = atomicVector.getElementAsDouble(i) + d2 * doubleVector.getElementAsDouble(i);
                }
                if (nlsModel.updateParameters(dArray)) {
                    return NonlinearLeastSquares.convergenceResult((NlsControl)object2, "singular gradient", n, StopReason.SINGULAR_GRADIENT, d3);
                }
                double d4 = nlsModel.calculateDeviation();
                if (((NlsControl)object2).isPrintEval()) {
                    objectArray.getSession().getStdOut().printf(" new dev = %f\n", d4);
                }
                if (d4 <= d) {
                    d = d4;
                    d2 = Math.min(2.0 * d2, 1.0);
                    atomicVector = new DoubleArrayVector(dArray);
                    break;
                }
                d2 /= 2.0;
            }
            if (d2 < ((NlsControl)object2).getMinFactor()) {
                objectArray = new Object[]{d2, ((NlsControl)object2).getMinFactor()};
                return NonlinearLeastSquares.convergenceResult((NlsControl)object2, String.format("step factor %f reduced below 'minFactor' of %f", objectArray), n, StopReason.MIN_FACTOR_REACHED, d3);
            }
            if (!bl) continue;
            nlsModel.trace();
        }
        if (!bl2) {
            return NonlinearLeastSquares.convergenceResult((NlsControl)object2, String.format("number of iterations exceeded maximum of %d", ((NlsControl)object2).getMaxIterations()), n, StopReason.MAX_ITERATIONS_EXCEEDED, d3);
        }
        return NonlinearLeastSquares.convergenceResult((NlsControl)object2, "converged", n, StopReason.CONVERGED, d3);
    }

    public static SEXP numericDerivative(@Current Context context, SEXP sEXP, StringVector stringVector, Environment environment2, DoubleVector doubleVector) {
        Object object2;
        int n;
        if (doubleVector.length() != stringVector.length()) {
            throw new EvalException("'dir' is not a numeric vector of the correct length", new Object[0]);
        }
        SEXP sEXP2 = context.evaluate(sEXP, environment2);
        if (!(sEXP2 instanceof Vector)) {
            throw new EvalException("Expected numeric response from model", new Object[0]);
        }
        sEXP2 = (Vector)sEXP2;
        for (int i = 0; i != sEXP2.length(); ++i) {
            if (DoubleVector.isFinite(sEXP2.getElementAsDouble(i))) continue;
            throw new EvalException("Missing value or an infinity produced when evaluating the model", new Object[0]);
        }
        double[][] dArrayArray = new double[stringVector.length()][];
        int n2 = 0;
        for (n = 0; n < stringVector.length(); ++n) {
            object2 = stringVector.getElementAsString(n);
            SEXP sEXP3 = environment2.findVariable(context, Symbol.get((String)object2));
            if (!(sEXP3 instanceof AtomicVector)) {
                throw new EvalException("variable '%s' is not numeric", object2);
            }
            dArrayArray[n] = ((AtomicVector)sEXP3).toDoubleArray();
            n2 += dArrayArray[n].length;
        }
        double d = Math.sqrt(2.220446E-16);
        object2 = new DoubleMatrixBuilder(sEXP2.length(), n2);
        n = 0;
        for (int i = 0; i < stringVector.length(); ++i) {
            double d2 = doubleVector.getElementAsDouble(i);
            for (int j = 0; j < dArrayArray[i].length; ++j) {
                double d3 = dArrayArray[i][j];
                double d4 = Math.abs(d3);
                double d5 = d4 == 0.0 ? d : d4 * d;
                d4 = d5;
                double[] dArray = dArrayArray[i];
                dArray[j] = d5 = dArray[j] + d2 * d5;
                environment2.setVariable(context, stringVector.getElementAsString(i), (SEXP)new DoubleArrayVector(dArrayArray[i]));
                DoubleVector doubleVector2 = (DoubleVector)context.evaluate(sEXP, environment2);
                for (int k = 0; k < sEXP2.length(); ++k) {
                    if (!DoubleVector.isFinite(doubleVector2.getElementAsDouble(k))) {
                        throw new EvalException("Missing value or an infinity produced when evaluating the model", new Object[0]);
                    }
                    ((DoubleMatrixBuilder)object2).set(k, n, d2 * ((doubleVector2.getElementAsDouble(k) - sEXP2.getElementAsDouble(k)) / d4));
                }
                dArrayArray[i][j] = d3;
                ++n;
            }
            environment2.setVariable(context, stringVector.getElementAsString(i), (SEXP)new DoubleArrayVector(dArrayArray[i]));
        }
        return sEXP2.setAttribute(Symbol.get("gradient"), (SEXP)((AbstractMatrixBuilder)object2).build());
    }

    private static final class StopReason
    extends Enum<StopReason> {
        public static final /* enum */ StopReason CONVERGED = new StopReason();
        public static final /* enum */ StopReason SINGULAR_GRADIENT = new StopReason();
        public static final /* enum */ StopReason MIN_FACTOR_REACHED = new StopReason();
        public static final /* enum */ StopReason MAX_ITERATIONS_EXCEEDED = new StopReason();
        private static final /* synthetic */ StopReason[] $VALUES;

        static {
            StopReason[] stopReasonArray = new StopReason[]{CONVERGED, SINGULAR_GRADIENT, MIN_FACTOR_REACHED, MAX_ITERATIONS_EXCEEDED};
            $VALUES = stopReasonArray;
        }

        public static StopReason valueOf(String string) {
            return Enum.valueOf(StopReason.class, string);
        }

        public static StopReason[] values() {
            return (StopReason[])$VALUES.clone();
        }
    }
}

