/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.rxp90.jsymspell;

import io.gitlab.rxp90.jsymspell.SuggestItem;
import io.gitlab.rxp90.jsymspell.SuggestionStage;
import io.gitlab.rxp90.jsymspell.api.DamerauLevenshteinOSA;
import io.gitlab.rxp90.jsymspell.api.EditDistance;
import io.gitlab.rxp90.jsymspell.api.StringHasher;
import io.gitlab.rxp90.jsymspell.exceptions.NotInitializedException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SymSpell {
    public static final String LEXICON_DELIMITER = "\t";
    private final int maxDictionaryEditDistance;
    private final int prefixLength;
    private final int countThreshold;
    private final Map<Long, String[]> deletes = new HashMap<Long, String[]>();
    private final Map<String, Long> lexiconWords = new HashMap<String, Long>();
    private final Map<String, Long> lexiconBigrams = new HashMap<String, Long>();
    private final Map<String, Long> belowThresholdWords = new HashMap<String, Long>();
    private final EditDistance damerauLevenshteinOSA;
    private final StringHasher stringHasher;
    private int maxDictionaryWordLength;
    private static final long N = 1024908267229L;
    private long bigramCountMin = Long.MAX_VALUE;

    SymSpell(int maxDictionaryEditDistance, int prefixLength, int countThreshold, StringHasher stringHasher, Map<Long, String[]> deletes, Collection<String> lexiconWords, Collection<String> lexiconBigrams) {
        this.maxDictionaryEditDistance = maxDictionaryEditDistance;
        this.prefixLength = prefixLength;
        this.countThreshold = countThreshold;
        this.stringHasher = stringHasher;
        this.deletes.putAll(deletes);
        this.damerauLevenshteinOSA = new DamerauLevenshteinOSA();
        this.initLexiconWords(lexiconWords);
        this.initLexiconBigrams(lexiconBigrams);
    }

    private boolean deleteSuggestionPrefix(String delete, int deleteLen, String suggestion, int suggestionLen) {
        if (deleteLen == 0) {
            return true;
        }
        int adjustedSuggestionLen = Math.min(this.prefixLength, suggestionLen);
        int j = 0;
        for (int i = 0; i < deleteLen; ++i) {
            char delChar = delete.charAt(i);
            while (j < adjustedSuggestionLen && delChar != suggestion.charAt(j)) {
                ++j;
            }
            if (j != adjustedSuggestionLen) continue;
            return false;
        }
        return true;
    }

    Set<String> edits(String word, int editDistance, Set<String> deleteWords) {
        if (word.length() > 1 && ++editDistance <= this.maxDictionaryEditDistance) {
            for (int i = 0; i < word.length(); ++i) {
                StringBuilder editableWord = new StringBuilder(word);
                String delete = editableWord.deleteCharAt(i).toString();
                if (!deleteWords.add(delete) || editDistance >= this.maxDictionaryEditDistance) continue;
                this.edits(delete, editDistance, deleteWords);
            }
        }
        return deleteWords;
    }

    private Set<String> editsPrefix(String key) {
        HashSet<String> set = new HashSet<String>();
        if (key.length() <= this.maxDictionaryEditDistance) {
            set.add("");
        }
        if (key.length() > this.prefixLength) {
            key = key.substring(0, this.prefixLength);
        }
        set.add(key);
        return this.edits(key, 0, set);
    }

    private Map.Entry<String, Long> parse(String line) {
        String[] parts = line.split(LEXICON_DELIMITER);
        return new AbstractMap.SimpleEntry<String, Long>(parts[0], Long.parseLong(parts[1]));
    }

    private void initLexiconWords(Collection<String> lexicon) {
        SuggestionStage staging = new SuggestionStage(16384);
        lexicon.forEach(line -> {
            Map.Entry<String, Long> entry = this.parse((String)line);
            this.createDictionaryEntry(entry, staging);
        });
        this.commitStaged(staging);
    }

    private void initLexiconBigrams(Collection<String> lexicon) {
        lexicon.forEach(line -> {
            Map.Entry<String, Long> entry = this.parse((String)line);
            long count = entry.getValue();
            this.lexiconBigrams.put(entry.getKey(), count);
            if (count < this.bigramCountMin) {
                this.bigramCountMin = count;
            }
        });
    }

    private void commitStaged(SuggestionStage staging) {
        staging.commitTo(this.deletes);
    }

    private void createDictionaryEntry(Map.Entry<String, Long> entry, SuggestionStage staging) {
        String key = entry.getKey();
        long count = entry.getValue();
        if (count <= 0L) {
            if (this.countThreshold > 0) {
                return;
            }
            count = 0L;
        }
        Long countPrevious = this.belowThresholdWords.get(key);
        if (this.countThreshold > 1 && countPrevious != null) {
            long l = count = Long.MAX_VALUE - countPrevious > count ? countPrevious + count : Long.MAX_VALUE;
            if (count >= (long)this.countThreshold) {
                this.belowThresholdWords.remove(key);
            } else {
                this.belowThresholdWords.put(key, count);
            }
        } else {
            if (this.lexiconWords.containsKey(key)) {
                countPrevious = this.lexiconWords.get(key);
                count = Long.MAX_VALUE - countPrevious > count ? countPrevious + count : Long.MAX_VALUE;
                this.lexiconWords.put(key, count);
                return;
            }
            if (count < (long)this.countThreshold) {
                this.belowThresholdWords.put(key, count);
                return;
            }
            this.lexiconWords.put(key, count);
            if (key.length() > this.maxDictionaryWordLength) {
                this.maxDictionaryWordLength = key.length();
            }
            this.generateDeletes(key, staging);
        }
    }

    private void generateDeletes(String key, SuggestionStage staging) {
        Set<String> edits = this.editsPrefix(key);
        if (staging != null) {
            edits.forEach(delete -> staging.add(this.stringHasher.hash((String)delete), key));
        } else {
            edits.forEach(delete -> {
                long deleteHash = this.stringHasher.hash((String)delete);
                String[] suggestions = this.deletes.get(deleteHash);
                if (suggestions != null) {
                    String[] newSuggestions = Arrays.copyOf(suggestions, suggestions.length + 1);
                    this.deletes.put(deleteHash, newSuggestions);
                    suggestions = newSuggestions;
                } else {
                    suggestions = new String[1];
                    this.deletes.put(deleteHash, suggestions);
                }
                suggestions[suggestions.length - 1] = key;
            });
        }
    }

    public List<SuggestItem> lookup(String input, Verbosity verbosity) throws NotInitializedException {
        return this.lookup(input, verbosity, this.maxDictionaryEditDistance, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private List<SuggestItem> lookup(String input, Verbosity verbosity, int maxEditDistance, boolean includeUnknown) throws NotInitializedException {
        if (maxEditDistance > this.maxDictionaryEditDistance) {
            throw new IllegalArgumentException("maxEditDistance > maxDictionaryEditDistance");
        }
        if (this.lexiconWords.isEmpty()) {
            throw new NotInitializedException("There are no words in the dictionary. Please, call `loadDictionary` to add words.");
        }
        ArrayList<SuggestItem> suggestions = new ArrayList<SuggestItem>();
        int inputLen = input.length();
        if (inputLen - maxEditDistance > this.maxDictionaryWordLength) {
            return Collections.emptyList();
        }
        if (this.lexiconWords.containsKey(input)) {
            suggestions.add(new SuggestItem(input, 0, this.lexiconWords.get(input).longValue()));
            if (!Verbosity.ALL.equals((Object)verbosity)) {
                return suggestions;
            }
        }
        if (maxEditDistance == 0) {
            return suggestions;
        }
        HashSet<String> deletesAlreadyConsidered = new HashSet<String>();
        HashSet<String> suggestionsAlreadyConsidered = new HashSet<String>();
        suggestionsAlreadyConsidered.add(input);
        int maxEditDistance2 = maxEditDistance;
        int candidatePointer = 0;
        ArrayList<String> candidates = new ArrayList<String>();
        int inputPrefixLen = inputLen;
        if (inputPrefixLen > this.prefixLength) {
            inputPrefixLen = this.prefixLength;
            candidates.add(input.substring(0, inputPrefixLen));
        } else {
            candidates.add(input);
        }
        while (candidatePointer < candidates.size()) {
            String candidate;
            int candidateLength;
            int lengthDiff;
            if ((lengthDiff = inputPrefixLen - (candidateLength = (candidate = (String)candidates.get(candidatePointer++)).length())) > maxEditDistance2) {
                if (!verbosity.equals((Object)Verbosity.ALL)) break;
                continue;
            }
            String[] dictSuggestions = this.deletes.get(this.stringHasher.hash(candidate));
            if (dictSuggestions != null) {
                block5: for (String suggestion : dictSuggestions) {
                    int distance;
                    int suggestionPrefixLen;
                    int suggestionLen;
                    if (suggestion == null || suggestion.equals(input) || Math.abs((suggestionLen = suggestion.length()) - inputLen) > maxEditDistance2 || suggestionLen < candidateLength || suggestionLen == candidateLength && !suggestion.equals(candidate) || (suggestionPrefixLen = Math.min(suggestionLen, this.prefixLength)) > inputPrefixLen && suggestionPrefixLen - candidateLength > maxEditDistance2) continue;
                    int min = 0;
                    if (candidateLength == 0) {
                        distance = Math.max(inputLen, suggestionLen);
                        if (distance > maxEditDistance2) continue;
                        suggestionsAlreadyConsidered.add(suggestion);
                        continue;
                    }
                    if (suggestionLen == 1) {
                        distance = input.indexOf(suggestion.charAt(0)) < 0 ? inputLen : inputLen - 1;
                        if (distance > maxEditDistance2) continue;
                        suggestionsAlreadyConsidered.add(suggestion);
                        continue;
                    }
                    if (this.prefixLength - maxEditDistance == candidateLength && (min = Math.min(inputLen, suggestionLen) - this.prefixLength) > 1 && !input.substring(inputLen + 1 - min).equals(suggestion.substring(suggestionLen + 1 - min)) || min > 0 && input.charAt(inputLen - min) != suggestion.charAt(suggestionLen - min) && (input.charAt(inputLen - min - 1) != suggestion.charAt(suggestionLen - min) || input.charAt(inputLen - min) != suggestion.charAt(suggestionLen - min - 1)) || !verbosity.equals((Object)Verbosity.ALL) && this.deleteSuggestionPrefix(candidate, candidateLength, suggestion, suggestionLen) || !suggestionsAlreadyConsidered.add(suggestion) || (distance = this.damerauLevenshteinOSA.distance(input, suggestion, maxEditDistance2)) < 0 || distance > maxEditDistance2) continue;
                    long suggestionCount = this.lexiconWords.get(suggestion);
                    SuggestItem suggestItem = new SuggestItem(suggestion, distance, suggestionCount);
                    if (!suggestions.isEmpty()) {
                        switch (verbosity) {
                            case CLOSEST: {
                                if (distance >= maxEditDistance2) continue block5;
                                suggestions.clear();
                                break;
                            }
                            case TOP: {
                                if (distance >= maxEditDistance2 && !((double)suggestionCount > ((SuggestItem)suggestions.get(0)).getFrequencyOfSuggestionInDict())) continue block5;
                                maxEditDistance2 = distance;
                                suggestions.set(0, suggestItem);
                                continue block5;
                            }
                        }
                    }
                    if (!verbosity.equals((Object)Verbosity.ALL)) {
                        maxEditDistance2 = distance;
                    }
                    suggestions.add(suggestItem);
                }
            }
            if (lengthDiff >= maxEditDistance || candidateLength > this.prefixLength || !verbosity.equals((Object)Verbosity.ALL) && lengthDiff >= maxEditDistance2) continue;
            for (int i = 0; i < candidateLength; ++i) {
                StringBuilder editableString = new StringBuilder(candidate);
                String delete = editableString.deleteCharAt(i).toString();
                if (!deletesAlreadyConsidered.add(delete)) continue;
                candidates.add(delete);
            }
        }
        if (suggestions.size() > 1) {
            Collections.sort(suggestions);
        }
        if (includeUnknown && suggestions.isEmpty()) {
            SuggestItem noSuggestionsFound = new SuggestItem(input, maxEditDistance + 1, 0.0);
            suggestions.add(noSuggestionsFound);
        }
        return suggestions;
    }

    Map<Long, String[]> getDeletes() {
        return this.deletes;
    }

    public List<SuggestItem> lookupCompound(String input, int editDistanceMax) throws NotInitializedException {
        List<String> termList = Arrays.asList(input.split(" "));
        ArrayList<SuggestItem> suggestionParts = new ArrayList<SuggestItem>();
        DamerauLevenshteinOSA editDistance = new DamerauLevenshteinOSA();
        boolean lastCombination = false;
        for (int i = 0; i < termList.size(); ++i) {
            List<SuggestItem> suggestions = this.lookup(termList.get(i), Verbosity.TOP, editDistanceMax, false);
            if (i > 0 && !lastCombination && this.combineWords(editDistanceMax, termList, suggestions, suggestionParts, i)) {
                lastCombination = true;
                continue;
            }
            lastCombination = false;
            if (!(suggestions.isEmpty() || suggestions.get(0).getEditDistance() != 0 && termList.get(i).length() != 1)) {
                suggestionParts.add(suggestions.get(0));
                continue;
            }
            this.splitWords(editDistanceMax, termList, suggestions, suggestionParts, i);
        }
        double freq = 1.024908267229E12;
        StringBuilder stringBuilder = new StringBuilder();
        for (SuggestItem suggestItem : suggestionParts) {
            stringBuilder.append(suggestItem.getSuggestion()).append(" ");
            freq *= suggestItem.getFrequencyOfSuggestionInDict() / 1.024908267229E12;
        }
        String term = stringBuilder.toString().stripTrailing();
        SuggestItem suggestion = new SuggestItem(term, editDistance.distance(input, term, Integer.MAX_VALUE), freq);
        ArrayList<SuggestItem> suggestionsLine = new ArrayList<SuggestItem>();
        suggestionsLine.add(suggestion);
        return suggestionsLine;
    }

    private void splitWords(int editDistanceMax, List<String> termList, List<SuggestItem> suggestions, List<SuggestItem> suggestionParts, int i) throws NotInitializedException {
        String word;
        SuggestItem suggestionSplitBest = null;
        if (!suggestions.isEmpty()) {
            suggestionSplitBest = suggestions.get(0);
        }
        if ((word = termList.get(i)).length() > 1) {
            for (int j = 1; j < word.length(); ++j) {
                double freq;
                List<SuggestItem> suggestions2;
                String part1 = word.substring(0, j);
                String part2 = word.substring(j);
                List<SuggestItem> suggestions1 = this.lookup(part1, Verbosity.TOP, editDistanceMax, false);
                if (suggestions1.isEmpty() || (suggestions2 = this.lookup(part2, Verbosity.TOP, editDistanceMax, false)).isEmpty()) continue;
                String splitTerm = suggestions1.get(0).getSuggestion() + " " + suggestions2.get(0).getSuggestion();
                int splitDistance = this.damerauLevenshteinOSA.distance(word, splitTerm, editDistanceMax);
                if (splitDistance < 0) {
                    splitDistance = editDistanceMax + 1;
                }
                if (suggestionSplitBest != null) {
                    if (splitDistance > suggestionSplitBest.getEditDistance()) continue;
                    if (splitDistance < suggestionSplitBest.getEditDistance()) {
                        suggestionSplitBest = null;
                    }
                }
                if (this.lexiconBigrams.containsKey(splitTerm)) {
                    freq = this.lexiconBigrams.get(splitTerm).longValue();
                    if (!suggestions.isEmpty()) {
                        if ((suggestions1.get(0).getSuggestion() + suggestions2.get(0).getSuggestion()).equals(word)) {
                            freq = Math.max(freq, suggestions.get(0).getFrequencyOfSuggestionInDict() + 2.0);
                        } else if (suggestions1.get(0).getSuggestion().equals(suggestions.get(0).getSuggestion()) || suggestions2.get(0).getSuggestion().equals(suggestions.get(0).getSuggestion())) {
                            freq = Math.max(freq, suggestions.get(0).getFrequencyOfSuggestionInDict() + 1.0);
                        }
                    } else if ((suggestions1.get(0).getSuggestion() + suggestions2.get(0).getSuggestion()).equals(word)) {
                        freq = Math.max(freq, Math.max(suggestions1.get(0).getFrequencyOfSuggestionInDict(), suggestions2.get(0).getFrequencyOfSuggestionInDict()));
                    }
                } else {
                    freq = Math.min(this.bigramCountMin, (long)(suggestions1.get(0).getFrequencyOfSuggestionInDict() / 1.024908267229E12 * suggestions2.get(0).getFrequencyOfSuggestionInDict()));
                }
                SuggestItem suggestionSplit = new SuggestItem(splitTerm, splitDistance, freq);
                if (suggestionSplitBest != null && !(suggestionSplit.getFrequencyOfSuggestionInDict() > suggestionSplitBest.getFrequencyOfSuggestionInDict())) continue;
                suggestionSplitBest = suggestionSplit;
            }
            if (suggestionSplitBest != null) {
                suggestionParts.add(suggestionSplitBest);
            } else {
                SuggestItem suggestItem = new SuggestItem(word, editDistanceMax + 1, (long)(10.0 / Math.pow(10.0, word.length())));
                suggestionParts.add(suggestItem);
            }
        } else {
            SuggestItem suggestItem = new SuggestItem(word, editDistanceMax + 1, (long)(10.0 / Math.pow(10.0, word.length())));
            suggestionParts.add(suggestItem);
        }
    }

    private boolean combineWords(int editDistanceMax, List<String> termList, List<SuggestItem> suggestions, List<SuggestItem> suggestionParts, int i) throws NotInitializedException {
        List<SuggestItem> suggestionsCombination = this.lookup(termList.get(i - 1) + termList.get(i), Verbosity.TOP, editDistanceMax, false);
        if (!suggestionsCombination.isEmpty()) {
            SuggestItem best2;
            SuggestItem best1 = suggestionParts.get(suggestionParts.size() - 1);
            if (!suggestions.isEmpty()) {
                best2 = suggestions.get(0);
            } else {
                String term = termList.get(i);
                long estimatedWordOccurrenceProbability = (long)(10.0 / Math.pow(10.0, term.length()));
                best2 = new SuggestItem(term, editDistanceMax + 1, estimatedWordOccurrenceProbability);
            }
            int distance = best1.getEditDistance() + best2.getEditDistance();
            SuggestItem firstSuggestion = suggestionsCombination.get(0);
            if (distance >= 0 && firstSuggestion.getEditDistance() + 1 < distance || firstSuggestion.getEditDistance() + 1 == distance && firstSuggestion.getFrequencyOfSuggestionInDict() > best1.getFrequencyOfSuggestionInDict() / 1.024908267229E12 * best2.getFrequencyOfSuggestionInDict()) {
                suggestionsCombination.set(0, new SuggestItem(firstSuggestion.getSuggestion(), firstSuggestion.getEditDistance(), firstSuggestion.getFrequencyOfSuggestionInDict()));
                suggestionParts.set(suggestionParts.size() - 1, suggestionsCombination.get(0));
                return true;
            }
        }
        return false;
    }

    Map<String, Long> getWords() {
        return this.lexiconWords;
    }

    public static enum Verbosity {
        TOP,
        CLOSEST,
        ALL;

    }
}

