/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex.boxes;

import com.whitemagicsoftware.tex.boxes.Box;
import com.whitemagicsoftware.tex.boxes.StrutBox;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ListIterator;

public final class HorizontalBox
extends Box {
    public HorizontalBox() {
    }

    public HorizontalBox(Box b) {
        this.add(b);
    }

    public HorizontalBox(Box b, float w, int alignment) {
        float rest = w - b.getWidth();
        switch (alignment) {
            case 2: {
                StrutBox s = new StrutBox(rest / 2.0f);
                this.add(s);
                this.add(b);
                this.add(s);
                break;
            }
            case 0: {
                this.add(b);
                this.add(new StrutBox(rest));
                break;
            }
            case 1: {
                this.add(new StrutBox(rest));
                this.add(b);
            }
        }
    }

    public HorizontalBox(Color fg, Color bg) {
        super(fg, bg);
    }

    @Override
    public void draw(Graphics2D g, float x, float y) {
        this.startDraw(g, x, y);
        float xPos = x;
        for (Box box : this.children) {
            box.draw(g, xPos, y + box.getShift());
            xPos += box.getWidth();
        }
        this.endDraw(g);
    }

    @Override
    public final void add(Box b) {
        this.recalculate(b);
        super.add(b);
    }

    private void recalculate(Box b) {
        this.width += b.getWidth();
        this.height = Math.max(this.children.size() == 0 ? Float.NEGATIVE_INFINITY : this.height, b.height - b.shift);
        this.depth = Math.max(this.children.size() == 0 ? Float.NEGATIVE_INFINITY : this.depth, b.depth + b.shift);
    }

    @Override
    public int getLastFontId() {
        int fontId = -1;
        ListIterator it = this.children.listIterator(this.children.size());
        while (fontId == -1 && it.hasPrevious()) {
            fontId = ((Box)it.previous()).getLastFontId();
        }
        return fontId;
    }
}

