/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.CharacterUtils;

public class CharArrayMap<V>
extends AbstractMap<Object, V> {
    private static final CharArrayMap<?> EMPTY_MAP = new EmptyCharArrayMap();
    private boolean ignoreCase;
    private int count;
    char[][] keys;
    V[] values;
    private EntrySet entrySet = null;
    private CharArraySet keySet = null;

    /*
     * WARNING - void declaration
     */
    public CharArrayMap(int startSize, boolean ignoreCase) {
        void var2_2;
        this.ignoreCase = ignoreCase;
        int size = 8;
        while (true) {
            int n = startSize;
            if (n + (n >> 2) <= size) break;
            size <<= 1;
        }
        this.keys = new char[size][];
        this.values = new Object[var2_2];
    }

    /*
     * WARNING - void declaration
     */
    private CharArrayMap(Map<?, ? extends V> c, boolean ignoreCase) {
        this(c.size(), false);
        void var1_1;
        this.putAll(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private CharArrayMap(CharArrayMap<V> toCopy) {
        void var1_1;
        this.keys = toCopy.keys;
        this.values = toCopy.values;
        this.ignoreCase = toCopy.ignoreCase;
        this.count = var1_1.count;
    }

    @Override
    public void clear() {
        this.count = 0;
        Arrays.fill((Object[])this.keys, null);
        Arrays.fill(this.values, null);
    }

    /*
     * WARNING - void declaration
     */
    public boolean containsKey(char[] text, int off, int len) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.keys[this.getSlot((char[])var1_1, (int)var2_2, (int)var3_3)] != null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean containsKey(CharSequence cs) {
        void var1_1;
        return this.keys[this.getSlot((CharSequence)var1_1)] != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsKey(Object o) {
        void var1_1;
        if (o instanceof char[]) {
            char[] text = (char[])o;
            return this.containsKey(text, 0, ((void)var1_1).length);
        }
        return this.containsKey(var1_1.toString());
    }

    /*
     * WARNING - void declaration
     */
    public V get(char[] text, int off, int len) {
        void var3_3;
        void var1_1;
        return this.values[this.getSlot((char[])var1_1, 0, (int)var3_3)];
    }

    /*
     * WARNING - void declaration
     */
    public V get(CharSequence cs) {
        void var1_1;
        return this.values[this.getSlot((CharSequence)var1_1)];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V get(Object o) {
        void var1_1;
        if (o instanceof char[]) {
            char[] text = (char[])o;
            return this.get(text, 0, ((void)var1_1).length);
        }
        return this.get(var1_1.toString());
    }

    private int getSlot(char[] text, int off, int len) {
        int code = this.getHashCode(text, off, len);
        int pos = code & this.keys.length - 1;
        char[] text2 = this.keys[pos];
        if (text2 != null && !this.equals(text, off, len, text2)) {
            int inc = (code >> 8) + code | 1;
            while ((text2 = this.keys[pos = (code += inc) & this.keys.length - 1]) != null && !this.equals(text, off, len, text2)) {
            }
        }
        return pos;
    }

    /*
     * WARNING - void declaration
     */
    private int getSlot(CharSequence text) {
        void var3_3;
        int code = this.getHashCode(text);
        int pos = code & this.keys.length - 1;
        char[] text2 = this.keys[pos];
        if (text2 != null && !this.equals(text, text2)) {
            int inc = (code >> 8) + code | 1;
            while ((text2 = this.keys[pos = (code += inc) & this.keys.length - 1]) != null && !this.equals(text, text2)) {
            }
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V put(Object o, V value) {
        void var2_2;
        void var1_1;
        if (o instanceof char[]) {
            return this.put((char[])o, value);
        }
        return this.put(var1_1.toString(), (V)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V put(String text, V value) {
        void var2_2;
        void var1_1;
        return this.put(var1_1.toCharArray(), (V)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V put(char[] text, V value) {
        void var2_2;
        CharArrayMap charArrayMap;
        int slot;
        if (this.ignoreCase) {
            CharacterUtils.toLowerCase(text, 0, text.length);
        }
        if (this.keys[slot = this.getSlot(text, 0, text.length)] != null) {
            V oldValue = this.values[slot];
            this.values[slot] = value;
            return (V)charArrayMap;
        }
        this.keys[slot] = charArrayMap;
        this.values[var3_4] = var2_2;
        ++this.count;
        if (this.count + (this.count >> 2) > this.keys.length) {
            charArrayMap = this;
            assert (charArrayMap.keys.length == charArrayMap.values.length);
            int n = 2 * charArrayMap.keys.length;
            char[][] cArray = charArrayMap.keys;
            V[] VArray = charArrayMap.values;
            charArrayMap.keys = new char[n][];
            charArrayMap.values = new Object[n];
            for (n = 0; n < cArray.length; ++n) {
                char[] cArray2 = cArray[n];
                if (cArray2 == null) continue;
                int n2 = charArrayMap.getSlot(cArray2, 0, cArray2.length);
                charArrayMap.keys[n2] = cArray2;
                charArrayMap.values[n2] = VArray[n];
            }
        }
        return null;
    }

    private boolean equals(char[] text1, int off, int len, char[] text2) {
        if (len != text2.length) {
            return false;
        }
        int limit = off + len;
        if (this.ignoreCase) {
            int codePointAt;
            for (int i = 0; i < len; i += Character.charCount(codePointAt)) {
                codePointAt = Character.codePointAt(text1, off + i, limit);
                if (Character.toLowerCase(codePointAt) == Character.codePointAt(text2, i, text2.length)) continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (text1[off + i] == text2[i]) continue;
                return false;
            }
        }
        return true;
    }

    private boolean equals(CharSequence text1, char[] text2) {
        int len = text1.length();
        if (len != text2.length) {
            return false;
        }
        if (this.ignoreCase) {
            int codePointAt;
            for (int i = 0; i < len; i += Character.charCount(codePointAt)) {
                codePointAt = Character.codePointAt(text1, i);
                if (Character.toLowerCase(codePointAt) == Character.codePointAt(text2, i, text2.length)) continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (text1.charAt(i) == text2[i]) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private int getHashCode(char[] text, int offset, int len) {
        void i;
        if (text == null) {
            throw new NullPointerException();
        }
        int code = 0;
        int stop = offset + len;
        if (this.ignoreCase) {
            while (i < stop) {
                int codePointAt = Character.codePointAt(text, (int)i, stop);
                code = code * 31 + Character.toLowerCase(codePointAt);
                i += Character.charCount(codePointAt);
            }
        } else {
            while (i < stop) {
                code = code * 31 + text[i];
                ++i;
            }
        }
        return code;
    }

    /*
     * WARNING - void declaration
     */
    private int getHashCode(CharSequence text) {
        void var2_2;
        if (text == null) {
            throw new NullPointerException();
        }
        int code = 0;
        int len = text.length();
        if (this.ignoreCase) {
            int codePointAt;
            for (int i = 0; i < len; i += Character.charCount(codePointAt)) {
                codePointAt = Character.codePointAt(text, i);
                code = code * 31 + Character.toLowerCase(codePointAt);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                code = code * 31 + text.charAt(i);
            }
        }
        return (int)var2_2;
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.count;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder("{");
        for (Map.Entry entry : this.entrySet()) {
            void var3_3;
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append(var3_3);
        }
        return var1_1.append('}').toString();
    }

    EntrySet createEntrySet() {
        return new EntrySet(this, true, 0);
    }

    public final EntrySet entrySet() {
        if (this.entrySet == null) {
            this.entrySet = this.createEntrySet();
        }
        return this.entrySet;
    }

    final Set<Object> originalKeySet() {
        return super.keySet();
    }

    public final CharArraySet keySet() {
        if (this.keySet == null) {
            CharArrayMap charArrayMap = this;
            this.keySet = new CharArraySet(charArrayMap, charArrayMap){
                {
                    void var2_2;
                }

                @Override
                public final boolean add(Object o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public final boolean add(String text) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return this.keySet;
    }

    public static <V> CharArrayMap<V> unmodifiableMap(CharArrayMap<V> map) {
        CharArrayMap<V> charArrayMap;
        if (map == null) {
            throw new NullPointerException("Given map is null");
        }
        if (map == EMPTY_MAP || map.isEmpty()) {
            return EMPTY_MAP;
        }
        if (map instanceof UnmodifiableCharArrayMap) {
            return map;
        }
        return new UnmodifiableCharArrayMap<V>(charArrayMap);
    }

    /*
     * WARNING - void declaration
     */
    public static <V> CharArrayMap<V> copy(Map<?, ? extends V> map) {
        CharArrayMap<V> charArrayMap;
        if (map == EMPTY_MAP) {
            return EMPTY_MAP;
        }
        if (map instanceof CharArrayMap) {
            void var2_2;
            void var1_1;
            CharArrayMap<V> m = (CharArrayMap<V>)map;
            char[][] keys = new char[m.keys.length][];
            System.arraycopy(m.keys, 0, keys, 0, keys.length);
            Object[] values = new Object[m.values.length];
            System.arraycopy(m.values, 0, values, 0, values.length);
            m = new CharArrayMap<V>(m);
            v0.keys = var1_1;
            m.values = var2_2;
            return charArrayMap;
        }
        return new CharArrayMap<V>(charArrayMap, false);
    }

    public static <V> CharArrayMap<V> emptyMap() {
        return EMPTY_MAP;
    }

    /*
     * WARNING - void declaration
     */
    /* synthetic */ CharArrayMap(CharArrayMap x0, byte by) {
        this((CharArrayMap<V>)var1_1);
        void var1_1;
    }

    static final class EmptyCharArrayMap<V>
    extends UnmodifiableCharArrayMap<V> {
        EmptyCharArrayMap() {
            super(new CharArrayMap(0, false));
        }

        @Override
        public final boolean containsKey(char[] text, int off, int len) {
            if (text == null) {
                throw new NullPointerException();
            }
            return false;
        }

        @Override
        public final boolean containsKey(CharSequence cs) {
            if (cs == null) {
                throw new NullPointerException();
            }
            return false;
        }

        @Override
        public final boolean containsKey(Object o) {
            if (o == null) {
                throw new NullPointerException();
            }
            return false;
        }

        @Override
        public final V get(char[] text, int off, int len) {
            if (text == null) {
                throw new NullPointerException();
            }
            return null;
        }

        @Override
        public final V get(CharSequence cs) {
            if (cs == null) {
                throw new NullPointerException();
            }
            return null;
        }

        @Override
        public final V get(Object o) {
            if (o == null) {
                throw new NullPointerException();
            }
            return null;
        }
    }

    static class UnmodifiableCharArrayMap<V>
    extends CharArrayMap<V> {
        /*
         * WARNING - void declaration
         */
        UnmodifiableCharArrayMap(CharArrayMap<V> map) {
            super((CharArrayMap)var1_1, (byte)0);
            void var1_1;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public V put(Object o, V val) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final V put(char[] text, V val) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final V put(String text, V val) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        final EntrySet createEntrySet() {
            return new EntrySet(this, false, 0);
        }
    }

    public final class EntrySet
    extends AbstractSet<Map.Entry<Object, V>> {
        private final boolean allowModify;
        private /* synthetic */ CharArrayMap this$0;

        /*
         * WARNING - void declaration
         */
        private EntrySet(CharArrayMap this$0, boolean allowModify) {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.allowModify = var2_2;
        }

        public final EntryIterator iterator() {
            return new EntryIterator(this.this$0, this.allowModify, 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object o) {
            void var1_1;
            void var2_2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            Object val = e.getValue();
            Object v = this.this$0.get(key);
            if (v == null) {
                return val == null;
            }
            return var2_2.equals(var1_1);
        }

        @Override
        public final boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final int size() {
            return this.this$0.count;
        }

        @Override
        public final void clear() {
            if (!this.allowModify) {
                throw new UnsupportedOperationException();
            }
            this.this$0.clear();
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ EntrySet(CharArrayMap x0, boolean x1, byte by) {
            this((CharArrayMap)var1_1, (boolean)var2_2);
            void var2_2;
            void var1_1;
        }
    }

    final class MapEntry
    implements Map.Entry<Object, V> {
        private final int pos;
        private final boolean allowModify;
        private /* synthetic */ CharArrayMap this$0;

        /*
         * WARNING - void declaration
         */
        private MapEntry(CharArrayMap charArrayMap, int pos, boolean allowModify) {
            void var3_3;
            void var2_2;
            this.this$0 = charArrayMap;
            this.pos = var2_2;
            this.allowModify = var3_3;
        }

        @Override
        public final Object getKey() {
            return this.this$0.keys[this.pos].clone();
        }

        @Override
        public final V getValue() {
            return this.this$0.values[this.pos];
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V setValue(V value) {
            void var2_2;
            void var1_1;
            if (!this.allowModify) {
                throw new UnsupportedOperationException();
            }
            Object old = this.this$0.values[this.pos];
            this.this$0.values[this.pos] = var1_1;
            return var2_2;
        }

        public final String toString() {
            return this.this$0.keys[this.pos] + '=' + (this.this$0.values[this.pos] == this.this$0 ? "(this Map)" : this.this$0.values[this.pos]);
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ MapEntry(CharArrayMap x0, int x1, boolean x2, byte by) {
            this((CharArrayMap)var1_1, (int)var2_2, (boolean)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }
    }

    public final class EntryIterator
    implements Iterator<Map.Entry<Object, V>> {
        private int pos = -1;
        private int lastPos;
        private final boolean allowModify;
        private /* synthetic */ CharArrayMap this$0;

        /*
         * WARNING - void declaration
         */
        private EntryIterator(CharArrayMap this$0, boolean allowModify) {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.allowModify = var2_2;
            this.goNext();
        }

        private void goNext() {
            this.lastPos = this.pos++;
            while (this.pos < this.this$0.keys.length && this.this$0.keys[this.pos] == null) {
                ++this.pos;
            }
        }

        @Override
        public final boolean hasNext() {
            return this.pos < this.this$0.keys.length;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ EntryIterator(CharArrayMap x0, boolean x1, byte by) {
            this((CharArrayMap)var1_1, (boolean)var2_2);
            void var2_2;
            void var1_1;
        }
    }
}

