/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cn.smart.hhmm;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.lucene.analysis.cn.smart.AnalyzerProfile;
import org.apache.lucene.analysis.cn.smart.hhmm.AbstractDictionary;

final class BigramDictionary
extends AbstractDictionary {
    private static BigramDictionary singleInstance;
    private long[] bigramHashTable;
    private int[] frequencyTable;
    private int max = 0;
    private int repeat = 0;

    private BigramDictionary() {
    }

    /*
     * WARNING - void declaration
     */
    public static synchronized BigramDictionary getInstance() {
        if (singleInstance == null) {
            singleInstance = new BigramDictionary();
            try {
                BigramDictionary bigramDictionary = singleInstance;
                InputStream inputStream = bigramDictionary.getClass().getResourceAsStream("bigramdict.mem");
                bigramDictionary.loadFromInputStream(inputStream);
            }
            catch (IOException iOException) {
                Object dictRoot = AnalyzerProfile.ANALYSIS_DATA_DIR;
                try {
                    Object object = dictRoot;
                    dictRoot = singleInstance;
                    String string = (String)object + "/bigramdict.dct";
                    object = Paths.get((String)object + "/bigramdict.mem", new String[0]);
                    if (Files.exists((Path)object, new LinkOption[0])) {
                        super.loadFromObj((Path)object);
                    }
                    try {
                        ((BigramDictionary)dictRoot).bigramHashTable = new long[402137];
                        ((BigramDictionary)dictRoot).frequencyTable = new int[402137];
                        for (int i = 0; i < 402137; ++i) {
                            ((BigramDictionary)dictRoot).bigramHashTable[i] = 0L;
                            ((BigramDictionary)dictRoot).frequencyTable[i] = 0;
                        }
                        ((BigramDictionary)dictRoot).loadFromFile(string);
                    }
                    catch (IOException iOException2) {
                        throw new RuntimeException(iOException2.getMessage());
                    }
                    super.saveToObj((Path)object);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
            catch (ClassNotFoundException e) {
                void var0_3;
                throw new RuntimeException((Throwable)var0_3);
            }
        }
        return singleInstance;
    }

    /*
     * WARNING - void declaration
     */
    private boolean loadFromObj(Path serialObj) {
        try {
            this.loadFromInputStream(Files.newInputStream(serialObj, new OpenOption[0]));
            return true;
        }
        catch (Exception e) {
            void var1_2;
            throw new RuntimeException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void loadFromInputStream(InputStream serialObjectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream input2 = new ObjectInputStream(serialObjectInputStream);
        Throwable throwable = null;
        try {
            this.bigramHashTable = (long[])input2.readObject();
            this.frequencyTable = (int[])input2.readObject();
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (throwable != null) {
                    try {
                        input2.close();
                    }
                    catch (Throwable input2) {
                        throwable.addSuppressed(input2);
                    }
                } else {
                    void var1_1;
                    var1_1.close();
                }
                throw throwable4;
            }
        }
        input2.close();
        return;
    }

    /*
     * WARNING - void declaration
     */
    private void saveToObj(Path serialObj) throws IOException {
        ObjectOutputStream output2 = new ObjectOutputStream(Files.newOutputStream(serialObj, new OpenOption[0]));
        Throwable throwable = null;
        try {
            output2.writeObject(this.bigramHashTable);
            output2.writeObject(this.frequencyTable);
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (throwable != null) {
                    try {
                        output2.close();
                    }
                    catch (Throwable output2) {
                        throwable.addSuppressed(output2);
                    }
                } else {
                    void var1_1;
                    var1_1.close();
                }
                throw throwable4;
            }
        }
        output2.close();
        return;
    }

    /*
     * WARNING - void declaration
     */
    private void loadFromFile(String dctFilePath) throws IOException {
        int[] buffer = new int[3];
        byte[] intBuffer = new byte[4];
        DataInputStream dctFile = new DataInputStream(Files.newInputStream(Paths.get(dctFilePath, new String[0]), new OpenOption[0]));
        for (int i = 1410; i < 8178; ++i) {
            String currentStr = BigramDictionary.getCCByGB2312Id(i);
            dctFile.read(intBuffer);
            int cnt = ByteBuffer.wrap(intBuffer).order(ByteOrder.LITTLE_ENDIAN).getInt();
            if (cnt <= 0) continue;
            for (int j = 0; j < cnt; ++j) {
                void var3_7;
                char[] carray;
                long hashId;
                int index;
                dctFile.read(intBuffer);
                buffer[0] = ByteBuffer.wrap(intBuffer).order(ByteOrder.LITTLE_ENDIAN).getInt();
                dctFile.read(intBuffer);
                buffer[1] = ByteBuffer.wrap(intBuffer).order(ByteOrder.LITTLE_ENDIAN).getInt();
                dctFile.read(intBuffer);
                int length = buffer[1];
                if (length <= 0) continue;
                byte[] lchBuffer = new byte[length];
                dctFile.read(lchBuffer);
                String tmpword = new String(lchBuffer, "GB2312");
                if (i != 5165) {
                    tmpword = currentStr + tmpword;
                }
                if ((index = this.getAvaliableIndex(hashId = BigramDictionary.hash1(carray = tmpword.toCharArray()), carray)) == -1) continue;
                if (this.bigramHashTable[index] == 0L) {
                    this.bigramHashTable[index] = hashId;
                }
                void v0 = var3_7;
                this.frequencyTable[v0] = this.frequencyTable[v0] + buffer[0];
            }
        }
        dctFile.close();
    }

    /*
     * WARNING - void declaration
     */
    private int getAvaliableIndex(long hashId, char[] carray) {
        void var1_1;
        int i;
        int hash1 = (int)(hashId % 402137L);
        int hash2 = BigramDictionary.hash2(carray) % 402137;
        if (hash1 < 0) {
            hash1 += 402137;
        }
        if (hash2 < 0) {
            hash2 += 402137;
        }
        int index = hash1;
        for (i = 1; this.bigramHashTable[index] != 0L && this.bigramHashTable[index] != hashId && i < 402137; ++i) {
            index = (hash1 + i * hash2) % 402137;
        }
        if (i < 402137 && (this.bigramHashTable[index] == 0L || this.bigramHashTable[index] == var1_1)) {
            return index;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public final int getFrequency(char[] carray) {
        char[] cArray = carray;
        carray = this;
        long l = BigramDictionary.hash1(cArray);
        int n = (int)(l % 402137L);
        int n2 = BigramDictionary.hash2(cArray) % 402137;
        if (n < 0) {
            n += 402137;
        }
        if (n2 < 0) {
            n2 += 402137;
        }
        int n3 = n;
        int n4 = 1;
        ++carray.repeat;
        while (carray.bigramHashTable[n3] != 0L && carray.bigramHashTable[n3] != l && n4 < 402137) {
            n3 = (n + n4 * n2) % 402137;
            ++carray.repeat;
            if (++n4 <= carray.max) continue;
            carray.max = n4;
        }
        int index = n4 < 402137 && carray.bigramHashTable[n3] == l ? n3 : -1;
        if (index != -1) {
            void var1_2;
            return this.frequencyTable[var1_2];
        }
        return 0;
    }
}

