/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.nio.charset.StandardCharsets;

public abstract class DataInput
implements Cloneable {
    private byte[] skipBuffer;

    public abstract byte readByte() throws IOException;

    public abstract void readBytes(byte[] var1, int var2, int var3) throws IOException;

    public final int readInt() throws IOException {
        return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
    }

    /*
     * WARNING - void declaration
     */
    public final int readVInt() throws IOException {
        void var1_1;
        byte b = this.readByte();
        if (b >= 0) {
            return b;
        }
        int i = b & 0x7F;
        b = this.readByte();
        i |= (b & 0x7F) << 7;
        if (b >= 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0x7F) << 14;
        if (b >= 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0x7F) << 21;
        if (b >= 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0xF) << 28;
        if ((var1_1 & 0xF0) == 0) {
            void var2_2;
            return (int)var2_2;
        }
        throw new IOException("Invalid vInt detected (too many bits)");
    }

    public final long readVLong() throws IOException {
        boolean bl = false;
        DataInput dataInput = this;
        byte by = dataInput.readByte();
        if (by >= 0) {
            return by;
        }
        long l = (long)by & 0x7FL;
        by = dataInput.readByte();
        l |= ((long)by & 0x7FL) << 7;
        if (by >= 0) {
            return l;
        }
        by = dataInput.readByte();
        l |= ((long)by & 0x7FL) << 14;
        if (by >= 0) {
            return l;
        }
        by = dataInput.readByte();
        l |= ((long)by & 0x7FL) << 21;
        if (by >= 0) {
            return l;
        }
        by = dataInput.readByte();
        l |= ((long)by & 0x7FL) << 28;
        if (by >= 0) {
            return l;
        }
        by = dataInput.readByte();
        l |= ((long)by & 0x7FL) << 35;
        if (by >= 0) {
            return l;
        }
        by = dataInput.readByte();
        l |= ((long)by & 0x7FL) << 42;
        if (by >= 0) {
            return l;
        }
        by = dataInput.readByte();
        l |= ((long)by & 0x7FL) << 49;
        if (by >= 0) {
            return l;
        }
        by = dataInput.readByte();
        l |= ((long)by & 0x7FL) << 56;
        if (by >= 0) {
            return l;
        }
        throw new IOException("Invalid vLong detected (negative values disallowed)");
    }

    /*
     * WARNING - void declaration
     */
    public final String readString() throws IOException {
        void var1_1;
        void var2_2;
        int length = this.readVInt();
        byte[] bytes = new byte[length];
        this.readBytes(bytes, 0, length);
        return new String((byte[])var2_2, 0, (int)var1_1, StandardCharsets.UTF_8);
    }

    private DataInput clone() {
        try {
            return (DataInput)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("This cannot happen: Failing to clone DataInput");
        }
    }

    public void skipBytes(long numBytes) throws IOException {
        int step;
        if (numBytes < 0L) {
            throw new IllegalArgumentException("numBytes must be >= 0, got " + numBytes);
        }
        if (this.skipBuffer == null) {
            this.skipBuffer = new byte[1024];
        }
        assert (this.skipBuffer.length == 1024);
        for (long skipped = 0L; skipped < numBytes; skipped += (long)step) {
            DataInput dataInput;
            int n = step = (int)Math.min(1024L, numBytes - skipped);
            boolean bl = false;
            byte[] byArray = this.skipBuffer;
            dataInput.readBytes(byArray, 0, n);
        }
    }
}

