/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2.input.sax;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Attribute;
import org.jdom2.AttributeType;
import org.jdom2.CDATA;
import org.jdom2.Comment;
import org.jdom2.Content;
import org.jdom2.ContentList;
import org.jdom2.DocType;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.EntityRef;
import org.jdom2.JDOMFactory;
import org.jdom2.Namespace;
import org.jdom2.Parent;
import org.jdom2.ProcessingInstruction;
import org.jdom2.Text;
import org.jdom2.input.sax.TextBuffer;
import org.xml.sax.Attributes;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Attributes2;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class SAXHandler
extends DefaultHandler
implements DTDHandler,
DeclHandler,
LexicalHandler {
    private final JDOMFactory factory;
    private final List<Namespace> declaredNamespaces = new ArrayList<Namespace>(32);
    private final StringBuilder internalSubset = new StringBuilder();
    private final TextBuffer textBuffer = new TextBuffer();
    private final Map<String, String[]> externalEntities = new HashMap<String, String[]>();
    private Document currentDocument = null;
    private Element currentElement = null;
    private Locator currentLocator = null;
    private boolean atRoot = true;
    private boolean inDTD = false;
    private boolean inInternalSubset = false;
    private boolean previousCDATA = false;
    private boolean inCDATA = false;
    private boolean expand = true;
    private boolean suppress = false;
    private int entityDepth = 0;
    private boolean ignoringWhite = false;
    private boolean ignoringBoundaryWhite = false;
    private int lastline = 0;
    private int lastcol = 0;

    /*
     * WARNING - void declaration
     */
    public SAXHandler(JDOMFactory factory) {
        void var1_1;
        this.factory = factory != null ? var1_1 : new ContentList.1();
        this.reset();
    }

    public final void reset() {
        this.currentLocator = null;
        this.currentDocument = this.factory.document(null);
        this.currentElement = null;
        this.atRoot = true;
        this.inDTD = false;
        this.inInternalSubset = false;
        this.previousCDATA = false;
        this.inCDATA = false;
        this.expand = true;
        this.suppress = false;
        this.entityDepth = 0;
        this.declaredNamespaces.clear();
        this.internalSubset.setLength(0);
        this.textBuffer.clear();
        this.externalEntities.clear();
        this.ignoringWhite = false;
        this.ignoringBoundaryWhite = false;
    }

    public final Document getDocument() {
        return this.currentDocument;
    }

    /*
     * WARNING - void declaration
     */
    public final void setExpandEntities(boolean expand) {
        void var1_1;
        this.expand = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setIgnoringElementContentWhitespace(boolean ignoringWhite) {
        void var1_1;
        this.ignoringWhite = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setIgnoringBoundaryWhitespace(boolean ignoringBoundaryWhite) {
        void var1_1;
        this.ignoringBoundaryWhite = var1_1;
    }

    public void startDocument() {
        if (this.currentLocator != null) {
            this.currentLocator.getSystemId();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void externalEntityDecl(String name, String publicID, String systemID) throws SAXException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.externalEntities.put(name, new String[]{publicID, systemID});
        if (!this.inInternalSubset) {
            return;
        }
        this.internalSubset.append("  <!ENTITY ").append((String)var1_1);
        this.appendExternalId((String)var2_2, (String)var3_3);
        this.internalSubset.append(">\n");
    }

    /*
     * WARNING - void declaration
     */
    public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (!this.inInternalSubset) {
            return;
        }
        this.internalSubset.append("  <!ATTLIST ").append((String)var1_1).append(' ').append((String)var2_2).append(' ').append((String)var3_3).append(' ');
        if (valueDefault != null) {
            this.internalSubset.append(valueDefault);
        } else {
            this.internalSubset.append('\"').append(value).append('\"');
        }
        if (valueDefault != null && valueDefault.equals("#FIXED")) {
            this.internalSubset.append(" \"").append(value).append('\"');
        }
        this.internalSubset.append(">\n");
    }

    /*
     * WARNING - void declaration
     */
    public void elementDecl(String name, String model) {
        void var2_2;
        void var1_1;
        if (!this.inInternalSubset) {
            return;
        }
        this.internalSubset.append("  <!ELEMENT ").append((String)var1_1).append(' ').append((String)var2_2).append(">\n");
    }

    /*
     * WARNING - void declaration
     */
    public void internalEntityDecl(String name, String value) {
        void var2_2;
        if (!this.inInternalSubset) {
            return;
        }
        this.internalSubset.append("  <!ENTITY ");
        if (name.startsWith("%")) {
            this.internalSubset.append("% ").append(name.substring(1));
        } else {
            void var1_1;
            this.internalSubset.append((String)var1_1);
        }
        this.internalSubset.append(" \"").append((String)var2_2).append("\">\n");
    }

    /*
     * WARNING - void declaration
     */
    public void processingInstruction(String target, String data) throws SAXException {
        void var1_1;
        ProcessingInstruction pi;
        ProcessingInstruction processingInstruction;
        if (this.suppress) {
            return;
        }
        this.flushCharacters();
        if (this.currentLocator == null) {
            processingInstruction = this.factory.processingInstruction(target, data);
        } else {
            void var2_2;
            this.currentLocator.getLineNumber();
            this.currentLocator.getColumnNumber();
            processingInstruction = pi = this.factory.processingInstruction$1fdad441(target, (String)var2_2);
        }
        if (this.atRoot) {
            this.factory.addContent(this.currentDocument, pi);
            return;
        }
        this.factory.addContent(this.getCurrentElement(), (Content)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void skippedEntity(String name) throws SAXException {
        void var1_1;
        EntityRef entityRef;
        if (name.startsWith("%")) {
            return;
        }
        this.flushCharacters();
        if (this.currentLocator == null) {
            entityRef = this.factory.entityRef(name);
        } else {
            this.currentLocator.getLineNumber();
            this.currentLocator.getColumnNumber();
            entityRef = this.factory.entityRef$40b91060(name);
        }
        EntityRef er = entityRef;
        this.factory.addContent(this.getCurrentElement(), (Content)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        void var1_1;
        void var2_2;
        if (this.suppress) {
            return;
        }
        Namespace ns = Namespace.getNamespace(prefix, (String)var2_2);
        this.declaredNamespaces.add((Namespace)var1_1);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        Element element;
        Element element2;
        if (this.suppress) {
            return;
        }
        Object prefix = "";
        if (!"".equals(qName)) {
            int colon = ((String)qName).indexOf(58);
            if (colon > 0) {
                prefix = ((String)qName).substring(0, colon);
            }
            if (localName == null || ((String)localName).equals("")) {
                localName = ((String)qName).substring(colon + 1);
            }
        }
        Namespace namespace2 = Namespace.getNamespace((String)prefix, namespaceURI);
        if (this.currentLocator == null) {
            element2 = this.factory.element((String)localName, namespace2);
        } else {
            this.currentLocator.getLineNumber();
            this.currentLocator.getColumnNumber();
            element2 = element = this.factory.element$33a6c944((String)localName, namespace2);
        }
        if (this.declaredNamespaces.size() > 0) {
            qName = element;
            localName = this;
            for (Namespace namespace2 : ((SAXHandler)localName).declaredNamespaces) {
                if (namespace2 == ((Element)qName).getNamespace()) continue;
                ((Element)qName).addNamespaceDeclaration(namespace2);
            }
            ((SAXHandler)localName).declaredNamespaces.clear();
        }
        this.flushCharacters();
        if (this.atRoot) {
            this.factory.setRoot(this.currentDocument, element);
            this.atRoot = false;
        } else {
            this.factory.addContent(this.getCurrentElement(), element);
        }
        this.currentElement = element;
        int len = atts.getLength();
        for (int i = 0; i < len; ++i) {
            String string;
            String attPrefix = "";
            String attLocalName = atts.getLocalName(i);
            String attQName = atts.getQName(i);
            if (atts instanceof Attributes2) {
                ((Attributes2)atts).isSpecified(i);
            }
            if (!attQName.equals("")) {
                if (attQName.startsWith("xmlns:") || attQName.equals("xmlns")) continue;
                int attColon = attQName.indexOf(58);
                if (attColon > 0) {
                    attPrefix = attQName.substring(0, attColon);
                }
                if ("".equals(attLocalName)) {
                    attLocalName = attQName.substring(attColon + 1);
                }
            }
            AttributeType attType = AttributeType.getAttributeType(atts.getType(i));
            String attValue = atts.getValue(i);
            String attURI = atts.getURI(i);
            if ("xmlns".equals(attLocalName) || "xmlns".equals(attPrefix) || "http://www.w3.org/2000/xmlns/".equals(attURI)) continue;
            if (!"".equals(attURI) && "".equals(attPrefix)) {
                HashMap<String, Namespace> tmpmap = new HashMap<String, Namespace>();
                for (Namespace nss : element.getNamespacesInScope()) {
                    if (nss.getPrefix().length() > 0 && nss.getURI().equals(attURI)) {
                        attPrefix = nss.getPrefix();
                        break;
                    }
                    tmpmap.put(nss.getPrefix(), nss);
                }
                if ("".equals(attPrefix)) {
                    int cnt = 0;
                    String pfx = "attns" + 0;
                    while (tmpmap.containsKey(pfx)) {
                        pfx = "attns" + ++cnt;
                    }
                    string = pfx;
                }
            }
            Namespace attNs = Namespace.getNamespace(string, attURI);
            Attribute attribute = this.factory.attribute(attLocalName, attValue, attType, attNs);
            this.factory.setAttribute(element, attribute);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void characters(char[] ch, int start, int length) throws SAXException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.suppress || length == 0 && !this.inCDATA) {
            return;
        }
        if (this.previousCDATA != this.inCDATA) {
            this.flushCharacters();
        }
        this.textBuffer.append((char[])var1_1, (int)var2_2, (int)var3_3);
        if (this.currentLocator != null) {
            this.lastline = this.currentLocator.getLineNumber();
            this.lastcol = this.currentLocator.getColumnNumber();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (!this.ignoringWhite) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.characters((char[])var1_1, (int)var2_2, (int)var3_3);
        }
    }

    private void flushCharacters() throws SAXException {
        if (!this.ignoringBoundaryWhite || !this.textBuffer.isAllWhitespace()) {
            SAXHandler sAXHandler = this;
            sAXHandler.flushCharacters(sAXHandler.textBuffer.toString());
        }
        this.textBuffer.clear();
    }

    /*
     * WARNING - void declaration
     */
    private void flushCharacters(String data) throws SAXException {
        CDATA cdata;
        if (data.length() == 0 && !this.inCDATA) {
            this.previousCDATA = this.inCDATA;
            return;
        }
        if (this.previousCDATA) {
            cdata = this.currentLocator == null ? this.factory.cdata(data) : this.factory.cdata$53ca8ce3(data);
            this.factory.addContent(this.getCurrentElement(), cdata);
        } else {
            void var1_1;
            Text text = this.currentLocator == null ? this.factory.text((String)((Object)cdata)) : this.factory.text$57235f87((String)((Object)cdata));
            this.factory.addContent(this.getCurrentElement(), (Content)var1_1);
        }
        this.previousCDATA = this.inCDATA;
    }

    /*
     * WARNING - void declaration
     */
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.suppress) {
            return;
        }
        this.flushCharacters();
        if (!this.atRoot) {
            Parent p = this.currentElement.getParent();
            if (!(p instanceof Document)) {
                void var1_1;
                this.currentElement = (Element)var1_1;
                return;
            }
        } else {
            void var2_2;
            throw new SAXException("Ill-formed XML document (missing opening tag for " + (String)var2_2 + ")");
        }
        this.atRoot = true;
    }

    /*
     * WARNING - void declaration
     */
    public void startDTD(String name, String publicID, String systemID) throws SAXException {
        void var1_1;
        DocType docType;
        this.flushCharacters();
        if (this.currentLocator == null) {
            docType = this.factory.docType(name, publicID, systemID);
        } else {
            void var3_3;
            void var2_2;
            this.currentLocator.getLineNumber();
            this.currentLocator.getColumnNumber();
            docType = this.factory.docType$10015d2e(name, (String)var2_2, (String)var3_3);
        }
        DocType doctype = docType;
        this.factory.addContent(this.currentDocument, (Content)var1_1);
        this.inDTD = true;
        this.inInternalSubset = true;
    }

    public void endDTD() {
        this.currentDocument.getDocType().setInternalSubset(this.internalSubset.toString());
        this.inDTD = false;
        this.inInternalSubset = false;
    }

    /*
     * WARNING - void declaration
     */
    public void startEntity(String name) throws SAXException {
        ++this.entityDepth;
        if (this.expand || this.entityDepth > 1) {
            return;
        }
        if (name.equals("[dtd]")) {
            this.inInternalSubset = false;
            return;
        }
        if (!(this.inDTD || name.equals("amp") || name.equals("lt") || name.equals("gt") || name.equals("apos") || name.equals("quot") || this.expand)) {
            String pub = null;
            String sys = null;
            String[] ids = this.externalEntities.get(name);
            if (ids != null) {
                pub = ids[0];
                sys = ids[1];
            }
            if (!this.atRoot) {
                void var1_1;
                EntityRef entityRef;
                this.flushCharacters();
                if (this.currentLocator == null) {
                    entityRef = this.factory.entityRef(name, pub, sys);
                } else {
                    void var3_3;
                    void var2_2;
                    this.currentLocator.getLineNumber();
                    this.currentLocator.getColumnNumber();
                    entityRef = this.factory.entityRef$7fabaf34(name, (String)var2_2, (String)var3_3);
                }
                EntityRef entity = entityRef;
                this.factory.addContent(this.getCurrentElement(), (Content)var1_1);
            }
            this.suppress = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void endEntity(String name) throws SAXException {
        void var1_1;
        --this.entityDepth;
        if (this.entityDepth == 0) {
            this.suppress = false;
        }
        if (var1_1.equals("[dtd]")) {
            this.inInternalSubset = true;
        }
    }

    public void startCDATA() {
        if (this.suppress) {
            return;
        }
        this.inCDATA = true;
    }

    public void endCDATA() throws SAXException {
        if (this.suppress) {
            return;
        }
        this.previousCDATA = true;
        this.flushCharacters();
        this.previousCDATA = false;
        this.inCDATA = false;
    }

    /*
     * WARNING - void declaration
     */
    public void comment(char[] ch, int start, int length) throws SAXException {
        void var3_3;
        void var2_2;
        if (this.suppress) {
            return;
        }
        this.flushCharacters();
        String commentText = new String(ch, (int)var2_2, (int)var3_3);
        if (this.inDTD && this.inInternalSubset && !this.expand) {
            this.internalSubset.append("  <!--").append(commentText).append("-->\n");
            return;
        }
        if (!this.inDTD && !commentText.equals("")) {
            void var1_1;
            Comment comment;
            Comment comment2;
            if (this.currentLocator == null) {
                comment2 = this.factory.comment(commentText);
            } else {
                this.currentLocator.getLineNumber();
                this.currentLocator.getColumnNumber();
                comment2 = comment = this.factory.comment$457279ef(commentText);
            }
            if (this.atRoot) {
                this.factory.addContent(this.currentDocument, comment);
                return;
            }
            this.factory.addContent(this.getCurrentElement(), (Content)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void notationDecl(String name, String publicID, String systemID) throws SAXException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (!this.inInternalSubset) {
            return;
        }
        this.internalSubset.append("  <!NOTATION ").append((String)var1_1);
        this.appendExternalId((String)var2_2, (String)var3_3);
        this.internalSubset.append(">\n");
    }

    /*
     * WARNING - void declaration
     */
    public void unparsedEntityDecl(String name, String publicID, String systemID, String notationName) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (!this.inInternalSubset) {
            return;
        }
        this.internalSubset.append("  <!ENTITY ").append((String)var1_1);
        this.appendExternalId((String)var2_2, (String)var3_3);
        this.internalSubset.append(" NDATA ").append(notationName);
        this.internalSubset.append(">\n");
    }

    /*
     * WARNING - void declaration
     */
    private void appendExternalId(String publicID, String systemID) {
        if (publicID != null) {
            this.internalSubset.append(" PUBLIC \"").append(publicID).append('\"');
        }
        if (systemID != null) {
            void var2_2;
            void var1_1;
            if (var1_1 == null) {
                this.internalSubset.append(" SYSTEM ");
            } else {
                this.internalSubset.append(' ');
            }
            this.internalSubset.append('\"').append((String)var2_2).append('\"');
        }
    }

    private Element getCurrentElement() throws SAXException {
        if (this.currentElement == null) {
            throw new SAXException("Ill-formed XML document (multiple root elements detected)");
        }
        return this.currentElement;
    }

    /*
     * WARNING - void declaration
     */
    public void setDocumentLocator(Locator locator) {
        void var1_1;
        this.currentLocator = var1_1;
    }
}

