/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.ReusableStringReader;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.util.CloseableThreadLocal;
import org.apache.lucene.util.IOUtils;

public abstract class Analyzer
implements Closeable {
    private final ReuseStrategy reuseStrategy;
    CloseableThreadLocal<Object> storedValue = new CloseableThreadLocal();
    private static ReuseStrategy GLOBAL_REUSE_STRATEGY = new ReuseStrategy(){

        @Override
        public final TokenStreamComponents getReusableComponents(Analyzer analyzer, String fieldName) {
            return (TokenStreamComponents)1.getStoredValue(analyzer);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setReusableComponents(Analyzer analyzer, String fieldName, TokenStreamComponents components) {
            void var3_3;
            1.setStoredValue(analyzer, var3_3);
        }
    };

    public Analyzer() {
        this(GLOBAL_REUSE_STRATEGY);
    }

    /*
     * WARNING - void declaration
     */
    private Analyzer(ReuseStrategy reuseStrategy) {
        void var1_1;
        this.reuseStrategy = var1_1;
    }

    protected abstract TokenStreamComponents createComponents$2e873add();

    /*
     * WARNING - void declaration
     */
    public final TokenStream tokenStream(String fieldName, String text) {
        void var1_1;
        void var3_3;
        void var2_2;
        TokenStreamComponents components = this.reuseStrategy.getReusableComponents(this, null);
        ReusableStringReader strReader = components == null || components.reusableStringReader == null ? new ReusableStringReader() : components.reusableStringReader;
        strReader.setValue(text);
        ReusableStringReader r = strReader;
        if (components == null) {
            components = this.createComponents$2e873add();
            this.reuseStrategy.setReusableComponents(this, null, components);
        }
        TokenStreamComponents.access$000(components, (Reader)var2_2);
        components.reusableStringReader = var3_3;
        return var1_1.getTokenStream();
    }

    @Override
    public void close() {
        if (this.storedValue != null) {
            this.storedValue.close();
            this.storedValue = null;
        }
    }

    static {
        new ReuseStrategy(){

            /*
             * WARNING - void declaration
             */
            @Override
            public final TokenStreamComponents getReusableComponents(Analyzer analyzer, String fieldName) {
                Map componentsPerField = (Map)2.getStoredValue(analyzer);
                if (componentsPerField != null) {
                    void var2_2;
                    void var1_1;
                    return (TokenStreamComponents)var1_1.get(var2_2);
                }
                return null;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void setReusableComponents(Analyzer analyzer, String fieldName, TokenStreamComponents components) {
                void var3_3;
                void var2_2;
                HashMap<void, void> componentsPerField = (HashMap<void, void>)2.getStoredValue(analyzer);
                if (componentsPerField == null) {
                    void var1_1;
                    componentsPerField = new HashMap<void, void>();
                    2.setStoredValue((Analyzer)var1_1, componentsPerField);
                }
                componentsPerField.put(var2_2, var3_3);
            }
        };
    }

    public static abstract class ReuseStrategy {
        public abstract TokenStreamComponents getReusableComponents(Analyzer var1, String var2);

        public abstract void setReusableComponents(Analyzer var1, String var2, TokenStreamComponents var3);

        protected static Object getStoredValue(Analyzer analyzer) {
            Analyzer analyzer2;
            if (analyzer.storedValue == null) {
                throw new AlreadyClosedException("this Analyzer is closed");
            }
            return analyzer2.storedValue.get();
        }

        /*
         * WARNING - void declaration
         */
        protected static void setStoredValue(Analyzer analyzer, Object storedValue) {
            void var1_1;
            Analyzer analyzer2;
            if (analyzer.storedValue == null) {
                throw new AlreadyClosedException("this Analyzer is closed");
            }
            analyzer2.storedValue.set(var1_1);
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class TokenStreamComponents {
        private Consumer<Reader> source;
        private TokenStream sink;
        transient ReusableStringReader reusableStringReader;

        /*
         * WARNING - void declaration
         */
        public TokenStreamComponents(Consumer<Reader> source, TokenStream result) {
            void var2_2;
            void var1_1;
            this.source = var1_1;
            this.sink = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public TokenStreamComponents(Tokenizer tokenizer, TokenStream result) {
            this(((Tokenizer)var1_1)::setReader, (TokenStream)var2_2);
            void var2_2;
            void var1_1;
        }

        public final TokenStream getTokenStream() {
            return this.sink;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$000(TokenStreamComponents x0, Reader x1) {
            void var1_1;
            TokenStreamComponents tokenStreamComponents = x0;
            tokenStreamComponents.source.accept((Reader)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public static CharArraySet getWordSet(Reader reader, String comment, CharArraySet result) throws IOException {
            void var2_3;
            BufferedReader br = null;
            try {
                Object word;
                BufferedReader bufferedReader = br = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
                while ((word = br.readLine()) != null) {
                    Object object;
                    if (((String)word).startsWith(comment)) continue;
                    result.add(((String)object).trim());
                }
            }
            catch (Throwable throwable) {
                void var3_4;
                IOUtils.close(new Closeable[]{var3_4});
                throw throwable;
            }
            IOUtils.close(br);
            return var2_3;
        }

        public static int zigZagDecode(int i) {
            int n;
            return i >>> 1 ^ -(n & 1);
        }

        /*
         * WARNING - void declaration
         */
        private static void checkFromToIndex(int fromIndex, int toIndex, int length) {
            if (fromIndex > toIndex) {
                throw new IllegalArgumentException("fromIndex " + fromIndex + " > toIndex " + toIndex);
            }
            if (fromIndex < 0 || toIndex > length) {
                void var2_2;
                void var1_1;
                int n;
                throw new IndexOutOfBoundsException("Range [" + n + ", " + (int)var1_1 + ") out-of-bounds for length " + (int)var2_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        public static int compareUnsigned(byte[] a, int aFromIndex, int aToIndex, byte[] b, int bFromIndex, int bToIndex) {
            void var2_2;
            TokenStreamComponents.checkFromToIndex(aFromIndex, aToIndex, a.length);
            TokenStreamComponents.checkFromToIndex(bFromIndex, bToIndex, b.length);
            int aLen = aToIndex - aFromIndex;
            int bLen = bToIndex - bFromIndex;
            int len = Math.min(aLen, bLen);
            for (int i = 0; i < len; ++i) {
                int aByte = a[i + aFromIndex] & 0xFF;
                int bByte = b[i + bFromIndex] & 0xFF;
                int diff = aByte - bByte;
                if (diff == 0) continue;
                return diff;
            }
            return (int)(var2_2 - bLen);
        }

        public static boolean equals(byte[] a, int aFromIndex, int aToIndex, byte[] b, int bFromIndex, int bToIndex) {
            TokenStreamComponents.checkFromToIndex(aFromIndex, aToIndex, a.length);
            TokenStreamComponents.checkFromToIndex(bFromIndex, bToIndex, b.length);
            int aLen = aToIndex - aFromIndex;
            int bLen = bToIndex - bFromIndex;
            if (aLen != bLen) {
                return false;
            }
            for (int i = 0; i < aLen; ++i) {
                if (a[i + aFromIndex] == b[i + bFromIndex]) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public static int compare(int[] a, int aFromIndex, int aToIndex, int[] b, int bFromIndex, int bToIndex) {
            void var2_2;
            TokenStreamComponents.checkFromToIndex(aFromIndex, aToIndex, a.length);
            TokenStreamComponents.checkFromToIndex(bFromIndex, bToIndex, b.length);
            int aLen = aToIndex - aFromIndex;
            int bLen = bToIndex - bFromIndex;
            int len = Math.min(aLen, bLen);
            for (int i = 0; i < len; ++i) {
                int aInt = a[i + aFromIndex];
                int bInt = b[i + bFromIndex];
                if (aInt > bInt) {
                    return 1;
                }
                if (aInt >= bInt) continue;
                return -1;
            }
            return (int)(var2_2 - bLen);
        }

        public static boolean equals(int[] a, int aFromIndex, int aToIndex, int[] b, int bFromIndex, int bToIndex) {
            TokenStreamComponents.checkFromToIndex(aFromIndex, aToIndex, a.length);
            TokenStreamComponents.checkFromToIndex(bFromIndex, bToIndex, b.length);
            int aLen = aToIndex - aFromIndex;
            int bLen = bToIndex - bFromIndex;
            if (aLen != bLen) {
                return false;
            }
            for (int i = 0; i < aLen; ++i) {
                if (a[i + aFromIndex] == b[i + bFromIndex]) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public static int checkFromToIndex(int fromIndex, int toIndex, int length) {
            int n;
            if (fromIndex < 0 || fromIndex > toIndex || toIndex > length) {
                void var2_2;
                void var1_1;
                throw new IndexOutOfBoundsException("Range [" + fromIndex + ", " + (int)var1_1 + ") out-of-bounds for length " + (int)var2_2);
            }
            return n;
        }
    }
}

