/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.en;

import java.util.Arrays;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.en.EnglishPossessiveFilter;
import org.apache.lucene.analysis.en.PorterStemFilter;
import org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;

public final class EnglishAnalyzer
extends StopwordAnalyzerBase {
    private static CharArraySet ENGLISH_STOP_WORDS_SET;
    private final CharArraySet stemExclusionSet;

    public EnglishAnalyzer() {
        this(ENGLISH_STOP_WORDS_SET);
    }

    /*
     * WARNING - void declaration
     */
    private EnglishAnalyzer(CharArraySet stopwords) {
        this((CharArraySet)var1_1, CharArraySet.EMPTY_SET);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private EnglishAnalyzer(CharArraySet stopwords, CharArraySet stemExclusionSet) {
        super((CharArraySet)var1_1);
        void var2_2;
        void var1_1;
        this.stemExclusionSet = CharArraySet.unmodifiableSet(CharArraySet.copy(var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final Analyzer.TokenStreamComponents createComponents$2e873add() {
        void var2_2;
        void var1_1;
        StandardTokenizer source = new StandardTokenizer();
        TokenFilter result = new EnglishPossessiveFilter(source);
        result = new LowerCaseFilter(result);
        result = new StopFilter(result, this.stopwords);
        if (!this.stemExclusionSet.isEmpty()) {
            result = new SetKeywordMarkerFilter(result, this.stemExclusionSet);
        }
        result = new PorterStemFilter(result);
        return new Analyzer.TokenStreamComponents((Tokenizer)var1_1, (TokenStream)var2_2);
    }

    static {
        CharArraySet charArraySet;
        List<String> stopWords = Arrays.asList("a", "an", "and", "are", "as", "at", "be", "but", "by", "for", "if", "in", "into", "is", "it", "no", "not", "of", "on", "or", "such", "that", "the", "their", "then", "there", "these", "they", "this", "to", "was", "will", "with");
        charArraySet = new CharArraySet(charArraySet, false);
        ENGLISH_STOP_WORDS_SET = CharArraySet.unmodifiableSet(charArraySet);
    }
}

