/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public final class IOUtils {
    private IOUtils() {
    }

    public static void close(Closeable ... objects) throws IOException {
        Object object = Arrays.asList(objects);
        Throwable throwable = null;
        object = object.iterator();
        while (object.hasNext()) {
            Closeable closeable = (Closeable)object.next();
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (Throwable throwable2) {
                throwable = IOUtils.useOrSuppress(throwable, throwable2);
            }
        }
        if (throwable != null) {
            object = throwable;
            if (object == null) {
                throw new AssertionError((Object)"rethrow argument must not be null.");
            }
            if (object instanceof IOException) {
                throw (IOException)object;
            }
            if (object instanceof RuntimeException) {
                throw (RuntimeException)object;
            }
            if (object instanceof Error) {
                throw (Error)object;
            }
            throw new RuntimeException((Throwable)object);
        }
    }

    public static void closeWhileHandlingException(Closeable ... objects) {
        Object object = Arrays.asList(objects);
        Throwable throwable = null;
        Throwable throwable2 = null;
        object = object.iterator();
        while (object.hasNext()) {
            Closeable closeable = (Closeable)object.next();
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (VirtualMachineError virtualMachineError) {
                throwable = IOUtils.useOrSuppress(throwable, virtualMachineError);
            }
            catch (Throwable throwable3) {
                throwable2 = IOUtils.useOrSuppress(throwable2, throwable3);
            }
        }
        if (throwable != null) {
            if (throwable2 != null) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Reader getDecodingReader(InputStream stream, Charset charSet) {
        void var1_1;
        InputStream inputStream;
        CharsetDecoder charSetDecoder = charSet.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        return new BufferedReader(new InputStreamReader(inputStream, (CharsetDecoder)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static Reader getDecodingReader(Class<?> clazz, String resource, Charset charSet) throws IOException {
        InputStream stream = null;
        boolean success = false;
        try {
            Reader reader;
            void var2_3;
            void var1_2;
            stream = clazz.getResourceAsStream((String)var1_2);
            Reader reader2 = IOUtils.getDecodingReader(stream, (Charset)var2_3);
            success = true;
            return reader;
        }
        catch (Throwable throwable) {
            if (!success) {
                void var3_4;
                IOUtils.close(new Closeable[]{var3_4});
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static <T extends Throwable> T useOrSuppress(T first, T second) {
        T t;
        void var1_1;
        if (first == null) {
            return second;
        }
        first.addSuppressed((Throwable)var1_1);
        return t;
    }

    static {
        IOUtils.class.desiredAssertionStatus();
        StandardCharsets.UTF_8.name();
    }
}

