/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.rxp90.jsymspell;

import io.gitlab.rxp90.jsymspell.SymSpellImpl;
import io.gitlab.rxp90.jsymspell.api.Bigram;
import io.gitlab.rxp90.jsymspell.api.DamerauLevenshteinOSA;
import io.gitlab.rxp90.jsymspell.api.StringDistance;
import io.gitlab.rxp90.jsymspell.exceptions.NotInitializedException;
import java.util.HashMap;
import java.util.Map;

public class SymSpellBuilder {
    private int maxDictionaryEditDistance = 2;
    private int prefixLength = 7;
    private StringDistance stringDistanceAlgorithm = new DamerauLevenshteinOSA();
    private final Map<String, Long> unigramLexicon = new HashMap<String, Long>();
    private final Map<Bigram, Long> bigramLexicon = new HashMap<Bigram, Long>();

    public SymSpellBuilder setMaxDictionaryEditDistance(int maxDictionaryEditDistance) {
        this.maxDictionaryEditDistance = maxDictionaryEditDistance;
        return this;
    }

    public SymSpellBuilder setPrefixLength(int prefixLength) {
        this.prefixLength = prefixLength;
        return this;
    }

    public SymSpellBuilder setUnigramLexicon(Map<String, Long> unigramLexicon) {
        assert (unigramLexicon != null);
        assert (!unigramLexicon.isEmpty());
        this.unigramLexicon.putAll(unigramLexicon);
        return this;
    }

    public SymSpellBuilder setBigramLexicon(Map<Bigram, Long> bigramLexicon) {
        assert (bigramLexicon != null);
        assert (!bigramLexicon.isEmpty());
        this.bigramLexicon.putAll(bigramLexicon);
        return this;
    }

    public SymSpellBuilder setStringDistanceAlgorithm(StringDistance distanceAlgorithm) {
        assert (distanceAlgorithm != null);
        this.stringDistanceAlgorithm = distanceAlgorithm;
        return this;
    }

    public int getMaxDictionaryEditDistance() {
        return this.maxDictionaryEditDistance;
    }

    public int getPrefixLength() {
        return this.prefixLength;
    }

    public Map<String, Long> getUnigramLexicon() {
        return this.unigramLexicon;
    }

    public Map<Bigram, Long> getBigramLexicon() {
        return this.bigramLexicon;
    }

    public StringDistance getStringDistanceAlgorithm() {
        return this.stringDistanceAlgorithm;
    }

    public SymSpellImpl createSymSpell() throws NotInitializedException {
        if (this.unigramLexicon.isEmpty()) {
            throw new NotInitializedException("Missing unigram lexicon");
        }
        return new SymSpellImpl(this);
    }

    public SymSpellImpl build() throws NotInitializedException {
        return this.createSymSpell();
    }
}

