/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex;

import com.whitemagicsoftware.tex.DefaultTeXFont;
import com.whitemagicsoftware.tex.TeXEnvironment;
import com.whitemagicsoftware.tex.TeXIcon;
import com.whitemagicsoftware.tex.atoms.AccentedAtom;
import com.whitemagicsoftware.tex.atoms.Atom;
import com.whitemagicsoftware.tex.atoms.BigOperatorAtom;
import com.whitemagicsoftware.tex.atoms.CharAtom;
import com.whitemagicsoftware.tex.atoms.ColorAtom;
import com.whitemagicsoftware.tex.atoms.FencedAtom;
import com.whitemagicsoftware.tex.atoms.FractionAtom;
import com.whitemagicsoftware.tex.atoms.NthRootAtom;
import com.whitemagicsoftware.tex.atoms.OverUnderDelimiterAtom;
import com.whitemagicsoftware.tex.atoms.OverlinedAtom;
import com.whitemagicsoftware.tex.atoms.PhantomAtom;
import com.whitemagicsoftware.tex.atoms.RowAtom;
import com.whitemagicsoftware.tex.atoms.ScriptsAtom;
import com.whitemagicsoftware.tex.atoms.SpaceAtom;
import com.whitemagicsoftware.tex.atoms.SymbolAtom;
import com.whitemagicsoftware.tex.atoms.TypedAtom;
import com.whitemagicsoftware.tex.atoms.UnderOverAtom;
import com.whitemagicsoftware.tex.atoms.UnderlinedAtom;
import com.whitemagicsoftware.tex.atoms.VCenteredAtom;
import com.whitemagicsoftware.tex.boxes.Box;
import com.whitemagicsoftware.tex.boxes.StrutBox;
import com.whitemagicsoftware.tex.exceptions.DelimiterMappingNotFoundException;
import com.whitemagicsoftware.tex.exceptions.EmptyFormulaException;
import com.whitemagicsoftware.tex.exceptions.FormulaNotFoundException;
import com.whitemagicsoftware.tex.exceptions.InvalidAtomTypeException;
import com.whitemagicsoftware.tex.exceptions.InvalidDelimiterException;
import com.whitemagicsoftware.tex.exceptions.InvalidDelimiterTypeException;
import com.whitemagicsoftware.tex.exceptions.InvalidSymbolTypeException;
import com.whitemagicsoftware.tex.exceptions.InvalidTeXFormulaException;
import com.whitemagicsoftware.tex.exceptions.InvalidUnitException;
import com.whitemagicsoftware.tex.exceptions.ParseException;
import com.whitemagicsoftware.tex.exceptions.SymbolNotFoundException;
import com.whitemagicsoftware.tex.parsers.PredefinedTeXFormulaParser;
import com.whitemagicsoftware.tex.parsers.TeXFormulaSettingsParser;
import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TeXFormula {
    private static final Set<String> commands;
    private static final Set<String> textStyles;
    private static final String[][] delimiterNames;
    public static float FONT_SCALE_FACTOR;
    public static float PIXELS_PER_POINT;
    public static final float PREC = 1.0E-7f;
    private static final Map<String, TeXFormula> predefinedTeXFormulas;
    private static final String[] symbolMappings;
    private static final String[] delimiterMappings;
    private String texString;
    private int texStringLen;
    private int pos;
    private Atom root;
    private String textStyle;

    public TeXFormula() {
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula(List<TeXFormula> l) {
        if (l != null) {
            if (l.size() == 1) {
                this.addImpl(l.get(0));
                return;
            }
            try {
                void var1_1;
                this.root = new RowAtom((List<TeXFormula>)var1_1);
                return;
            }
            catch (EmptyFormulaException emptyFormulaException) {
                this.root = null;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula(String s) throws ParseException {
        this((String)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private TeXFormula(String s, String textStyle) throws ParseException {
        void var1_1;
        void var2_2;
        assert (s != null);
        this.textStyle = var2_2;
        this.parse((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula(TeXFormula f) {
        void var1_1;
        assert (f != null);
        this.addImpl((TeXFormula)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private TeXFormula add(Atom el) {
        if (el != null) {
            if (this.root == null) {
                this.root = el;
            } else {
                void var1_1;
                if (!(this.root instanceof RowAtom)) {
                    this.root = new RowAtom(this.root);
                }
                ((RowAtom)this.root).add((Atom)var1_1);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula add(String s) throws ParseException {
        if (s != null && !s.isEmpty()) {
            void var1_1;
            this.textStyle = null;
            this.pos = 0;
            this.parse((String)var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula add(TeXFormula f) {
        void var1_1;
        this.addImpl((TeXFormula)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private void addImpl(TeXFormula f) {
        if (f.root != null) {
            void var1_1;
            this.add(f.root instanceof RowAtom ? new RowAtom(f.root) : var1_1.root);
        }
    }

    public TeXFormula centerOnAxis() {
        this.root = new VCenteredAtom(this.root);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula addAcc(String s, String accentName) throws InvalidSymbolTypeException, SymbolNotFoundException, ParseException {
        void var2_2;
        void var1_1;
        return this.addAcc(new TeXFormula((String)var1_1), (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula addAcc(TeXFormula base, String accentName) throws InvalidSymbolTypeException, SymbolNotFoundException {
        void var2_2;
        void var1_1;
        return this.add(new AccentedAtom(base == null ? null : var1_1.root, (String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula addAcc(TeXFormula base, TeXFormula accent) throws InvalidSymbolTypeException, InvalidTeXFormulaException {
        void var2_2;
        void var1_1;
        return this.add(new AccentedAtom(base == null ? null : var1_1.root, (TeXFormula)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula addEmbraced(String s, char l, char r) throws SymbolNotFoundException, InvalidDelimiterException, ParseException, DelimiterMappingNotFoundException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.addEmbraced(new TeXFormula((String)var1_1), (char)var2_2, (char)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula addEmbraced(String s, String left, String right) throws SymbolNotFoundException, ParseException, InvalidDelimiterException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.addEmbraced(new TeXFormula((String)var1_1), (String)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula addEmbraced(TeXFormula f, char l, char r) throws SymbolNotFoundException, InvalidDelimiterException, DelimiterMappingNotFoundException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.addEmbraced((TeXFormula)var1_1, TeXFormula.getCharacterToDelimiterMapping((char)var2_2), TeXFormula.getCharacterToDelimiterMapping((char)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula addEmbraced(TeXFormula f, String left, String right) throws SymbolNotFoundException, InvalidDelimiterException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.add(new FencedAtom(f == null ? null : var1_1.root, TeXFormula.getDelimiterSymbol((String)var2_2), TeXFormula.getDelimiterSymbol((String)var3_3)));
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula addFraction(String num, String denom, boolean rule) throws ParseException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.addFraction(new TeXFormula((String)var1_1), new TeXFormula((String)var2_2), (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula addFraction(String num, String denom, boolean rule, int numAlign, int denomAlign) throws ParseException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.addFraction(new TeXFormula((String)var1_1), new TeXFormula((String)var2_2), (boolean)var3_3, numAlign, denomAlign);
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula addFraction(String num, TeXFormula denom, boolean rule) throws ParseException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.addFraction(new TeXFormula((String)var1_1), (TeXFormula)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula addFraction(TeXFormula num, String denom, boolean rule) throws ParseException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.addFraction((TeXFormula)var1_1, new TeXFormula((String)var2_2), (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula addFraction(TeXFormula num, TeXFormula denom, boolean rule) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.add(new FractionAtom(num == null ? null : var1_1.root, denom == null ? null : var2_2.root, (boolean)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula addFraction(TeXFormula num, TeXFormula denom, boolean rule, int numAlign, int denomAlign) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.add(new FractionAtom(num == null ? null : var1_1.root, denom == null ? null : var2_2.root, (boolean)var3_3, numAlign, denomAlign));
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula addNthRoot(String base, String nthRoot) throws ParseException {
        void var2_2;
        void var1_1;
        return this.addNthRoot(new TeXFormula((String)var1_1), new TeXFormula((String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula addNthRoot(String base, TeXFormula nthRoot) throws ParseException {
        void var2_2;
        void var1_1;
        return this.addNthRoot(new TeXFormula((String)var1_1), (TeXFormula)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula addNthRoot(TeXFormula base, String nthRoot) throws ParseException {
        void var2_2;
        void var1_1;
        return this.addNthRoot((TeXFormula)var1_1, new TeXFormula((String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula addNthRoot(TeXFormula base, TeXFormula nthRoot) {
        void var2_2;
        void var1_1;
        return this.add(new NthRootAtom(base == null ? null : var1_1.root, nthRoot == null ? null : var2_2.root));
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula addOp(String op, String low, String up) throws ParseException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.addOp(new TeXFormula((String)var1_1), new TeXFormula((String)var2_2), new TeXFormula((String)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula addOp(String op, String low, String up, boolean lim) throws ParseException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.addOp(new TeXFormula((String)var1_1), new TeXFormula((String)var2_2), new TeXFormula((String)var3_3), lim);
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula addOp(TeXFormula op, TeXFormula low, TeXFormula up) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.add(new BigOperatorAtom(op == null ? null : var1_1.root, low == null ? null : var2_2.root, up == null ? null : var3_3.root));
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula addOp(TeXFormula op, TeXFormula low, TeXFormula up, boolean lim) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.add(new BigOperatorAtom(op == null ? null : var1_1.root, low == null ? null : var2_2.root, up == null ? null : var3_3.root, lim));
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula addPhantom(String phantom) throws ParseException {
        void var1_1;
        return this.addPhantom(new TeXFormula((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula addPhantom(String phantom, boolean width, boolean height, boolean depth) throws ParseException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.addPhantom(new TeXFormula((String)var1_1), (boolean)var2_2, (boolean)var3_3, depth);
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula addPhantom(TeXFormula phantom) {
        void var1_1;
        return this.add(new PhantomAtom(phantom == null ? null : var1_1.root));
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula addPhantom(TeXFormula phantom, boolean width, boolean height, boolean depth) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.add(new PhantomAtom(phantom == null ? null : var1_1.root, (boolean)var2_2, (boolean)var3_3, depth));
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula addSqrt(String base) throws ParseException {
        void var1_1;
        return this.addSqrt(new TeXFormula((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula addSqrt(TeXFormula base) {
        void var1_1;
        return this.addNthRoot((TeXFormula)var1_1, (TeXFormula)null);
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula addStrut(int unit, float width, float height, float depth) throws InvalidUnitException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.add(new SpaceAtom((int)var1_1, (float)var2_2, (float)var3_3, depth));
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula addStrut(int widthUnit, float width, int heightUnit, float height, int depthUnit, float depth) throws InvalidUnitException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.add(new SpaceAtom((int)var1_1, (float)var2_2, (int)var3_3, height, depthUnit, depth));
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula addSymbol(String name) throws SymbolNotFoundException {
        void var1_1;
        return this.add(SymbolAtom.get((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula addSymbol(String name, int type) throws SymbolNotFoundException, InvalidSymbolTypeException {
        void var2_2;
        void var1_1;
        return this.add(new SymbolAtom(SymbolAtom.get((String)var1_1), (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    private Atom attachScripts(Atom atom) throws ParseException {
        void var1_1;
        this.skipWhitespace();
        if (this.pos < this.texStringLen) {
            StringBuilder stringBuilder;
            char ch22 = this.texString.charAt(this.pos);
            if (ch22 == '\'') {
                int n;
                TeXFormula ch22 = this;
                stringBuilder = new StringBuilder();
                stringBuilder.append('^');
                stringBuilder.append('{');
                stringBuilder.append("\\prime");
                for (n = ch22.pos + 1; n < ch22.texStringLen; ++n) {
                    if (ch22.texString.charAt(n) == '\'') {
                        stringBuilder.append("\\prime");
                        continue;
                    }
                    if (!Character.isWhitespace(ch22.texString.charAt(n))) break;
                }
                stringBuilder.append('}');
                ch22.texString = ch22.texString.substring(0, ch22.pos) + stringBuilder.toString() + ch22.texString.substring(n);
                ch22.texStringLen = ch22.texString.length();
                ch22 = this.texString.charAt(this.pos);
            }
            if (ch22 == '^' || ch22 == '_') {
                ++this.pos;
                if (ch22 == '^') {
                    TeXFormula sup = this.getScript();
                    TeXFormula sub = new TeXFormula();
                    this.skipWhitespace();
                    if (this.pos < this.texStringLen && this.texString.charAt(this.pos) == '_') {
                        ++this.pos;
                        sub = this.getScript();
                    }
                    f = f.getRightType() == 1 ? new BigOperatorAtom(f, sub.root, sup.root) : new ScriptsAtom(f, sub.root, sup.root);
                } else {
                    void var2_5;
                    TeXFormula sub = this.getScript();
                    TeXFormula sup = new TeXFormula();
                    this.skipWhitespace();
                    if (this.pos < this.texStringLen && this.texString.charAt(this.pos) == '^') {
                        ++this.pos;
                        sup = this.getScript();
                    }
                    f = f.getRightType() == 1 ? new BigOperatorAtom(f, sub.root, sup.root) : new ScriptsAtom(f, var2_5.root, ((TeXFormula)((Object)stringBuilder)).root);
                }
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Atom convertCharacter(char c) throws ParseException {
        void var1_1;
        ++this.pos;
        char c2 = c;
        if (!(c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z')) {
            void var2_5;
            if (c < symbolMappings.length) {
                String symbolName = symbolMappings[c];
                if (symbolName == null) {
                    String m = String.format("Unknown character: '%s'", Character.valueOf(c));
                    throw new ParseException(m);
                }
                try {
                    return SymbolAtom.get(symbolName);
                }
                catch (SymbolNotFoundException e) {
                    void var3_7;
                    void var1_2;
                    String m = String.format("The character '%c' was mapped to unknown symbol name '%s'", Character.valueOf(c), symbolName);
                    throw new ParseException((String)var1_2, (Throwable)var3_7);
                }
            }
            String m = String.format("Unknown symbol: '%s'", Character.valueOf((char)var1_1));
            throw new ParseException((String)var2_5);
        }
        return new CharAtom((char)var1_1, this.textStyle);
    }

    /*
     * WARNING - void declaration
     */
    public Box createBox(TeXEnvironment style) {
        void var1_1;
        if (this.root == null) {
            return new StrutBox();
        }
        return this.root.createBox((TeXEnvironment)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public TeXIcon createTeXIcon(int style, float size) {
        void var2_2;
        void var1_1;
        return new TeXIcon(this.createBox(new TeXEnvironment((int)var1_1, new DefaultTeXFont(size))), (float)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula embrace(char left, char right) throws SymbolNotFoundException, InvalidDelimiterException, DelimiterMappingNotFoundException {
        void var2_2;
        void var1_1;
        return this.embrace(TeXFormula.getCharacterToDelimiterMapping((char)var1_1), TeXFormula.getCharacterToDelimiterMapping((char)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula embrace(String left, String right) throws SymbolNotFoundException, InvalidDelimiterException {
        void var2_2;
        void var1_1;
        this.root = new FencedAtom(this.root, TeXFormula.getDelimiterSymbol((String)var1_1), TeXFormula.getDelimiterSymbol((String)var2_2));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula fraction(String s, boolean rule) throws ParseException {
        void var2_2;
        void var1_1;
        return this.fraction(new TeXFormula((String)var1_1), (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula fraction(String s, boolean rule, int numAlign, int denomAlign) throws ParseException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.fraction(new TeXFormula((String)var1_1), (boolean)var2_2, (int)var3_3, denomAlign);
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula fraction(TeXFormula f, boolean rule) {
        void var2_2;
        void var1_1;
        this.root = new FractionAtom(this.root, f == null ? null : var1_1.root, (boolean)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula fraction(TeXFormula f, int unit, float thickness) throws InvalidUnitException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.root = new FractionAtom(this.root, f == null ? null : var1_1.root, (int)var2_2, (float)var3_3);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula fraction(TeXFormula f, int unit, float thickness, int numAlign, int denomAlign) throws InvalidUnitException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.root = new FractionAtom(this.root, f == null ? null : var1_1.root, (int)var2_2, (float)var3_3, numAlign, denomAlign);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula fraction(TeXFormula f, float defaultFactor, int numAlign, int denomAlign) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.root = new FractionAtom(this.root, f == null ? null : var1_1.root, (float)var2_2, (int)var3_3, denomAlign);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula fraction(TeXFormula f, boolean rule, int numAlign, int denomAlign) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.root = new FractionAtom(this.root, f == null ? null : var1_1.root, (boolean)var2_2, (int)var3_3, denomAlign);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula fractionInvert(String s, boolean rule) throws ParseException {
        void var2_2;
        void var1_1;
        return this.fractionInvert(new TeXFormula((String)var1_1), (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula fractionInvert(String s, boolean rule, int numAlign, int denomAlign) throws ParseException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.fractionInvert(new TeXFormula((String)var1_1), (boolean)var2_2, (int)var3_3, denomAlign);
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula fractionInvert(TeXFormula f, boolean rule) {
        void var2_2;
        void var1_1;
        this.root = new FractionAtom(f == null ? null : var1_1.root, this.root, (boolean)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula fractionInvert(TeXFormula f, boolean rule, int numAlign, int denomAlign) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.root = new FractionAtom(f == null ? null : var1_1.root, this.root, (boolean)var2_2, (int)var3_3, denomAlign);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private String getGroup(char open, char close) throws ParseException {
        int group = 0;
        if (this.pos < this.texStringLen) {
            void var1_1;
            char c = this.texString.charAt(this.pos);
            if (c == open) {
                char ch;
                StringBuilder buf = new StringBuilder();
                ++this.pos;
                while (this.pos < this.texStringLen && ((ch = this.texString.charAt(this.pos)) != close || group != 0)) {
                    if (ch == open) {
                        ++group;
                    } else if (ch == close) {
                        --group;
                    }
                    buf.append(ch);
                    ++this.pos;
                }
                if (this.pos == this.texStringLen) {
                    void var2_2;
                    throw new ParseException("Illegal end, missing '" + (char)var2_2 + "'");
                }
                ++this.pos;
                return buf.toString();
            }
            throw new ParseException("Missing '" + (char)var1_1 + "'");
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    private TeXFormula getScript() throws ParseException {
        this.skipWhitespace();
        if (this.pos < this.texStringLen) {
            void var1_1;
            char ch = this.texString.charAt(this.pos);
            if (ch == '{') {
                return new TeXFormula(this.getGroup('{', '}'));
            }
            ++this.pos;
            return new TeXFormula(Character.toString((char)var1_1));
        }
        throw new ParseException("illegal end, missing script!");
    }

    public TeXFormula makePhantom() {
        this.root = new PhantomAtom(this.root);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula makePhantom(boolean width, boolean height, boolean depth) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.root = new PhantomAtom(this.root, (boolean)var1_1, (boolean)var2_2, (boolean)var3_3);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula nthRoot(String nthRoot) throws ParseException {
        void var1_1;
        return this.nthRoot(new TeXFormula((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula nthRoot(TeXFormula nthRoot) {
        void var1_1;
        this.root = new NthRootAtom(this.root, nthRoot == null ? null : var1_1.root);
        return this;
    }

    public TeXFormula overline() {
        this.root = new OverlinedAtom(this.root);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private void parse(String s) throws ParseException {
        this.texString = s;
        this.texStringLen = s.length();
        Atom atom = null;
        while (this.pos < this.texStringLen) {
            void var2_2;
            void formula2;
            char ch = this.texString.charAt(this.pos);
            if (Character.isWhitespace(ch)) {
                ++this.pos;
                continue;
            }
            if (ch == '\\') {
                atom = this.processEscape();
                if (atom.isType(10)) continue;
                TeXFormula teXFormula = this;
                teXFormula.add(teXFormula.attachScripts(atom));
                continue;
            }
            if (ch == '{') {
                TeXFormula formula2 = new TeXFormula(this.getGroup('{', '}'));
                atom = atom != null && atom.isType(10) ? new AccentedAtom(formula2.root, atom) : formula2.root;
                TeXFormula teXFormula = this;
                teXFormula.add(teXFormula.attachScripts(atom));
                continue;
            }
            if (formula2 == 125) {
                void var2_4;
                String msg = String.format("Found closing '%s' without opening '%s'", Character.valueOf('}'), Character.valueOf('{'));
                throw new ParseException((String)var2_4);
            }
            if (var2_2 == 94 || var2_2 == 95 || var2_2 == 39) {
                if (this.pos == 0) {
                    throw new ParseException("Every script needs a base: \"^\", \"_\" and \"'\" can't be the first character");
                }
                throw new ParseException("Double scripts found, use more braces.");
            }
            atom = this.convertCharacter((char)var2_2);
            TeXFormula teXFormula = this;
            teXFormula.add(teXFormula.attachScripts(atom));
        }
    }

    /*
     * WARNING - void declaration
     */
    private Atom processCommands(String command) throws ParseException {
        void var1_1;
        void var2_3;
        TeXFormula num;
        this.skipWhitespace();
        if ("frac".equals(command)) {
            num = new TeXFormula(this.getGroup('{', '}'));
            this.skipWhitespace();
            TeXFormula denom = new TeXFormula(this.getGroup('{', '}'));
            if (num.root == null || denom.root == null) {
                throw new ParseException("Either a numerator or denominator must be present");
            }
            return new FractionAtom(num.root, denom.root, true);
        }
        if (this.pos == this.texStringLen) {
            throw new ParseException("Unrecognized command: '" + (String)((Object)num) + "'");
        }
        if (this.texString.charAt(this.pos) == '[') {
            nRoot = new TeXFormula(this.getGroup('[', ']'));
            this.skipWhitespace();
        } else {
            nRoot = new TeXFormula();
        }
        Atom base = new TeXFormula((String)this.getGroup((char)'{', (char)'}')).root;
        return new NthRootAtom((Atom)var2_3, var1_1.root);
    }

    /*
     * WARNING - void declaration
     */
    private String parseCommand() {
        void var1_2;
        String command;
        void var2_3;
        int startPos = ++this.pos;
        char ch = '\u0000';
        while (this.pos < this.texStringLen && Character.isAlphabetic(ch = this.texString.charAt(this.pos))) {
            ++this.pos;
        }
        if (var2_3 == false) {
            return "";
        }
        if (this.pos == startPos) {
            ++this.pos;
        }
        if ("cr".equals(command = this.texString.substring(startPos, this.pos)) && this.pos < this.texStringLen && this.texString.charAt(this.pos) == ' ') {
            ++this.pos;
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private Atom processEscape() throws ParseException {
        void var1_1;
        Object command = this.parseCommand();
        SymbolAtom symbolAtom = SymbolAtom.getNullable((String)command);
        if (symbolAtom != null) {
            return symbolAtom;
        }
        TeXFormula formula = TeXFormula.getNullable((String)command);
        if (formula != null) {
            void var2_2;
            return var2_2.root;
        }
        if (textStyles.contains(command)) {
            this.skipWhitespace();
            command = new TeXFormula(this.getGroup('{', '}'), (String)command);
            return ((TeXFormula)command).root;
        }
        if (commands.contains(command)) {
            return this.processCommands((String)command);
        }
        String msg = String.format("Unknown symbol or command or predefined formula: '%s'", command);
        throw new ParseException((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula putAccentOver(String accentName) throws InvalidSymbolTypeException, SymbolNotFoundException {
        void var1_1;
        this.root = new AccentedAtom(this.root, (String)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula putDelimiterOver(int delimiter) throws InvalidDelimiterTypeException, SymbolNotFoundException {
        void var1_2;
        if (delimiter < 0 || delimiter >= delimiterNames.length) {
            throw new InvalidDelimiterTypeException();
        }
        String name = delimiterNames[delimiter][0];
        this.root = new OverUnderDelimiterAtom(this.root, null, SymbolAtom.get((String)var1_2), 1, 0.0f, true);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula putDelimiterOver(int delimiter, String sup, int kernUnit, float kern) throws InvalidDelimiterTypeException, InvalidUnitException, ParseException, SymbolNotFoundException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.putDelimiterOver((int)var1_1, new TeXFormula((String)var2_2), (int)var3_3, kern);
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula putDelimiterOver(int delimiter, TeXFormula sup, int kernUnit, float kern) throws InvalidDelimiterTypeException, InvalidUnitException, SymbolNotFoundException {
        void var3_4;
        void var1_2;
        void var2_3;
        if (delimiter < 0 || delimiter >= delimiterNames.length) {
            throw new InvalidDelimiterTypeException();
        }
        String name = delimiterNames[delimiter][0];
        this.root = new OverUnderDelimiterAtom(this.root, sup == null ? null : var2_3.root, SymbolAtom.get((String)var1_2), (int)var3_4, kern, true);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula putDelimiterUnder(int delimiter) throws InvalidDelimiterTypeException, SymbolNotFoundException {
        void var1_2;
        if (delimiter < 0 || delimiter >= delimiterNames.length) {
            throw new InvalidDelimiterTypeException();
        }
        String name = delimiterNames[delimiter][1];
        this.root = new OverUnderDelimiterAtom(this.root, null, SymbolAtom.get((String)var1_2), 1, 0.0f, false);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula putDelimiterUnder(int delimiter, String sub, int kernUnit, float kern) throws InvalidDelimiterTypeException, InvalidUnitException, ParseException, SymbolNotFoundException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.putDelimiterUnder((int)var1_1, new TeXFormula((String)var2_2), (int)var3_3, kern);
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula putDelimiterUnder(int delimiter, TeXFormula sub, int kernUnit, float kern) throws InvalidDelimiterTypeException, InvalidUnitException, SymbolNotFoundException {
        void var3_4;
        void var1_2;
        void var2_3;
        if (delimiter < 0 || delimiter >= delimiterNames.length) {
            throw new InvalidDelimiterTypeException();
        }
        String name = delimiterNames[delimiter][1];
        this.root = new OverUnderDelimiterAtom(this.root, sub == null ? null : var2_3.root, SymbolAtom.get((String)var1_2), (int)var3_4, kern, false);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula putOver(TeXFormula over, int overUnit, float overSpace, boolean overScriptSize) throws InvalidUnitException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.root = new UnderOverAtom(this.root, over == null ? null : var1_1.root, (int)var2_2, (float)var3_3, overScriptSize, true);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula putOver(String over, int overUnit, float overSpace, boolean overScriptSize) throws InvalidUnitException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.putOver(over == null ? null : new TeXFormula((String)var1_1), (int)var2_2, (float)var3_3, overScriptSize);
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula putUnder(String under, int underUnit, float underSpace, boolean underScriptSize) throws InvalidUnitException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.putUnder(under == null ? null : new TeXFormula((String)var1_1), (int)var2_2, (float)var3_3, underScriptSize);
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula putUnder(TeXFormula under, int underUnit, float underSpace, boolean underScriptSize) throws InvalidUnitException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.root = new UnderOverAtom(this.root, under == null ? null : var1_1.root, (int)var2_2, (float)var3_3, underScriptSize, false);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula putUnderAndOver(String under, int underUnit, float underSpace, boolean underScriptSize, String over, int overUnit, float overSpace, boolean overScriptSize) throws InvalidUnitException, ParseException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.putUnderAndOver(under == null ? null : new TeXFormula((String)var1_1), (int)var2_2, (float)var3_3, underScriptSize, over == null ? null : new TeXFormula(over), overUnit, overSpace, overScriptSize);
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula putUnderAndOver(TeXFormula under, int underUnit, float underSpace, boolean underScriptSize, TeXFormula over, int overUnit, float overSpace, boolean overScriptSize) throws InvalidUnitException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.root = new UnderOverAtom(this.root, under == null ? null : var1_1.root, (int)var2_2, (float)var3_3, underScriptSize, over == null ? null : over.root, overUnit, overSpace, overScriptSize);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula setBackground(Color c) {
        if (c != null) {
            void var1_1;
            this.root = this.root instanceof ColorAtom ? new ColorAtom(c, null, (ColorAtom)this.root) : new ColorAtom(this.root, (Color)var1_1, null);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula setColor(Color c) {
        if (c != null) {
            void var1_1;
            this.root = this.root instanceof ColorAtom ? new ColorAtom(null, c, (ColorAtom)this.root) : new ColorAtom(this.root, null, (Color)var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula setFixedTypes(int leftType, int rightType) throws InvalidAtomTypeException {
        void var2_2;
        void var1_1;
        this.root = new TypedAtom((int)var1_1, (int)var2_2, this.root);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula setScripts(String sub, String sup) throws ParseException {
        void var2_2;
        void var1_1;
        return this.setScripts(new TeXFormula((String)var1_1), new TeXFormula((String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula setScripts(String sub, TeXFormula sup) throws ParseException {
        void var2_2;
        void var1_1;
        return this.setScripts(new TeXFormula((String)var1_1), (TeXFormula)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula setScripts(TeXFormula sub, String sup) throws ParseException {
        void var2_2;
        void var1_1;
        return this.setScripts((TeXFormula)var1_1, new TeXFormula((String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula setScripts(TeXFormula sub, TeXFormula sup) {
        void var2_2;
        void var1_1;
        this.root = new ScriptsAtom(this.root, sub == null ? null : var1_1.root, sup == null ? null : var2_2.root);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula setSubscript(String sub) throws ParseException {
        void var1_1;
        return this.setSubscript(new TeXFormula((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula setSubscript(TeXFormula sub) {
        void var1_1;
        this.root = new ScriptsAtom(this.root, sub == null ? null : var1_1.root, null);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula setSuperscript(String sup) throws ParseException {
        void var1_1;
        return this.setSuperscript(new TeXFormula((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula setSuperscript(TeXFormula sup) {
        void var1_1;
        this.root = new ScriptsAtom(this.root, null, sup == null ? null : var1_1.root);
        return this;
    }

    private void skipWhitespace() {
        while (this.pos < this.texStringLen && Character.isWhitespace(this.texString.charAt(this.pos))) {
            ++this.pos;
        }
    }

    public TeXFormula sqrt() {
        return this.nthRoot((TeXFormula)null);
    }

    public TeXFormula underline() {
        this.root = new UnderlinedAtom(this.root);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public static TeXFormula get(String name) throws FormulaNotFoundException {
        void var1_1;
        TeXFormula formula = TeXFormula.getNullable(name);
        if (formula == null) {
            String string;
            throw new FormulaNotFoundException(string);
        }
        return new TeXFormula((TeXFormula)var1_1);
    }

    private static TeXFormula getNullable(String name) {
        String string;
        return predefinedTeXFormulas.get(string);
    }

    /*
     * WARNING - void declaration
     */
    private static String getCharacterToDelimiterMapping(char ch) throws DelimiterMappingNotFoundException {
        void var1_1;
        String str = delimiterMappings[ch];
        if (str == null) {
            char c;
            throw new DelimiterMappingNotFoundException(c);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static SymbolAtom getDelimiterSymbol(String delName) throws SymbolNotFoundException, InvalidDelimiterException {
        void var1_1;
        SymbolAtom res = null;
        if (delName != null && !(res = SymbolAtom.get(delName)).isDelimiter()) {
            String string;
            throw new InvalidDelimiterException(string);
        }
        return var1_1;
    }

    public Atom getRoot() {
        return this.root;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        commands = new HashSet<String>();
        delimiterNames = new String[][]{{"lbrace", "rbrace"}, {"lsqbrack", "rsqbrack"}, {"lbrack", "rbrack"}, {"downarrow", "downarrow"}, {"uparrow", "uparrow"}, {"updownarrow", "updownarrow"}, {"Downarrow", "Downarrow"}, {"Uparrow", "Uparrow"}, {"Updownarrow", "Updownarrow"}, {"vert", "vert"}, {"Vert", "Vert"}};
        FONT_SCALE_FACTOR = 100.0f;
        PIXELS_PER_POINT = 1.0f;
        predefinedTeXFormulas = new HashMap<String, TeXFormula>();
        TeXFormulaSettingsParser parser = new TeXFormulaSettingsParser();
        symbolMappings = parser.parseSymbolMappings();
        delimiterMappings = parser.parseDelimiterMappings();
        textStyles = var0.parseTextStyles();
        commands.add("frac");
        commands.add("sqrt");
        new PredefinedTeXFormulaParser().parse(predefinedTeXFormulas);
    }
}

