/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex.graphics;

import com.whitemagicsoftware.tex.graphics.RyuDouble;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;

public abstract class AbstractGraphics2D
extends Graphics2D {
    private Color mColour = Color.BLACK;
    private Font mFont = new Font("Default", 0, 12);
    private AffineTransform mAffineTransform = new AffineTransform();
    private final FontRenderContext mRenderContext = new FontRenderContext(null, false, true);

    public abstract void initialize(int var1, int var2);

    public abstract void initialize(int var1, int var2, int var3);

    /*
     * WARNING - void declaration
     */
    @Override
    public void drawString(String glyphs, float x, float y) {
        void var3_3;
        void var2_2;
        void var1_1;
        assert (glyphs != null);
        Font font = this.getFont();
        FontRenderContext frc = this.getFontRenderContext();
        GlyphVector gv = font.createGlyphVector(frc, glyphs);
        this.drawGlyphVector((GlyphVector)var1_1, (float)var2_2, (float)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void drawString(String glyphs, int x, int y) {
        void var3_3;
        void var2_2;
        void var1_1;
        assert (glyphs != null);
        this.drawString((String)var1_1, (float)var2_2, (float)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.fill(var1_1.getOutline((float)var2_2, (float)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void translate(int x, int y) {
        void var2_2;
        void var1_1;
        this.translate((double)var1_1, (double)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void translate(double tx, double ty) {
        void var3_2;
        void var1_1;
        AffineTransform at = this.getTransform();
        at.translate((double)var1_1, (double)var3_2);
        this.setTransform(at);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void scale(double sx, double sy) {
        void var3_2;
        void var1_1;
        AffineTransform at = this.getTransform();
        at.scale((double)var1_1, (double)var3_2);
        this.setTransform(at);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setTransform(AffineTransform at) {
        void var1_1;
        assert (at != null);
        this.mAffineTransform = new AffineTransform((AffineTransform)var1_1);
    }

    @Override
    public AffineTransform getTransform() {
        return (AffineTransform)this.mAffineTransform.clone();
    }

    protected static String toString(AffineTransform at) {
        AffineTransform affineTransform;
        double d = at.getScaleX();
        double d2 = d;
        double d3 = at.getShearY();
        d2 = d3;
        double d4 = at.getShearX();
        d2 = d4;
        double d5 = at.getScaleY();
        d2 = d5;
        double d6 = at.getTranslateX();
        d2 = d6;
        d2 = affineTransform.getTranslateY();
        return "matrix(" + RyuDouble.doubleToString(d, 6) + "," + RyuDouble.doubleToString(d3, 6) + "," + RyuDouble.doubleToString(d4, 6) + "," + RyuDouble.doubleToString(d5, 6) + "," + RyuDouble.doubleToString(d6, 6) + "," + RyuDouble.doubleToString(d2, 6) + ")";
    }

    protected final boolean isIdentityTransform() {
        return this.mAffineTransform.isIdentity();
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.mRenderContext;
    }

    @Override
    public Font getFont() {
        return this.mFont;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setFont(Font font) {
        void var1_1;
        assert (font != null);
        this.mFont = var1_1;
    }

    @Override
    public Color getColor() {
        return this.mColour;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setColor(Color colour) {
        void var1_1;
        this.mColour = var1_1;
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return null;
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        return false;
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return false;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return false;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return false;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return false;
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return false;
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        return false;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
    }

    @Override
    public void fill(Shape s) {
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return false;
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return null;
    }

    @Override
    public void setComposite(Composite comp) {
    }

    @Override
    public void setPaint(Paint paint) {
    }

    @Override
    public void setStroke(Stroke s) {
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return null;
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
    }

    @Override
    public RenderingHints getRenderingHints() {
        return null;
    }

    @Override
    public Graphics create() {
        return null;
    }

    @Override
    public void setPaintMode() {
    }

    @Override
    public void setXORMode(Color c1) {
    }

    @Override
    public Rectangle getClipBounds() {
        return null;
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
    }

    @Override
    public Shape getClip() {
        return null;
    }

    @Override
    public void setClip(Shape clip) {
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
    }

    @Override
    public void rotate(double theta) {
    }

    @Override
    public void rotate(double theta, double x, double y) {
    }

    @Override
    public void shear(double shx, double shy) {
    }

    @Override
    public void transform(AffineTransform Tx) {
    }

    @Override
    public Paint getPaint() {
        return null;
    }

    @Override
    public Composite getComposite() {
        return null;
    }

    @Override
    public void setBackground(Color color) {
    }

    @Override
    public Color getBackground() {
        return null;
    }

    @Override
    public Stroke getStroke() {
        return null;
    }

    @Override
    public void clip(Shape s) {
    }
}

