/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cjk;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.charfilter.BaseCharFilter;

public class CJKWidthCharFilter
extends BaseCharFilter {
    private static final char[] KANA_NORM = new char[]{'\u30fb', '\u30f2', '\u30a1', '\u30a3', '\u30a5', '\u30a7', '\u30a9', '\u30e3', '\u30e5', '\u30e7', '\u30c3', '\u30fc', '\u30a2', '\u30a4', '\u30a6', '\u30a8', '\u30aa', '\u30ab', '\u30ad', '\u30af', '\u30b1', '\u30b3', '\u30b5', '\u30b7', '\u30b9', '\u30bb', '\u30bd', '\u30bf', '\u30c1', '\u30c4', '\u30c6', '\u30c8', '\u30ca', '\u30cb', '\u30cc', '\u30cd', '\u30ce', '\u30cf', '\u30d2', '\u30d5', '\u30d8', '\u30db', '\u30de', '\u30df', '\u30e0', '\u30e1', '\u30e2', '\u30e4', '\u30e6', '\u30e8', '\u30e9', '\u30ea', '\u30eb', '\u30ec', '\u30ed', '\u30ef', '\u30f3', '\u3099', '\u309a'};
    private static final byte[] KANA_COMBINE_VOICED = new byte[]{78, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 8, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
    private static final byte[] KANA_COMBINE_SEMI_VOICED = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 2, 0, 0, 2, 0, 0, 2, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private int prevChar = -1;
    private int inputOff = 0;

    /*
     * WARNING - void declaration
     */
    public CJKWidthCharFilter(Reader in) {
        super((Reader)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int read() throws IOException {
        void var2_2;
        int ret;
        do {
            void var1_1;
            int ch;
            if ((ch = this.input.read()) == -1) {
                ret = this.prevChar;
                this.prevChar = ch;
                return ret;
            }
            ++this.inputOff;
            ret = -1;
            if (ch == 65439 || ch == 65438) {
                int combinedChar;
                int n = ch;
                int n2 = this.prevChar;
                assert (n == 65439 || n == 65438);
                if (n2 >= 12454 && n2 <= 12541) {
                    CJKWidthCharFilter cJKWidthCharFilter;
                    n2 += n == 65439 ? KANA_COMBINE_SEMI_VOICED[cJKWidthCharFilter.prevChar - 12454] : KANA_COMBINE_VOICED[cJKWidthCharFilter.prevChar - 12454];
                }
                if (this.prevChar != (combinedChar = n2)) {
                    void var3_3;
                    this.prevChar = -1;
                    int prevCumulativeDiff = this.getLastCumulativeDiff();
                    CJKWidthCharFilter cJKWidthCharFilter = this;
                    cJKWidthCharFilter.addOffCorrectMap(cJKWidthCharFilter.inputOff - 1 - prevCumulativeDiff, (int)(var1_1 + true));
                    return (int)var3_3;
                }
            }
            if (this.prevChar != -1) {
                ret = this.prevChar;
            }
            this.prevChar = var1_1 >= 65281 && var1_1 <= 65374 ? var1_1 - 65248 : (var1_1 >= 65381 && var1_1 <= 65439 ? KANA_NORM[var1_1 - 65381] : var1_1);
        } while (ret == -1);
        return (int)var2_2;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int c;
        int numRead = 0;
        for (int i = off; i < off + len && (c = this.read()) != -1; ++i) {
            cbuf[i] = (char)c;
            ++numRead;
        }
        if (numRead == 0) {
            return -1;
        }
        return numRead;
    }
}

