/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.analysis.CharArrayMap;

public class CharArraySet
extends AbstractSet<Object> {
    public static final CharArraySet EMPTY_SET = new CharArraySet(CharArrayMap.emptyMap());
    private static final Object PLACEHOLDER = new Object();
    private final CharArrayMap<Object> map;

    /*
     * WARNING - void declaration
     */
    public CharArraySet(int startSize, boolean ignoreCase) {
        this(new CharArrayMap<Object>((int)var1_1, (boolean)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public CharArraySet(Collection<?> c, boolean ignoreCase) {
        this(c.size(), false);
        void var1_1;
        this.addAll(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    CharArraySet(CharArrayMap<Object> map) {
        void var1_1;
        this.map = var1_1;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean contains(char[] text, int off, int len) {
        void var3_3;
        void var1_1;
        return this.map.containsKey((char[])var1_1, 0, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(Object o) {
        void var1_1;
        return this.map.containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean add(Object o) {
        void var1_1;
        return this.map.put((Object)var1_1, PLACEHOLDER) == null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean add(String text) {
        void var1_1;
        return this.map.put((String)var1_1, PLACEHOLDER) == null;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public static CharArraySet unmodifiableSet(CharArraySet set) {
        CharArraySet charArraySet;
        if (set == null) {
            throw new NullPointerException("Given set is null");
        }
        if (set == EMPTY_SET) {
            return EMPTY_SET;
        }
        if (set.map instanceof CharArrayMap.UnmodifiableCharArrayMap) {
            return set;
        }
        return new CharArraySet(CharArrayMap.unmodifiableMap(charArraySet.map));
    }

    public static CharArraySet copy(Set<?> set) {
        CharArraySet charArraySet;
        if (set == EMPTY_SET) {
            return EMPTY_SET;
        }
        if (set instanceof CharArraySet) {
            CharArraySet source = (CharArraySet)set;
            return new CharArraySet(CharArrayMap.copy(charArraySet.map));
        }
        return new CharArraySet(charArraySet, false);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.map.originalKeySet().iterator();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder("[");
        for (Object item : this) {
            void var3_3;
            if (sb.length() > 1) {
                sb.append(", ");
            }
            if (item instanceof char[]) {
                sb.append((char[])item);
                continue;
            }
            sb.append(var3_3);
        }
        return var1_1.append(']').toString();
    }
}

