/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja.dict;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.lucene.analysis.ja.dict.Dictionary;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.InputStreamDataInput;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRef;

public abstract class BinaryDictionary
implements Dictionary {
    private final ResourceScheme resourceScheme;
    private final String resourcePath;
    private final ByteBuffer buffer;
    private final int[] targetMapOffsets;
    private final int[] targetMap;

    protected BinaryDictionary() throws IOException {
        this(ResourceScheme.CLASSPATH, null);
    }

    /*
     * WARNING - void declaration
     */
    protected BinaryDictionary(ResourceScheme resourceScheme, String resourcePath) throws IOException {
        ByteBuffer buffer;
        int[] targetMap;
        this.resourceScheme = resourceScheme;
        if (resourcePath == null) {
            if (resourceScheme != ResourceScheme.CLASSPATH) {
                throw new IllegalArgumentException("resourcePath must be supplied with FILE resource scheme");
            }
            this.resourcePath = this.getClass().getName().replace('.', '/');
        } else {
            this.resourcePath = resourcePath;
        }
        InputStream mapIS = null;
        InputStream dictIS = null;
        InputStream posIS = null;
        try {
            mapIS = this.getResource("$targetMap.dat");
            mapIS = new BufferedInputStream(mapIS);
            InputStreamDataInput in = new InputStreamDataInput(mapIS);
            CodecUtil.checkHeader(in, "kuromoji_dict_map", 1, 1);
            targetMap = new int[in.readVInt()];
            int[] targetMapOffsets = new int[in.readVInt()];
            int accum = 0;
            int sourceId = 0;
            for (int ofs = 0; ofs < targetMap.length; ++ofs) {
                int val = in.readVInt();
                if ((val & 1) != 0) {
                    targetMapOffsets[sourceId] = ofs;
                    ++sourceId;
                }
                targetMap[ofs] = accum += val >>> 1;
            }
            if (sourceId + 1 != targetMapOffsets.length) {
                throw new IOException("targetMap file format broken; targetMap.length=" + targetMap.length + ", targetMapOffsets.length=" + targetMapOffsets.length + ", sourceId=" + sourceId);
            }
            targetMapOffsets[sourceId] = targetMap.length;
            mapIS.close();
            mapIS = null;
            posIS = this.getResource("$posDict.dat");
            posIS = new BufferedInputStream(posIS);
            in = new InputStreamDataInput(posIS);
            CodecUtil.checkHeader(in, "kuromoji_dict_pos", 1, 1);
            int posSize = in.readVInt();
            String[] posDict = new String[posSize];
            String[] inflTypeDict = new String[posSize];
            String[] inflFormDict = new String[posSize];
            for (int j = 0; j < posSize; ++j) {
                posDict[j] = in.readString();
                inflTypeDict[j] = in.readString();
                inflFormDict[j] = in.readString();
                if (inflTypeDict[j].length() == 0) {
                    inflTypeDict[j] = null;
                }
                if (inflFormDict[j].length() != 0) continue;
                inflFormDict[j] = null;
            }
            posIS.close();
            posIS = null;
            dictIS = this.getResource("$buffer.dat");
            in = new InputStreamDataInput(dictIS);
            CodecUtil.checkHeader(in, "kuromoji_dict", 1, 1);
            int size = in.readVInt();
            ByteBuffer tmpBuffer = ByteBuffer.allocateDirect(size);
            ReadableByteChannel readableByteChannel = Channels.newChannel(dictIS);
            int n = readableByteChannel.read(tmpBuffer);
            if (n != size) {
                throw new EOFException("Cannot read whole dictionary");
            }
            dictIS.close();
            dictIS = null;
            buffer = tmpBuffer.asReadOnlyBuffer();
        }
        catch (Throwable targetMapOffsets) {
            void var2_2;
            void var3_3;
            void var1_1;
            IOUtils.closeWhileHandlingException(new Closeable[]{var1_1, var3_3, var2_2});
            throw targetMapOffsets;
        }
        IOUtils.close(null, null, null);
        this.targetMap = targetMap;
        this.targetMapOffsets = targetMapOffsets;
        this.buffer = buffer;
    }

    /*
     * WARNING - void declaration
     */
    protected final InputStream getResource(String suffix) throws IOException {
        switch (this.resourceScheme) {
            case CLASSPATH: {
                return BinaryDictionary.getClassResource(this.resourcePath + suffix);
            }
            case FILE: {
                void var1_1;
                return Files.newInputStream(Paths.get(this.resourcePath + (String)var1_1, new String[0]), new OpenOption[0]);
            }
        }
        throw new IllegalStateException("unknown resource scheme " + (Object)((Object)this.resourceScheme));
    }

    /*
     * WARNING - void declaration
     */
    public static final InputStream getResource(ResourceScheme scheme, String path) throws IOException {
        ResourceScheme resourceScheme;
        switch (scheme) {
            case CLASSPATH: {
                return BinaryDictionary.getClassResource(path);
            }
            case FILE: {
                void var1_1;
                return Files.newInputStream(Paths.get((String)var1_1, new String[0]), new OpenOption[0]);
            }
        }
        throw new IllegalStateException("unknown resource scheme " + (Object)((Object)resourceScheme));
    }

    /*
     * WARNING - void declaration
     */
    public static final InputStream getClassResource(Class<?> clazz, String suffix) throws IOException {
        void var2_2;
        InputStream is = clazz.getResourceAsStream(clazz.getSimpleName() + suffix);
        if (is == null) {
            void var1_1;
            Class<?> clazz2;
            throw new FileNotFoundException("Not in classpath: " + clazz2.getName().replace('.', '/') + (String)var1_1);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static InputStream getClassResource(String path) throws IOException {
        void var1_1;
        InputStream is = BinaryDictionary.class.getClassLoader().getResourceAsStream(path);
        if (is == null) {
            String string;
            throw new FileNotFoundException("Not in classpath: " + string);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void lookupWordIds(int sourceId, IntsRef ref) {
        void var2_2;
        void var1_1;
        ref.ints = this.targetMap;
        ref.offset = this.targetMapOffsets[sourceId];
        ref.length = this.targetMapOffsets[var1_1 + true] - var2_2.offset;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getLeftId(int wordId) {
        void var1_1;
        return (this.buffer.getShort((int)var1_1) & 0xFFFF) >>> 3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getRightId(int wordId) {
        void var1_1;
        return (this.buffer.getShort((int)var1_1) & 0xFFFF) >>> 3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getWordCost(int wordId) {
        void var1_1;
        return this.buffer.getShort((int)(var1_1 + 2));
    }

    public static final class ResourceScheme
    extends Enum<ResourceScheme> {
        public static final /* enum */ ResourceScheme CLASSPATH = new ResourceScheme();
        public static final /* enum */ ResourceScheme FILE = new ResourceScheme();
        private static final /* synthetic */ ResourceScheme[] $VALUES;

        public static ResourceScheme[] values() {
            return (ResourceScheme[])$VALUES.clone();
        }

        static {
            $VALUES = new ResourceScheme[]{CLASSPATH, FILE};
        }
    }
}

