/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.ReverseBytesReader;

class BytesStore
extends DataOutput {
    private final List<byte[]> blocks = new ArrayList<byte[]>();
    private final int blockSize;
    private final int blockBits;
    private final int blockMask;
    private byte[] current;
    private int nextWrite;

    public BytesStore(int blockBits) {
        this.blockBits = 10;
        this.blockSize = 1024;
        this.blockMask = this.blockSize - 1;
        this.nextWrite = this.blockSize;
    }

    /*
     * WARNING - void declaration
     */
    public BytesStore(DataInput in, long numBytes, int maxBlockSize) throws IOException {
        void var2_3;
        int blockSize = 2;
        int blockBits = 1;
        while ((long)blockSize < numBytes && blockSize < maxBlockSize) {
            blockSize <<= 1;
            ++blockBits;
        }
        this.blockBits = blockBits;
        this.blockSize = blockSize;
        this.blockMask = blockSize - 1;
        for (long left = numBytes; left > 0L; left -= (long)var2_3) {
            void var3_8;
            int chunk = (int)Math.min((long)blockSize, left);
            byte[] block = new byte[chunk];
            in.readBytes(block, 0, block.length);
            this.blocks.add((byte[])var3_8);
        }
        this.nextWrite = this.blocks.get(this.blocks.size() - 1).length;
    }

    @Override
    public final void writeBytes(byte[] b, int offset, int len) {
        while (len > 0) {
            int chunk = this.blockSize - this.nextWrite;
            if (len <= chunk) {
                assert (b != null);
                assert (this.current != null);
                System.arraycopy(b, offset, this.current, this.nextWrite, len);
                this.nextWrite += len;
                return;
            }
            if (chunk > 0) {
                System.arraycopy(b, offset, this.current, this.nextWrite, chunk);
                offset += chunk;
                len -= chunk;
            }
            this.current = new byte[this.blockSize];
            this.blocks.add(this.current);
            this.nextWrite = 0;
        }
    }

    public final FST.BytesReader getReverseReader() {
        boolean bl = true;
        BytesStore bytesStore = this;
        if (bytesStore.blocks.size() == 1) {
            return new ReverseBytesReader(bytesStore.blocks.get(0));
        }
        return new FST.BytesReader(bytesStore){
            private byte[] current;
            private int nextBuffer;
            private int nextRead;
            private /* synthetic */ BytesStore this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.current = this.this$0.blocks.size() == 0 ? null : (byte[])this.this$0.blocks.get(0);
                this.nextBuffer = -1;
                this.nextRead = 0;
            }

            @Override
            public final byte readByte() {
                if (this.nextRead == -1) {
                    this.current = (byte[])this.this$0.blocks.get(this.nextBuffer--);
                    this.nextRead = this.this$0.blockSize - 1;
                }
                return this.current[this.nextRead--];
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void skipBytes(long count) {
                void var1_1;
                2 v0 = this;
                v0.setPosition(v0.getPosition() - var1_1);
            }

            @Override
            public final void readBytes(byte[] b, int offset, int len) {
                for (int i = 0; i < len; ++i) {
                    b[offset + i] = this.readByte();
                }
            }

            @Override
            public final long getPosition() {
                return ((long)this.nextBuffer + 1L) * (long)this.this$0.blockSize + (long)this.nextRead;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void setPosition(long pos) {
                void var3_2;
                int bufferIndex = (int)(pos >> this.this$0.blockBits);
                this.nextBuffer = bufferIndex - 1;
                this.current = (byte[])this.this$0.blocks.get((int)var3_2);
                this.nextRead = (int)(pos & (long)this.this$0.blockMask);
                if (!$assertionsDisabled && this.getPosition() != pos) {
                    void var1_1;
                    throw new AssertionError((Object)("pos=" + (long)var1_1 + " getPos()=" + this.getPosition()));
                }
            }
        };
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(numBlocks=" + this.blocks.size() + ")";
    }

    static {
        RamUsageEstimator.shallowSizeOfInstance(BytesStore.class);
        RamUsageEstimator.shallowSizeOfInstance(ArrayList.class);
    }
}

