/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko.dict;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.analysis.ko.dict.BinaryDictionary;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.InputStreamDataInput;
import org.apache.lucene.util.IOUtils;

public final class CharacterDefinition {
    private static int CLASS_COUNT;
    private final byte[] characterCategoryMap = new byte[65536];
    private final boolean[] invokeMap = new boolean[CLASS_COUNT];
    private final boolean[] groupMap = new boolean[CLASS_COUNT];
    public static final byte NGRAM;

    /*
     * WARNING - void declaration
     */
    private CharacterDefinition() throws IOException {
        InputStream is = null;
        try {
            is = BinaryDictionary.getClassResource(this.getClass(), ".dat");
            is = new BufferedInputStream(is);
            InputStreamDataInput in = new InputStreamDataInput(is);
            CodecUtil.checkHeader(in, "ko_cd", 1, 1);
            ((DataInput)in).readBytes(this.characterCategoryMap, 0, 65536);
            for (int i = 0; i < CLASS_COUNT; ++i) {
                byte b = ((DataInput)in).readByte();
                this.invokeMap[i] = (b & 1) != 0;
                this.groupMap[i] = (b & 2) != 0;
            }
        }
        catch (Throwable throwable) {
            void var1_1;
            IOUtils.closeWhileHandlingException(new Closeable[]{var1_1});
            throw throwable;
        }
        IOUtils.close(is);
    }

    /*
     * WARNING - void declaration
     */
    public final byte getCharacterClass(char c) {
        void var1_1;
        return this.characterCategoryMap[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isInvoke(char c) {
        void var1_1;
        return this.invokeMap[this.characterCategoryMap[var1_1]];
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isGroup(char c) {
        void var1_1;
        return this.groupMap[this.characterCategoryMap[var1_1]];
    }

    public static CharacterDefinition getInstance() {
        return SingletonHolder.INSTANCE;
    }

    /* synthetic */ CharacterDefinition(byte by) throws IOException {
        this();
    }

    static {
        CharacterClass.values$46137c2c();
        CLASS_COUNT = 14;
        NGRAM = 0;
    }

    static final class SingletonHolder {
        static final CharacterDefinition INSTANCE;

        /*
         * WARNING - void declaration
         */
        static {
            try {
                INSTANCE = new CharacterDefinition(0);
                return;
            }
            catch (IOException ioe) {
                void var0;
                throw new RuntimeException("Cannot load CharacterDefinition.", (Throwable)var0);
            }
        }
    }

    static final class CharacterClass
    extends Enum<CharacterClass> {
        public static final int NGRAM$d09bb1a = 1;
        public static final int DEFAULT$d09bb1a = 2;
        public static final int SPACE$d09bb1a = 3;
        public static final int SYMBOL$d09bb1a = 4;
        public static final int NUMERIC$d09bb1a = 5;
        public static final int ALPHA$d09bb1a = 6;
        public static final int CYRILLIC$d09bb1a = 7;
        public static final int GREEK$d09bb1a = 8;
        public static final int HIRAGANA$d09bb1a = 9;
        public static final int KATAKANA$d09bb1a = 10;
        public static final int KANJI$d09bb1a = 11;
        public static final int HANGUL$d09bb1a = 12;
        public static final int HANJA$d09bb1a = 13;
        public static final int HANJANUMERIC$d09bb1a = 14;
        private static final /* synthetic */ int[] $VALUES$4384902b;

        public static int[] values$46137c2c() {
            return (int[])$VALUES$4384902b.clone();
        }

        static {
            $VALUES$4384902b = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14};
        }
    }
}

