/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.io.IOException;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.fst.BitTableUtil;
import org.apache.lucene.util.fst.BytesStore;
import org.apache.lucene.util.fst.FSTStore;
import org.apache.lucene.util.fst.OnHeapFSTStore;
import org.apache.lucene.util.fst.Outputs;

public final class FST<T> {
    private INPUT_TYPE inputType;
    private T emptyOutput;
    private BytesStore bytes = null;
    private final FSTStore fstStore;
    private long startNode = -1L;
    public final Outputs<T> outputs;
    private static final int DEFAULT_MAX_BLOCK_BITS;

    /*
     * WARNING - void declaration
     */
    private static boolean flag(int flags, int bit) {
        void var1_1;
        return (flags & var1_1) != 0;
    }

    /*
     * WARNING - void declaration
     */
    public FST(DataInput metaIn, DataInput in, Outputs<T> outputs) throws IOException {
        this((DataInput)var1_1, (DataInput)var2_2, (Outputs<T>)var3_3, new OnHeapFSTStore(DEFAULT_MAX_BLOCK_BITS));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private FST(DataInput metaIn, DataInput in, Outputs<T> outputs, FSTStore fstStore) throws IOException {
        void var2_2;
        void var1_1;
        this.fstStore = fstStore;
        this.outputs = outputs;
        CodecUtil.checkHeader(metaIn, "FST", 6, 7);
        if (metaIn.readByte() == 1) {
            void var3_3;
            Object emptyBytes = new BytesStore(10);
            int numBytes = metaIn.readVInt();
            ((DataOutput)emptyBytes).copyBytes(metaIn, numBytes);
            BytesReader reader = ((BytesStore)emptyBytes).getReverseReader();
            if (numBytes > 0) {
                reader.setPosition(numBytes - 1);
            }
            emptyBytes = reader;
            this.emptyOutput = var3_3.read((DataInput)emptyBytes);
        } else {
            this.emptyOutput = null;
        }
        byte t = metaIn.readByte();
        switch (t) {
            case 0: {
                this.inputType = INPUT_TYPE.BYTE1;
                break;
            }
            case 1: {
                this.inputType = INPUT_TYPE.BYTE2;
                break;
            }
            case 2: {
                this.inputType = INPUT_TYPE.BYTE4;
                break;
            }
            default: {
                throw new CorruptIndexException("invalid input type " + t, in);
            }
        }
        this.startNode = metaIn.readVLong();
        long numBytes = var1_1.readVLong();
        this.fstStore.init((DataInput)var2_2, numBytes);
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "(input=" + (Object)((Object)this.inputType) + ",output=" + this.outputs;
    }

    /*
     * WARNING - void declaration
     */
    private int readLabel(DataInput in) throws IOException {
        void var1_2;
        void v22;
        int v22 = this.inputType == INPUT_TYPE.BYTE1 ? in.readByte() & 0xFF : (this.inputType == INPUT_TYPE.BYTE2 ? (short)((v22.readByte() & 0xFF) << 8 | v22.readByte() & 0xFF) & 0xFFFF : v22.readVInt());
        return (int)var1_2;
    }

    private static int getNumPresenceBytes(int labelRange) {
        int n;
        assert (labelRange >= 0);
        return n + 7 >> 3;
    }

    /*
     * WARNING - void declaration
     */
    private static void readPresenceBytes(Arc<T> arc, BytesReader in) throws IOException {
        Arc arc2;
        void var1_1;
        assert (arc.bytesPerArc() > 0);
        assert (arc.nodeFlags() == 64);
        Arc.access$102(arc, in.getPosition());
        var1_1.skipBytes(FST.getNumPresenceBytes(arc2.numArcs()));
    }

    /*
     * WARNING - void declaration
     */
    public final Arc<T> getFirstArc(Arc<T> arc) {
        void var1_1;
        void var2_2;
        T NO_OUTPUT = this.outputs.getNoOutput();
        if (this.emptyOutput != null) {
            Arc.access$302(arc, (byte)3);
            Arc.access$402(arc, this.emptyOutput);
            if (this.emptyOutput != NO_OUTPUT) {
                Arc<T> arc2 = arc;
                Arc.access$302(arc2, (byte)(arc2.flags() | 0x20));
            }
        } else {
            Arc.access$302(arc, (byte)2);
            Arc.access$402(arc, NO_OUTPUT);
        }
        Arc.access$502(arc, var2_2);
        Arc.access$602(arc, this.startNode);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Arc<T> readArcByDirectAddressing(Arc<T> arc, BytesReader in, int rangeIndex, int presenceIndex) throws IOException {
        void var2_2;
        void var1_1;
        void var3_3;
        in.setPosition(arc.posArcsStart() - (long)(presenceIndex * arc.bytesPerArc()));
        Arc.access$1302(arc, (int)var3_3);
        Arc.access$1502(arc, presenceIndex);
        Arc.access$302(arc, in.readByte());
        return this.readArc((Arc<T>)var1_1, (BytesReader)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private Arc<T> readNextRealArc(Arc<T> arc, BytesReader in) throws IOException {
        void var2_2;
        void var1_1;
        switch (arc.nodeFlags()) {
            case 32: {
                assert (arc.bytesPerArc() > 0);
                ((Arc)arc).arcIdx++;
                assert (arc.arcIdx() >= 0 && arc.arcIdx() < arc.numArcs());
                in.setPosition(arc.posArcsStart() - (long)(arc.arcIdx() * arc.bytesPerArc()));
                Arc.access$302(arc, in.readByte());
                break;
            }
            case 64: {
                void var3_3;
                if (!$assertionsDisabled) {
                    Arc.BitTable.assertIsValid(arc, in);
                }
                assert (arc.arcIdx() == -1 || Arc.BitTable.isBitSet(arc.arcIdx(), arc, in));
                int nextIndex = Arc.BitTable.nextBitSet(arc.arcIdx(), arc, in);
                return this.readArcByDirectAddressing(arc, in, (int)var3_3, ((Arc)arc).presenceIndex + 1);
            }
            default: {
                assert (arc.bytesPerArc() == 0);
                in.setPosition(arc.nextArc());
                Arc.access$302(arc, in.readByte());
            }
        }
        return this.readArc((Arc<T>)var1_1, (BytesReader)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private Arc<T> readArc(Arc<T> arc, BytesReader in) throws IOException {
        void var1_1;
        Object object;
        if (arc.nodeFlags() == 64) {
            Arc<T> arc2 = arc;
            Arc.access$702(arc2, arc2.firstLabel() + arc.arcIdx());
        } else {
            Arc.access$702(arc, this.readLabel(in));
        }
        if (arc.flag(16)) {
            Arc.access$502(arc, this.outputs.read(in));
        } else {
            Arc.access$502(arc, this.outputs.getNoOutput());
        }
        if (arc.flag(32)) {
            BytesReader bytesReader = in;
            object = this.outputs;
            Arc.access$402(arc, ((Outputs)object).read(bytesReader));
        } else {
            Arc.access$402(arc, this.outputs.getNoOutput());
        }
        if (arc.flag(8)) {
            if (arc.flag(1)) {
                Arc.access$602(arc, -1L);
            } else {
                Arc.access$602(arc, 0L);
            }
            Arc.access$1402(arc, in.getPosition());
        } else if (arc.flag(4)) {
            Arc.access$1402(arc, in.getPosition());
            if (!arc.flag(2)) {
                if (arc.bytesPerArc() == 0) {
                    this.seekToNextNode(in);
                } else {
                    void var3_5;
                    int numArcs = ((Arc)arc).nodeFlags == 64 ? Arc.BitTable.countBits(arc, in) : arc.numArcs();
                    in.setPosition(arc.posArcsStart() - (long)(arc.bytesPerArc() * var3_5));
                }
            }
            Arc.access$602(arc, in.getPosition());
        } else {
            void var2_2;
            object = in;
            Arc.access$602(arc, ((DataInput)object).readVLong());
            Arc.access$1402(arc, var2_2.getPosition());
        }
        return var1_1;
    }

    public final Arc<T> findTargetArc(int labelToMatch, Arc<T> follow, Arc<T> arc, BytesReader in) throws IOException {
        Arc<T> arc2;
        if (labelToMatch == -1) {
            if (follow.isFinal()) {
                if (follow.target() <= 0L) {
                    Arc.access$302(arc, (byte)2);
                } else {
                    Arc.access$302(arc, (byte)0);
                    Arc.access$1402(arc, follow.target());
                }
                Arc.access$502(arc, follow.nextFinalOutput());
                Arc.access$702(arc, -1);
                Arc<T> arc3 = arc;
                Arc.access$802(arc3, ((Arc)arc3).flags);
                return arc;
            }
            return null;
        }
        Arc<T> arc4 = follow;
        if (!(arc4.target() > 0L)) {
            return null;
        }
        in.setPosition(follow.target());
        byte flags2 = Arc.access$802(arc, in.readByte());
        if (flags2 == 64) {
            Arc.access$902(arc, in.readVInt());
            Arc.access$1002(arc, in.readVInt());
            FST.readPresenceBytes(arc, in);
            Arc.access$1102(arc, this.readLabel(in));
            Arc.access$1202(arc, in.getPosition());
            int arcIndex = labelToMatch - arc.firstLabel();
            if (arcIndex < 0 || arcIndex >= arc.numArcs()) {
                return null;
            }
            if (!Arc.BitTable.isBitSet(arcIndex, arc, in)) {
                return null;
            }
            BytesReader bytesReader = in;
            Arc<T> arc5 = arc;
            FST flags2 = this;
            if (!$assertionsDisabled) {
                Arc.BitTable.assertIsValid(arc5, bytesReader);
            }
            assert (arcIndex >= 0 && arcIndex < arc5.numArcs());
            assert (Arc.BitTable.isBitSet(arcIndex, arc5, bytesReader));
            int n = Arc.BitTable.countBitsUpTo(arcIndex, arc5, bytesReader);
            return flags2.readArcByDirectAddressing(arc5, bytesReader, arcIndex, n);
        }
        if (flags2 == 32) {
            Arc.access$902(arc, in.readVInt());
            Arc.access$1002(arc, in.readVInt());
            Arc.access$1202(arc, in.getPosition());
            int low = 0;
            int high = arc.numArcs() - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                in.setPosition(arc.posArcsStart() - (long)(arc.bytesPerArc() * mid + 1));
                int n = this.readLabel(in);
                int cmp = n - labelToMatch;
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                Arc.access$1302(arc, mid - 1);
                return this.readNextRealArc(arc, in);
            }
            return null;
        }
        long l = arc2.target();
        BytesReader bytesReader = in;
        arc2 = arc;
        long l2 = l;
        Arc<T> arc6 = this;
        bytesReader.setPosition(l2);
        byte by = Arc.access$802(arc2, bytesReader.readByte());
        if (by == 32 || by == 64) {
            Arc.access$902(arc2, bytesReader.readVInt());
            Arc.access$1002(arc2, bytesReader.readVInt());
            Arc.access$1302(arc2, -1);
            if (by == 64) {
                FST.readPresenceBytes(arc2, bytesReader);
                Arc.access$1102(arc2, ((FST)((Object)arc6)).readLabel(bytesReader));
                Arc.access$1502(arc2, -1);
            }
            Arc.access$1202(arc2, bytesReader.getPosition());
        } else {
            Arc.access$1402(arc2, l2);
            Arc.access$1002(arc2, 0);
        }
        ((FST)((Object)arc6)).readNextRealArc(arc2, bytesReader);
        while (arc.label() != labelToMatch) {
            if (arc.label() > labelToMatch) {
                return null;
            }
            arc6 = arc;
            if (arc6.flag(2)) {
                return null;
            }
            this.readNextRealArc(arc, in);
        }
        return arc;
    }

    /*
     * WARNING - void declaration
     */
    private void seekToNextNode(BytesReader in) throws IOException {
        void var2_2;
        do {
            Object object;
            BytesReader bytesReader;
            byte flags = in.readByte();
            this.readLabel(in);
            if (FST.flag(flags, 16)) {
                bytesReader = in;
                object = this.outputs;
                ((Outputs)object).read(bytesReader);
            }
            if (FST.flag(flags, 32)) {
                Outputs<T> outputs = this.outputs;
                bytesReader = in;
                object = outputs;
                object = outputs;
                outputs.read(bytesReader);
            }
            if (FST.flag(flags, 8) || FST.flag(flags, 4)) continue;
            object = in;
            ((DataInput)object).readVLong();
        } while (!FST.flag((int)var2_2, 2));
    }

    public final BytesReader getBytesReader() {
        if (this.fstStore != null) {
            return this.fstStore.getReverseBytesReader();
        }
        return ((BytesStore)null).getReverseReader();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$000(int x0, int x1) {
        void var1_1;
        return FST.flag(x0, (int)var1_1);
    }

    static {
        RamUsageEstimator.shallowSizeOfInstance(FST.class);
        RamUsageEstimator.shallowSizeOfInstance(Arc.class);
        DEFAULT_MAX_BLOCK_BITS = Constants.JRE_IS_64BIT ? 30 : 28;
    }

    public static abstract class BytesReader
    extends DataInput {
        public abstract long getPosition();

        public abstract void setPosition(long var1);
    }

    public static final class Arc<T> {
        private int label;
        private T output;
        private long target;
        private byte flags;
        private T nextFinalOutput;
        private long nextArc;
        private byte nodeFlags;
        private int bytesPerArc;
        private long posArcsStart;
        private int arcIdx;
        private int numArcs;
        private long bitTableStart;
        private int firstLabel;
        private int presenceIndex;

        /*
         * WARNING - void declaration
         */
        public final Arc<T> copyFrom(Arc<T> other) {
            void var1_1;
            Arc<T> arc = other;
            this.label = arc.label;
            arc = other;
            this.target = arc.target;
            arc = other;
            this.flags = arc.flags;
            arc = other;
            this.output = arc.output;
            arc = other;
            this.nextFinalOutput = arc.nextFinalOutput;
            arc = other;
            this.nextArc = arc.nextArc;
            arc = other;
            this.nodeFlags = arc.nodeFlags;
            arc = other;
            this.bytesPerArc = arc.bytesPerArc;
            arc = other;
            this.posArcsStart = arc.posArcsStart;
            arc = other;
            this.arcIdx = arc.arcIdx;
            arc = other;
            this.numArcs = arc.numArcs;
            this.bitTableStart = other.bitTableStart;
            arc = other;
            this.firstLabel = arc.firstLabel;
            this.presenceIndex = var1_1.presenceIndex;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        final boolean flag(int flag) {
            void var1_1;
            return FST.access$000(this.flags, (int)var1_1);
        }

        public final boolean isFinal() {
            return this.flag(1);
        }

        /*
         * WARNING - void declaration
         */
        public final String toString() {
            void var1_1;
            StringBuilder b = new StringBuilder();
            Arc arc = this;
            b.append(" target=").append(arc.target);
            arc = this;
            b.append(" label=0x").append(Integer.toHexString(arc.label));
            if (this.flag(1)) {
                b.append(" final");
            }
            if (this.flag(2)) {
                b.append(" last");
            }
            if (this.flag(4)) {
                b.append(" targetNext");
            }
            if (this.flag(8)) {
                b.append(" stop");
            }
            if (this.flag(16)) {
                arc = this;
                b.append(" output=").append(arc.output);
            }
            if (this.flag(32)) {
                arc = this;
                b.append(" nextFinalOutput=").append(arc.nextFinalOutput);
            }
            arc = this;
            if (arc.bytesPerArc != 0) {
                Arc arc2 = this;
                arc = arc2;
                arc = this;
                arc = this;
                b.append(" arcArray(idx=").append(arc2.arcIdx).append(" of ").append(arc.numArcs).append(")(").append(arc.nodeFlags == 64 ? "da" : "bs").append(")");
            }
            return var1_1.toString();
        }

        public final int label() {
            return this.label;
        }

        public final T output() {
            return this.output;
        }

        public final long target() {
            return this.target;
        }

        public final byte flags() {
            return this.flags;
        }

        public final T nextFinalOutput() {
            return this.nextFinalOutput;
        }

        final long nextArc() {
            return this.nextArc;
        }

        public final int arcIdx() {
            return this.arcIdx;
        }

        public final byte nodeFlags() {
            return this.nodeFlags;
        }

        public final long posArcsStart() {
            return this.posArcsStart;
        }

        public final int bytesPerArc() {
            return this.bytesPerArc;
        }

        public final int numArcs() {
            return this.numArcs;
        }

        final int firstLabel() {
            return this.firstLabel;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ long access$102(Arc x0, long x1) {
            void var1_1;
            x0.bitTableStart = var1_1;
            return x0.bitTableStart;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ byte access$302(Arc x0, byte x1) {
            void var1_1;
            x0.flags = var1_1;
            return x0.flags;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ Object access$402(Arc x0, Object x1) {
            void var1_1;
            x0.nextFinalOutput = var1_1;
            return x0.nextFinalOutput;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ Object access$502(Arc x0, Object x1) {
            void var1_1;
            x0.output = var1_1;
            return x0.output;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ long access$602(Arc x0, long x1) {
            void var1_1;
            x0.target = var1_1;
            return x0.target;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ int access$702(Arc x0, int x1) {
            void var1_1;
            x0.label = var1_1;
            return x0.label;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ byte access$802(Arc x0, byte x1) {
            void var1_1;
            x0.nodeFlags = var1_1;
            return x0.nodeFlags;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ int access$902(Arc x0, int x1) {
            void var1_1;
            x0.numArcs = var1_1;
            return x0.numArcs;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ int access$1002(Arc x0, int x1) {
            void var1_1;
            x0.bytesPerArc = var1_1;
            return x0.bytesPerArc;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ int access$1102(Arc x0, int x1) {
            void var1_1;
            x0.firstLabel = var1_1;
            return x0.firstLabel;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ long access$1202(Arc x0, long x1) {
            void var1_1;
            x0.posArcsStart = var1_1;
            return x0.posArcsStart;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ int access$1302(Arc x0, int x1) {
            void var1_1;
            x0.arcIdx = var1_1;
            return x0.arcIdx;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ long access$1402(Arc x0, long x1) {
            void var1_1;
            x0.nextArc = var1_1;
            return x0.nextArc;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ int access$1502(Arc x0, int x1) {
            void var1_1;
            x0.presenceIndex = var1_1;
            return x0.presenceIndex;
        }

        static final class BitTable {
            /*
             * WARNING - void declaration
             */
            static boolean isBitSet(int bitIndex, Arc<?> arc, BytesReader in) throws IOException {
                void var2_2;
                int n;
                void var1_1;
                assert (arc.nodeFlags() == 64);
                in.setPosition(((Arc)var1_1).bitTableStart);
                return BitTableUtil.isBitSet(n, (BytesReader)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            static int countBits(Arc<?> arc, BytesReader in) throws IOException {
                void var1_1;
                Arc<?> arc2;
                assert (arc.nodeFlags() == 64);
                in.setPosition(((Arc)arc).bitTableStart);
                return BitTableUtil.countBits(FST.getNumPresenceBytes(arc2.numArcs()), (BytesReader)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            static int countBitsUpTo(int bitIndex, Arc<?> arc, BytesReader in) throws IOException {
                void var2_2;
                int n;
                void var1_1;
                assert (arc.nodeFlags() == 64);
                in.setPosition(((Arc)var1_1).bitTableStart);
                return BitTableUtil.countBitsUpTo(n, (BytesReader)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            static int nextBitSet(int bitIndex, Arc<?> arc, BytesReader in) throws IOException {
                void var2_2;
                void var1_1;
                int n;
                assert (arc.nodeFlags() == 64);
                in.setPosition(((Arc)arc).bitTableStart);
                return BitTableUtil.nextBitSet(n, FST.getNumPresenceBytes(var1_1.numArcs()), (BytesReader)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            static boolean assertIsValid(Arc<?> arc, BytesReader in) throws IOException {
                void var1_1;
                Arc<?> arc2;
                assert (arc.bytesPerArc() > 0);
                assert (arc.nodeFlags() == 64);
                assert (BitTable.isBitSet(0, arc, in));
                assert (BitTable.isBitSet(arc.numArcs() - 1, arc, in));
                assert (BitTable.nextBitSet(arc.numArcs() - 1, arc2, (BytesReader)var1_1) == -1);
                return true;
            }
        }
    }

    public static final class INPUT_TYPE
    extends Enum<INPUT_TYPE> {
        public static final /* enum */ INPUT_TYPE BYTE1 = new INPUT_TYPE();
        public static final /* enum */ INPUT_TYPE BYTE2 = new INPUT_TYPE();
        public static final /* enum */ INPUT_TYPE BYTE4 = new INPUT_TYPE();

        static {
            INPUT_TYPE[] iNPUT_TYPEArray = new INPUT_TYPE[]{BYTE1, BYTE2, BYTE4};
        }
    }
}

