/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.tokenattributes;

import java.nio.CharBuffer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.AttributeReflector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;

public class CharTermAttributeImpl
extends AttributeImpl
implements Cloneable,
CharTermAttribute,
TermToBytesRefAttribute {
    private static int MIN_BUFFER_SIZE = 10;
    private char[] termBuffer = new char[ArrayUtil.oversize(MIN_BUFFER_SIZE, 2)];
    private int termLength = 0;
    private BytesRefBuilder builder = new BytesRefBuilder();

    /*
     * WARNING - void declaration
     */
    @Override
    public final void copyBuffer(char[] buffer, int offset, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        int n = length;
        CharTermAttributeImpl charTermAttributeImpl = this;
        if (charTermAttributeImpl.termBuffer.length < n) {
            charTermAttributeImpl.termBuffer = new char[ArrayUtil.oversize(n, 2)];
        }
        System.arraycopy(var1_1, (int)var2_2, this.termBuffer, 0, length);
        this.termLength = var3_3;
    }

    @Override
    public final char[] buffer() {
        return this.termBuffer;
    }

    /*
     * WARNING - void declaration
     */
    private char[] resizeBuffer(int newSize) {
        if (this.termBuffer.length < newSize) {
            void var1_2;
            char[] newCharBuffer = new char[ArrayUtil.oversize(newSize, 2)];
            System.arraycopy(this.termBuffer, 0, newCharBuffer, 0, this.termBuffer.length);
            this.termBuffer = var1_2;
        }
        return this.termBuffer;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final CharTermAttribute setLength(int length) {
        void var1_1;
        int n = this.termBuffer.length;
        int n2 = length;
        int n3 = 0;
        n3 = n2 + 0;
        if (n3 < 0 || n3 > n) {
            throw new IndexOutOfBoundsException("Range [" + 0 + ", 0" + " + " + n2 + ") out-of-bounds for length " + n);
        }
        this.termLength = var1_1;
        return this;
    }

    @Override
    public final CharTermAttribute setEmpty() {
        this.termLength = 0;
        return this;
    }

    @Override
    public final int length() {
        return this.termLength;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final char charAt(int index) {
        void var1_1;
        int n = this.termLength;
        int n2 = index;
        if (n2 < 0 || n2 >= n) {
            throw new IndexOutOfBoundsException("Index " + n2 + " out-of-bounds for length " + n);
        }
        return this.termBuffer[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final CharSequence subSequence(int start, int end) {
        void var1_1;
        void var2_2;
        Analyzer.TokenStreamComponents.checkFromToIndex(start, end, this.termLength);
        return new String(this.termBuffer, start, (int)(var2_2 - var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final CharTermAttribute append(CharSequence csq) {
        void var1_1;
        if (csq == null) {
            return this.appendNull();
        }
        return this.append(csq, 0, var1_1.length());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final CharTermAttribute append(CharSequence csq, int start, int end) {
        void var1_1;
        if (csq == null) {
            csq = "null";
        }
        Analyzer.TokenStreamComponents.checkFromToIndex(start, end, csq.length());
        int len = end - start;
        if (len == 0) {
            return this;
        }
        CharTermAttributeImpl charTermAttributeImpl = this;
        charTermAttributeImpl.resizeBuffer(charTermAttributeImpl.termLength + len);
        if (len > 4) {
            if (csq instanceof String) {
                ((String)csq).getChars(start, end, this.termBuffer, this.termLength);
            } else if (csq instanceof StringBuilder) {
                ((StringBuilder)csq).getChars(start, end, this.termBuffer, this.termLength);
            } else if (csq instanceof CharTermAttribute) {
                System.arraycopy(((CharTermAttribute)csq).buffer(), start, this.termBuffer, this.termLength, len);
            } else if (csq instanceof CharBuffer && ((CharBuffer)csq).hasArray()) {
                CharBuffer cb = (CharBuffer)csq;
                System.arraycopy(cb.array(), cb.arrayOffset() + var1_1.position() + start, this.termBuffer, this.termLength, len);
            } else if (var1_1 instanceof StringBuffer) {
                ((StringBuffer)var1_1).getChars(start, end, this.termBuffer, this.termLength);
            } else {
                while (start < end) {
                    this.termBuffer[this.termLength++] = var1_1.charAt(start++);
                }
                return this;
            }
            this.termLength += len;
            return this;
        }
        while (start < end) {
            this.termBuffer[this.termLength++] = var1_1.charAt(start++);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final CharTermAttribute append(char c) {
        void var1_1;
        CharTermAttributeImpl charTermAttributeImpl = this;
        charTermAttributeImpl.resizeBuffer((int)(charTermAttributeImpl.termLength + 1))[this.termLength++] = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final CharTermAttribute append(String s) {
        void var2_2;
        void var1_1;
        if (s == null) {
            return this.appendNull();
        }
        int len = s.length();
        CharTermAttributeImpl charTermAttributeImpl = this;
        var1_1.getChars(0, len, charTermAttributeImpl.resizeBuffer(charTermAttributeImpl.termLength + len), this.termLength);
        this.termLength += var2_2;
        return this;
    }

    private CharTermAttribute appendNull() {
        CharTermAttributeImpl charTermAttributeImpl = this;
        charTermAttributeImpl.resizeBuffer(charTermAttributeImpl.termLength + 4);
        this.termBuffer[this.termLength++] = 110;
        this.termBuffer[this.termLength++] = 117;
        this.termBuffer[this.termLength++] = 108;
        this.termBuffer[this.termLength++] = 108;
        return this;
    }

    public int hashCode() {
        int n = this.termLength;
        n = n * 31 + ArrayUtil.hashCode(this.termBuffer, 0, this.termLength);
        return n;
    }

    @Override
    public void clear() {
        this.termLength = 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CharTermAttributeImpl clone() {
        void var1_1;
        CharTermAttributeImpl t = (CharTermAttributeImpl)super.clone();
        ((CharTermAttributeImpl)super.clone()).termBuffer = new char[this.termLength];
        System.arraycopy(this.termBuffer, 0, t.termBuffer, 0, this.termLength);
        t.builder = new BytesRefBuilder();
        BytesRef bytesRef = this.builder.get();
        Object object = t.builder;
        BytesRefBuilder bytesRefBuilder = object;
        ((BytesRefBuilder)object).setLength(0);
        BytesRefBuilder bytesRefBuilder2 = object;
        object = bytesRef;
        bytesRefBuilder = bytesRefBuilder2;
        bytesRefBuilder2.append(((BytesRef)object).bytes, ((BytesRef)object).offset, ((BytesRef)object).length);
        return var1_1;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof CharTermAttributeImpl) {
            CharTermAttributeImpl o = (CharTermAttributeImpl)other;
            if (this.termLength != o.termLength) {
                return false;
            }
            for (int i = 0; i < this.termLength; ++i) {
                if (this.termBuffer[i] == o.termBuffer[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return new String(this.termBuffer, 0, this.termLength);
    }

    @Override
    public void reflectWith(AttributeReflector reflector) {
        CharTermAttributeImpl charTermAttributeImpl;
        reflector.reflect(CharTermAttribute.class, "term", this.toString());
        void v0 = charTermAttributeImpl;
        charTermAttributeImpl = this;
        charTermAttributeImpl.builder.copyChars(charTermAttributeImpl.termBuffer, 0, charTermAttributeImpl.termLength);
        v0.reflect(TermToBytesRefAttribute.class, "bytes", charTermAttributeImpl.builder.get());
    }
}

