/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jwheatsheaf.oxygen;

import com.io7m.junreachable.UnreachableCodeException;
import com.io7m.jwheatsheaf.api.JWFileImageSetType;
import com.io7m.jwheatsheaf.api.JWFileKind;
import java.net.URL;
import java.util.Optional;

public final class JWOxygenIconSet
implements JWFileImageSetType {
    private static Optional<URL> forName(String name) {
        return Optional.of(JWOxygenIconSet.class.getResource(String.format("/com/io7m/jwheatsheaf/oxygen/%s", name)));
    }

    public URL forSelectDirect() {
        return JWOxygenIconSet.forName("go-bottom.png").orElseThrow();
    }

    public URL forDirectoryCreate() {
        return JWOxygenIconSet.forName("folder-new.png").orElseThrow();
    }

    public URL forDirectoryUp() {
        return JWOxygenIconSet.forName("go-up.png").orElseThrow();
    }

    public URL forHome() {
        return JWOxygenIconSet.forName("go-home.png").orElseThrow();
    }

    public URL forRecentItems() {
        return JWOxygenIconSet.forName("chronometer-lap.png").orElseThrow();
    }

    public URL forFileSystem() {
        return JWOxygenIconSet.forName("drive-harddisk.png").orElseThrow();
    }

    public Optional<URL> forFileKind(JWFileKind kind) {
        switch (kind) {
            case REGULAR_FILE: {
                return JWOxygenIconSet.forName("unknown.png");
            }
            case DIRECTORY: {
                return JWOxygenIconSet.forName("inode-directory.png");
            }
            case SYMBOLIC_LINK: {
                return JWOxygenIconSet.forName("emblem-symbolic-link.png");
            }
            case UNKNOWN: {
                return Optional.empty();
            }
        }
        throw new UnreachableCodeException();
    }
}

