/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keenquotes;

import com.whitemagicsoftware.keenquotes.LexemeType;

public final class Lexeme
implements Comparable<Lexeme> {
    private static final int E_INDEX = -2;
    public static final Lexeme EOT = new Lexeme(LexemeType.FLAG, -1, -2);
    public static final Lexeme SOT = new Lexeme(LexemeType.FLAG, 0, -2);
    private final LexemeType mType;
    private final int mBegan;
    private final int mEnded;

    private Lexeme(LexemeType type, int began, int ended) {
        assert (type != null);
        assert (began >= 0 || ended == -2);
        assert (ended >= began || ended == -2);
        this.mType = type;
        this.mBegan = began;
        this.mEnded = ended + 1;
    }

    static Lexeme createLexeme(LexemeType lexeme, int began, int ended) {
        assert (lexeme != null);
        return new Lexeme(lexeme, began, ended);
    }

    public String toString(String text) {
        assert (text != null);
        return text.substring(this.mBegan, this.mEnded);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[mType=" + this.mType + ", mBegan=" + this.mBegan + ", mEnded=" + this.mEnded + "]";
    }

    public boolean isType(LexemeType type) {
        assert (type != null);
        return this.mType == type;
    }

    public boolean isType(LexemeType ... types) {
        assert (types != null);
        for (LexemeType type : types) {
            if (this.mType != type) continue;
            return true;
        }
        return false;
    }

    public int began() {
        return this.mBegan;
    }

    public int ended() {
        return this.mEnded;
    }

    boolean isSot() {
        return this.mBegan == 0;
    }

    boolean isEot() {
        return this.mBegan == -1;
    }

    LexemeType getType() {
        return this.mType;
    }

    public boolean before(Lexeme that) {
        return this.compareTo(that) < 0;
    }

    public boolean after(Lexeme that) {
        return this.compareTo(that) > 0;
    }

    @Override
    public int compareTo(Lexeme that) {
        assert (that != null);
        return this.mBegan - that.mBegan;
    }
}

