/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.charfilter;

import java.io.Reader;
import java.util.Arrays;
import org.apache.lucene.analysis.CharFilter;
import org.apache.lucene.util.ArrayUtil;

public abstract class BaseCharFilter
extends CharFilter {
    private int[] offsets;
    private int[] diffs;
    private int size = 0;

    /*
     * WARNING - void declaration
     */
    public BaseCharFilter(Reader in) {
        super((Reader)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final int correct(int currentOff) {
        void var2_2;
        void var1_1;
        if (this.offsets == null) {
            return currentOff;
        }
        int index = Arrays.binarySearch(this.offsets, 0, this.size, currentOff);
        if (index < -1) {
            index = -2 - index;
        }
        int diff = index < 0 ? 0 : this.diffs[index];
        return (int)(var1_1 + var2_2);
    }

    protected final int getLastCumulativeDiff() {
        if (this.offsets == null) {
            return 0;
        }
        return this.diffs[this.size - 1];
    }

    /*
     * WARNING - void declaration
     */
    protected final void addOffCorrectMap(int off, int cumulativeDiff) {
        void var2_2;
        if (this.offsets == null) {
            this.offsets = new int[64];
            this.diffs = new int[64];
        } else if (this.size == this.offsets.length) {
            this.offsets = ArrayUtil.grow(this.offsets);
            this.diffs = ArrayUtil.grow(this.diffs);
        }
        assert (this.size == 0 || off >= this.offsets[this.size - 1]) : "Offset #" + this.size + "(" + off + ") is less than the last recorded offset " + this.offsets[this.size - 1] + "\n" + Arrays.toString(this.offsets) + "\n" + Arrays.toString(this.diffs);
        if (this.size == 0 || off != this.offsets[this.size - 1]) {
            void var1_1;
            this.offsets[this.size] = var1_1;
            this.diffs[this.size++] = cumulativeDiff;
            return;
        }
        this.diffs[this.size - 1] = var2_2;
    }
}

