/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja;

import java.util.Map;
import org.apache.lucene.analysis.ja.JapaneseTokenizer;
import org.apache.lucene.analysis.ja.dict.ConnectionCosts;
import org.apache.lucene.analysis.ja.dict.Dictionary;

public class GraphvizFormatter {
    private final ConnectionCosts costs;
    private final Map<String, String> bestPathMap;
    private final StringBuilder sb;

    /*
     * WARNING - void declaration
     */
    final void onBacktrace(JapaneseTokenizer tok, JapaneseTokenizer.WrappedPositionArray positions, int lastBackTracePos, JapaneseTokenizer.Position endPosData, int fromIDX, char[] fragment, boolean isEnd) {
        void var3_3;
        void var2_2;
        void var1_1;
        int n;
        int n2 = fromIDX;
        JapaneseTokenizer.Position position = endPosData;
        int n3 = lastBackTracePos;
        JapaneseTokenizer.WrappedPositionArray wrappedPositionArray = positions;
        GraphvizFormatter graphvizFormatter = this;
        graphvizFormatter.bestPathMap.clear();
        int n4 = position.pos;
        while (n4 > n3) {
            JapaneseTokenizer.Position position2 = wrappedPositionArray.get(n4);
            int n5 = position2.backPos[n2];
            int n6 = position2.backIndex[n2];
            n = n2;
            n2 = n4;
            String string = n2 + "." + n;
            n = n6;
            n2 = n5;
            String string2 = n2 + "." + n;
            assert (!graphvizFormatter.bestPathMap.containsKey(string2));
            assert (!graphvizFormatter.bestPathMap.containsValue(string));
            graphvizFormatter.bestPathMap.put(string2, string);
            n4 = n5;
            n2 = n6;
        }
        this.sb.append(this.formatNodes((JapaneseTokenizer)var1_1, (JapaneseTokenizer.WrappedPositionArray)var2_2, (int)var3_3, endPosData, fragment));
        if (isEnd) {
            this.sb.append("  fini [style=invis]\n");
            this.sb.append("  ");
            n = fromIDX;
            n2 = endPosData.pos;
            this.sb.append(n2 + "." + n);
            this.sb.append(" -> fini [label=\"EOS\"]");
        }
    }

    private String formatNodes(JapaneseTokenizer tok, JapaneseTokenizer.WrappedPositionArray positions, int startPos, JapaneseTokenizer.Position endPosData, char[] fragment) {
        int n;
        int idx;
        JapaneseTokenizer.Position posData;
        int pos;
        StringBuilder sb = new StringBuilder();
        for (pos = startPos + 1; pos <= endPosData.pos; ++pos) {
            posData = positions.get(pos);
            for (idx = 0; idx < posData.count; ++idx) {
                sb.append("  ");
                n = idx;
                int n2 = pos;
                sb.append(n2 + "." + n);
                sb.append(" [label=\"");
                sb.append(pos);
                sb.append(": ");
                sb.append(posData.lastRightID[idx]);
                sb.append("\"]\n");
            }
        }
        for (pos = endPosData.pos; pos > startPos; --pos) {
            posData = positions.get(pos);
            for (idx = 0; idx < posData.count; ++idx) {
                JapaneseTokenizer.Position backPosData = positions.get(posData.backPos[idx]);
                n = idx;
                int n3 = pos;
                String toNodeID = n3 + "." + n;
                n = posData.backIndex[idx];
                n3 = posData.backPos[idx];
                String fromNodeID = n3 + "." + n;
                sb.append("  ");
                sb.append(fromNodeID);
                sb.append(" -> ");
                sb.append(toNodeID);
                String attrs = toNodeID.equals(this.bestPathMap.get(fromNodeID)) ? " color=\"#40e050\" fontcolor=\"#40a050\" penwidth=3 fontsize=20" : "";
                Dictionary dict = tok.getDict(posData.backType[idx]);
                int wordCost = dict.getWordCost(posData.backID[idx]);
                int bgCost = this.costs.get(backPosData.lastRightID[posData.backIndex[idx]], dict.getLeftId(posData.backID[idx]));
                String surfaceForm = new String(fragment, posData.backPos[idx] - startPos, pos - posData.backPos[idx]);
                sb.append(" [label=\"");
                sb.append(surfaceForm);
                sb.append(' ');
                sb.append(wordCost);
                if (bgCost >= 0) {
                    sb.append('+');
                }
                sb.append(bgCost);
                sb.append("\"");
                sb.append(attrs);
                sb.append("]\n");
            }
        }
        return sb.toString();
    }
}

