/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.lucene.util.Constants;

public final class RamUsageEstimator {
    private static boolean COMPRESSED_REFS_ENABLED;
    public static final int NUM_BYTES_OBJECT_REF;
    private static int NUM_BYTES_OBJECT_HEADER;
    public static final int NUM_BYTES_ARRAY_HEADER;
    private static int NUM_BYTES_OBJECT_ALIGNMENT;
    private static Map<Class<?>, Integer> primitiveSizes;
    private static long HASHTABLE_RAM_BYTES_PER_ENTRY;

    private static long alignObjectSize(long size) {
        long l;
        return (size += (long)NUM_BYTES_OBJECT_ALIGNMENT - 1L) - l % (long)NUM_BYTES_OBJECT_ALIGNMENT;
    }

    /*
     * WARNING - void declaration
     */
    public static long shallowSizeOfInstance(Class<?> clazz) {
        void var1_1;
        if (clazz.isArray()) {
            throw new IllegalArgumentException("This method does not work with array classes.");
        }
        if (clazz.isPrimitive()) {
            return primitiveSizes.get(clazz).intValue();
        }
        long size322 = NUM_BYTES_OBJECT_HEADER;
        while (clazz != null) {
            Field[] fields;
            Class<?> target = clazz;
            try {
                fields = AccessController.doPrivileged(target::getDeclaredFields);
            }
            catch (AccessControlException e) {
                void var3_5;
                throw new RuntimeException("Can't access fields of class: " + (Class)var3_5, e);
            }
            Field[] fieldArray = fields;
            int n = fields.length;
            for (int i = 0; i < n; ++i) {
                Field f = fieldArray[i];
                if (Modifier.isStatic(f.getModifiers())) continue;
                AnnotatedElement size322 = f;
                long l = size322;
                int size322 = ((Class)(size322 = size322.getType())).isPrimitive() ? primitiveSizes.get(size322) : NUM_BYTES_OBJECT_REF;
                size322 = l + (long)size322;
            }
            clazz = clazz.getSuperclass();
        }
        return RamUsageEstimator.alignObjectSize((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static {
        IdentityHashMap<Class<Comparable<Boolean>>, Integer> primitiveSizesMap = new IdentityHashMap<Class<Comparable<Boolean>>, Integer>();
        primitiveSizesMap.put(Boolean.TYPE, 1);
        primitiveSizesMap.put(Byte.TYPE, 1);
        primitiveSizesMap.put(Character.TYPE, 2);
        primitiveSizesMap.put(Short.TYPE, 2);
        primitiveSizesMap.put(Integer.TYPE, 4);
        primitiveSizesMap.put(Float.TYPE, 4);
        primitiveSizesMap.put(Double.TYPE, 8);
        primitiveSizesMap.put(Long.TYPE, 8);
        primitiveSizes = Collections.unmodifiableMap(primitiveSizesMap);
        if (Constants.JRE_IS_64BIT) {
            void var1_2;
            void var0_1;
            block8: {
                boolean compressedOops = false;
                int objectAlignment = 8;
                try {
                    Object vmOption;
                    Class<?> beanClazz = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
                    Object hotSpotBean = Class.forName("java.lang.management.ManagementFactory").getMethod("getPlatformMXBean", Class.class).invoke(null, beanClazz);
                    if (hotSpotBean == null) break block8;
                    Method getVMOptionMethod = beanClazz.getMethod("getVMOption", String.class);
                    try {
                        vmOption = getVMOptionMethod.invoke(hotSpotBean, "UseCompressedOops");
                        compressedOops = Boolean.parseBoolean(vmOption.getClass().getMethod("getValue", new Class[0]).invoke(vmOption, new Object[0]).toString());
                    }
                    catch (ReflectiveOperationException | RuntimeException exception) {}
                    try {
                        void var3_4;
                        void var2_3;
                        vmOption = var2_3.invoke((Object)var3_4, "ObjectAlignmentInBytes");
                        objectAlignment = Integer.parseInt(vmOption.getClass().getMethod("getValue", new Class[0]).invoke(vmOption, new Object[0]).toString());
                    }
                    catch (ReflectiveOperationException | RuntimeException exception) {}
                }
                catch (ReflectiveOperationException | RuntimeException exception) {}
            }
            COMPRESSED_REFS_ENABLED = var0_1;
            NUM_BYTES_OBJECT_ALIGNMENT = var1_2;
            NUM_BYTES_OBJECT_REF = COMPRESSED_REFS_ENABLED ? 4 : 8;
            NUM_BYTES_OBJECT_HEADER = 8 + NUM_BYTES_OBJECT_REF;
            NUM_BYTES_ARRAY_HEADER = (int)RamUsageEstimator.alignObjectSize(NUM_BYTES_OBJECT_HEADER + 4);
        } else {
            COMPRESSED_REFS_ENABLED = false;
            NUM_BYTES_OBJECT_ALIGNMENT = 8;
            NUM_BYTES_OBJECT_REF = 4;
            NUM_BYTES_OBJECT_HEADER = 8;
            NUM_BYTES_ARRAY_HEADER = 8 + 4;
        }
        RamUsageEstimator.shallowSizeOfInstance(Long.class);
        RamUsageEstimator.shallowSizeOfInstance(String.class);
        HASHTABLE_RAM_BYTES_PER_ENTRY = 2L * (long)NUM_BYTES_OBJECT_REF << 1;
    }
}

